/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment.response;

import com.jelastic.api.Response;
import com.jelastic.api.data.po.MountPoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DependenciesResponse
extends Response {
    public static final String EXPORTS = "exports";
    public static final String MOUNTS = "mounts";
    public static final String ARRAY = "array";
    public static final String NODE_ID = "nodeId";
    Map<Integer, List<MountPoint>> exports = new HashMap<Integer, List<MountPoint>>();
    Map<Integer, List<MountPoint>> mounts = new HashMap<Integer, List<MountPoint>>();

    public DependenciesResponse() {
        super(0);
        this.exports = new HashMap<Integer, List<MountPoint>>();
    }

    public DependenciesResponse(int result, String error) {
        super(result, error);
    }

    public DependenciesResponse(Map<Integer, List<MountPoint>> exports, Map<Integer, List<MountPoint>> mounts) {
        super(0);
        this.exports = exports;
        this.mounts = mounts;
    }

    public Map<Integer, List<MountPoint>> getExports() {
        return this.exports;
    }

    public void setExports(Map<Integer, List<MountPoint>> exports) {
        this.exports = exports;
    }

    public Map<Integer, List<MountPoint>> getMounts() {
        return this.exports;
    }

    public void setMounts(Map<Integer, List<MountPoint>> mounts) {
        this.mounts = mounts;
    }

    @Override
    protected DependenciesResponse _fromJSON(JSONObject json) throws JSONException {
        int j;
        JSONArray arrayJson;
        Integer nodeId;
        int i;
        super._fromJSON(json);
        if (json.has(EXPORTS)) {
            JSONArray exportsJsonArray = json.getJSONArray(EXPORTS);
            for (i = 0; i < exportsJsonArray.length(); ++i) {
                JSONObject exportJsonObject = exportsJsonArray.getJSONObject(i);
                if (!exportJsonObject.has(NODE_ID) || !exportJsonObject.has(ARRAY)) continue;
                ArrayList<MountPoint> exportsPerNode = new ArrayList<MountPoint>();
                nodeId = exportJsonObject.getInt(NODE_ID);
                arrayJson = exportJsonObject.getJSONArray(ARRAY);
                for (j = 0; j < arrayJson.length(); ++j) {
                    exportsPerNode.add(new MountPoint()._fromJSON(arrayJson.getJSONObject(i)));
                }
                if (exportsPerNode.isEmpty()) continue;
                this.exports.put(nodeId, exportsPerNode);
            }
        }
        if (json.has(MOUNTS)) {
            JSONArray mountsJsonArray = json.getJSONArray(MOUNTS);
            for (i = 0; i < mountsJsonArray.length(); ++i) {
                JSONObject mountJsonObject = mountsJsonArray.getJSONObject(i);
                if (!mountJsonObject.has(NODE_ID) || !mountJsonObject.has(ARRAY)) continue;
                ArrayList<MountPoint> mountsPerNode = new ArrayList<MountPoint>();
                nodeId = mountJsonObject.getInt(NODE_ID);
                arrayJson = mountJsonObject.getJSONArray(ARRAY);
                for (j = 0; j < arrayJson.length(); ++j) {
                    mountsPerNode.add(new MountPoint()._fromJSON(arrayJson.getJSONObject(i)));
                }
                if (mountsPerNode.isEmpty()) continue;
                this.mounts.put(nodeId, mountsPerNode);
            }
        }
        return this;
    }

    @Override
    protected JSONObject _toJSON() throws JSONException {
        JSONArray arrayJson;
        JSONObject responseJson = super._toJSON();
        if (this.exports != null) {
            JSONArray exportsJsonArray = new JSONArray();
            for (Integer nodeId : this.exports.keySet()) {
                List<MountPoint> exportsPerNode = this.exports.get(nodeId);
                if (exportsPerNode == null) continue;
                JSONObject exportJsonObject = new JSONObject();
                exportJsonObject.put(NODE_ID, (Object)nodeId);
                arrayJson = new JSONArray();
                for (MountPoint item : exportsPerNode) {
                    arrayJson.put((Object)item._toJSON());
                }
                exportJsonObject.put(ARRAY, (Object)arrayJson);
                exportsJsonArray.put((Object)exportJsonObject);
            }
            responseJson.put(EXPORTS, (Object)exportsJsonArray);
        }
        if (this.mounts != null) {
            JSONArray mountsJsonArray = new JSONArray();
            for (Integer nodeId : this.mounts.keySet()) {
                List<MountPoint> mountsPerNode = this.mounts.get(nodeId);
                if (mountsPerNode == null) continue;
                JSONObject mountJsonObject = new JSONObject();
                mountJsonObject.put(NODE_ID, (Object)nodeId);
                arrayJson = new JSONArray();
                for (MountPoint item : mountsPerNode) {
                    arrayJson.put((Object)item._toJSON());
                }
                mountJsonObject.put(ARRAY, (Object)arrayJson);
                mountsJsonArray.put((Object)mountJsonObject);
            }
            responseJson.put(MOUNTS, (Object)mountsJsonArray);
        }
        return responseJson;
    }
}

