/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment.response;

import com.jelastic.api.Response;
import com.jelastic.api.development.response.interfaces.ArrayItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ArrayResponse
extends Response {
    private Collection<ArrayItem> array;
    private Class className;
    public static final String ARRAY_JSON = "array";

    public ArrayResponse() {
        super(0);
        this.array = new ArrayList<ArrayItem>();
    }

    public ArrayResponse(int result, String error) {
        super(result, error);
    }

    public ArrayResponse(Class generic, Collection<? extends ArrayItem> array) {
        super(0);
        this.className = generic;
        this.array = array;
    }

    public Collection<ArrayItem> getArray() {
        return this.array;
    }

    public void setArray(Collection<? extends ArrayItem> array) {
        this.array = array;
    }

    @Override
    protected ArrayResponse _fromJSON(JSONObject json) throws JSONException {
        super._fromJSON(json);
        if (json.has("className")) {
            String clazzName = json.getString("className").replace(".server", "").replace(".hivext", ".jelastic");
            try {
                this.className = Class.forName(clazzName);
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                Logger.getLogger(ArrayResponse.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.array = new ArrayList<ArrayItem>();
        if (json.has(ARRAY_JSON)) {
            JSONArray arrayJson = json.getJSONArray(ARRAY_JSON);
            for (int i = 0; i < arrayJson.length(); ++i) {
                try {
                    Object item = this.className.newInstance();
                    this.array.add(((ArrayItem)item)._fromJSON(arrayJson.getJSONObject(i)));
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    Logger.getLogger(ArrayResponse.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return this;
    }

    @Override
    protected JSONObject _toJSON() throws JSONException {
        JSONObject json = super._toJSON();
        if (this.array != null) {
            JSONArray arrayJson = new JSONArray();
            for (ArrayItem item : this.array) {
                arrayJson.put((Object)item._toJSON());
            }
            if (this.className != null) {
                json.put("className", (Object)this.className.getCanonicalName());
            }
            json.put(ARRAY_JSON, (Object)arrayJson);
        }
        return json;
    }
}

