/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment.response;

import com.jelastic.api.Response;
import com.jelastic.api.system.persistence.ExtIpAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ArrayExtIPAddressResponse
extends Response {
    private static final String IPS = "ips";
    private static final String DETACHED_IPS = "detachedIps";
    private static final String ATTACHED_IPS = "attachedIps";
    private Map<String, List<ExtIpAddress>> ipAddresses = new HashMap<String, List<ExtIpAddress>>();

    public ArrayExtIPAddressResponse(List<ExtIpAddress> ips) {
        super(0);
        this.ipAddresses = new HashMap<String, List<ExtIpAddress>>();
        this.ipAddresses.put(IPS, ips);
    }

    public ArrayExtIPAddressResponse(List<ExtIpAddress> resultIps, List<ExtIpAddress> changedIps, boolean isAttached) {
        this(resultIps);
        String key = isAttached ? ATTACHED_IPS : DETACHED_IPS;
        this.ipAddresses.put(key, changedIps);
    }

    public ArrayExtIPAddressResponse(int result, String error) {
        super(result, error);
    }

    public ArrayExtIPAddressResponse(Response response) {
        super(response.getResult(), response.getError());
    }

    public List<ExtIpAddress> getValues() {
        return this.ipAddresses.get(IPS);
    }

    @Override
    protected JSONObject _toJSON() throws JSONException {
        JSONObject json = super._toJSON();
        Set<Map.Entry<String, List<ExtIpAddress>>> set = this.ipAddresses.entrySet();
        for (Map.Entry<String, List<ExtIpAddress>> value : set) {
            JSONArray array = new JSONArray();
            String key = value.getKey();
            List<ExtIpAddress> ips = value.getValue();
            if (key == null || ips == null || ips.isEmpty()) continue;
            for (ExtIpAddress ip : ips) {
                array.put((Object)ip.getIpAddress());
            }
            json.put(key, (Object)array);
        }
        return json;
    }

    @Override
    protected ArrayExtIPAddressResponse _fromJSON(JSONObject json) throws JSONException {
        super._fromJSON(json);
        this.ipAddresses = new HashMap<String, List<ExtIpAddress>>();
        if (json.has(IPS)) {
            this.fillIpsMap(json, IPS);
        }
        if (json.has(ATTACHED_IPS)) {
            this.fillIpsMap(json, ATTACHED_IPS);
        }
        if (json.has(DETACHED_IPS)) {
            this.fillIpsMap(json, DETACHED_IPS);
        }
        return this;
    }

    private void fillIpsMap(JSONObject json, String key) throws JSONException {
        JSONArray array = json.getJSONArray(key);
        ArrayList<ExtIpAddress> values = new ArrayList<ExtIpAddress>();
        for (int i = 0; i < array.length(); ++i) {
            values.add(new ExtIpAddress(array.getString(i), true));
        }
        if (values.size() > 0) {
            this.ipAddresses.put(key, values);
        }
    }
}

