/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.environment;

import com.jelastic.api.AbstractService;
import com.jelastic.api.Callback;
import com.jelastic.api.Response;
import com.jelastic.api.client.annotation.JelasticModuleName;
import com.jelastic.api.data.response.ObjectsCountResponse;
import com.jelastic.api.development.response.ScriptEvalResponse;
import com.jelastic.api.development.response.interfaces.ArrayResponse;
import com.jelastic.api.environment.response.EnvironmentInfoResponse;
import com.jelastic.api.environment.response.EnvironmentInfoResponses;
import com.jelastic.api.environment.response.ExecResponse;
import com.jelastic.api.environment.response.FilesListResponse;
import com.jelastic.api.environment.response.LogReadResponse;
import com.jelastic.api.environment.response.LogsListResponse;
import com.jelastic.api.environment.response.NodeSSHResponse;
import com.jelastic.api.environment.response.NodeSSHResponses;
import com.jelastic.api.environment.response.ObjectResponse;
import com.jelastic.api.environment.response.RegistryInfoResponse;
import com.jelastic.api.statistic.response.EnvironmentStatisticResponse;
import com.jelastic.api.statistic.response.EnvironmentsStatisticResponse;
import java.util.HashMap;
import java.util.Map;

@JelasticModuleName(name="jelastic")
public class Control
extends AbstractService {
    public static String SERVICE_PATH = "environment/control/";
    private String serviceUrl = SERVER_URL + SERVICE_PATH;
    private String appid = null;
    private String session = null;
    private String client_source = null;

    public Control() {
    }

    public Control(Map _params) {
        this((String)_params.get("appid"), (String)_params.get("session"), (String)_params.get("serviceUrl"));
        String serverUrl = (String)_params.get("serverUrl");
        if (serverUrl != null) {
            this.setServerUrl(serverUrl);
        }
    }

    public Control(String appid, String session, String serviceUrl) {
        if (appid != null) {
            this.appid = appid;
        }
        if (session != null) {
            this.session = session;
        }
        if (serviceUrl != null) {
            this.serviceUrl = serviceUrl;
        }
    }

    public Control(String appid, String session) {
        this(appid, session, null);
    }

    public Control(String appid) {
        this(appid, null, null);
    }

    public String getAppid() {
        return this.appid;
    }

    public Control setAppid(String appid) {
        this.appid = appid;
        return this;
    }

    public String getSession() {
        return this.session;
    }

    public Control setSession(String session) {
        this.session = session;
        return this;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public Control setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
        return this;
    }

    public String getServerUrl() {
        return this.serviceUrl;
    }

    public Control setServerUrl(String serverUrl) {
        this.serviceUrl = serverUrl + SERVICE_PATH;
        return this;
    }

    public Control setClientSource(String client_source) {
        this.client_source = client_source;
        return this;
    }

    public String getClientSource() {
        return this.client_source;
    }

    public Response deleteEnv(String envName, String session, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/deleteenv", _params, Response.class);
    }

    public Response deleteEnv(String envName, String session, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/deleteenv", _params, headers, Response.class);
    }

    public Control deleteEnv(final String envName, final String session, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.deleteEnv(envName, session, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deleteEnv(final String envName, final String session, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.deleteEnv(envName, session, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response deleteEnv(String session, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/deleteenv", _params, Response.class);
    }

    public Response deleteEnv(String session, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/deleteenv", _params, headers, Response.class);
    }

    public Control deleteEnv(final String session, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.deleteEnv(session, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deleteEnv(final String session, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.deleteEnv(session, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response deleteEnv(String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/deleteenv", _params, Response.class);
    }

    public Response deleteEnv(String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/deleteenv", _params, headers, Response.class);
    }

    public Control deleteEnv(final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.deleteEnv(password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deleteEnv(final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.deleteEnv(password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response deleteEnv(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/deleteenv", _params, Response.class);
    }

    public Response deleteEnv(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/deleteenv", _params, headers, Response.class);
    }

    public Response startEnv(String envName, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/startenv", _params, Response.class);
    }

    public Response startEnv(String envName, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/startenv", _params, headers, Response.class);
    }

    public Control startEnv(final String envName, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.startEnv(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control startEnv(final String envName, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.startEnv(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response startEnv(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/startenv", _params, Response.class);
    }

    public Response startEnv(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/startenv", _params, headers, Response.class);
    }

    public Control startEnv(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.startEnv(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control startEnv(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.startEnv(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response startEnv() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/startenv", _params, Response.class);
    }

    public Control startEnv(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.startEnv();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response startEnv(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/startenv", _params, Response.class);
    }

    public Response startEnv(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/startenv", _params, headers, Response.class);
    }

    public Response stopEnv(String envName, String session, int status) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("status", status + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, Response.class);
    }

    public Response stopEnv(String envName, String session, int status, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("status", status + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, headers, Response.class);
    }

    public Control stopEnv(final String envName, final String session, final int status, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv(envName, session, status);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control stopEnv(final String envName, final String session, final int status, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv(envName, session, status);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response stopEnv(String envName, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, Response.class);
    }

    public Response stopEnv(String envName, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, headers, Response.class);
    }

    public Control stopEnv(final String envName, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control stopEnv(final String envName, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response stopEnv(String session, int status) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("status", status + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, Response.class);
    }

    public Response stopEnv(String session, int status, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("status", status + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, headers, Response.class);
    }

    public Control stopEnv(final String session, final int status, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv(session, status);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control stopEnv(final String session, final int status, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv(session, status);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response stopEnv(int status) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("status", status + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, Response.class);
    }

    public Response stopEnv(int status, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("status", status + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, headers, Response.class);
    }

    public Control stopEnv(final int status, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv(status);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control stopEnv(final int status, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv(status);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response stopEnv(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, Response.class);
    }

    public Response stopEnv(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, headers, Response.class);
    }

    public Control stopEnv(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control stopEnv(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response stopEnv() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, Response.class);
    }

    public Control stopEnv(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.stopEnv();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response stopEnv(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, Response.class);
    }

    public Response stopEnv(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/stopenv", _params, headers, Response.class);
    }

    public Response sleepEnv(String envName, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/sleepenv", _params, Response.class);
    }

    public Response sleepEnv(String envName, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/sleepenv", _params, headers, Response.class);
    }

    public Control sleepEnv(final String envName, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.sleepEnv(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control sleepEnv(final String envName, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.sleepEnv(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response sleepEnv(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/sleepenv", _params, Response.class);
    }

    public Response sleepEnv(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/sleepenv", _params, headers, Response.class);
    }

    public Control sleepEnv(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.sleepEnv(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control sleepEnv(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.sleepEnv(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response sleepEnv() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/sleepenv", _params, Response.class);
    }

    public Control sleepEnv(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.sleepEnv();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response sleepEnv(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/sleepenv", _params, Response.class);
    }

    public Response sleepEnv(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/sleepenv", _params, headers, Response.class);
    }

    public ArrayResponse getTemplates(String appid, String session, String type, boolean showUnpublished) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("type", type);
        _params.put("showUnpublished", showUnpublished + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/gettemplates", _params, ArrayResponse.class);
    }

    public ArrayResponse getTemplates(String appid, String session, String type, boolean showUnpublished, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("type", type);
        _params.put("showUnpublished", showUnpublished + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/gettemplates", _params, headers, ArrayResponse.class);
    }

    public Control getTemplates(final String appid, final String session, final String type, final boolean showUnpublished, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(appid, session, type, showUnpublished);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getTemplates(final String appid, final String session, final String type, final boolean showUnpublished, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(appid, session, type, showUnpublished);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getTemplates(String appid, String session, String type) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("type", type);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/gettemplates", _params, ArrayResponse.class);
    }

    public ArrayResponse getTemplates(String appid, String session, String type, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("type", type);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/gettemplates", _params, headers, ArrayResponse.class);
    }

    public Control getTemplates(final String appid, final String session, final String type, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(appid, session, type);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getTemplates(final String appid, final String session, final String type, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(appid, session, type);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getTemplates(String appid, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/gettemplates", _params, ArrayResponse.class);
    }

    public ArrayResponse getTemplates(String appid, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/gettemplates", _params, headers, ArrayResponse.class);
    }

    public Control getTemplates(final String appid, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getTemplates(final String appid, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getTemplates(String session, String type, boolean showUnpublished) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("type", type);
        _params.put("showUnpublished", showUnpublished + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplates", _params, ArrayResponse.class);
    }

    public ArrayResponse getTemplates(String session, String type, boolean showUnpublished, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("type", type);
        _params.put("showUnpublished", showUnpublished + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplates", _params, headers, ArrayResponse.class);
    }

    public Control getTemplates(final String session, final String type, final boolean showUnpublished, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(session, type, showUnpublished);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getTemplates(final String session, final String type, final boolean showUnpublished, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(session, type, showUnpublished);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getTemplates(String type, boolean showUnpublished) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("type", type);
        _params.put("showUnpublished", showUnpublished + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplates", _params, ArrayResponse.class);
    }

    public ArrayResponse getTemplates(String type, boolean showUnpublished, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("type", type);
        _params.put("showUnpublished", showUnpublished + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplates", _params, headers, ArrayResponse.class);
    }

    public Control getTemplates(final String type, final boolean showUnpublished, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(type, showUnpublished);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getTemplates(final String type, final boolean showUnpublished, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(type, showUnpublished);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getTemplates(String type) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("type", type);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplates", _params, ArrayResponse.class);
    }

    public ArrayResponse getTemplates(String type, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("type", type);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplates", _params, headers, ArrayResponse.class);
    }

    public Control getTemplates(final String type, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(type);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getTemplates(final String type, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates(type);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getTemplates() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplates", _params, ArrayResponse.class);
    }

    public Control getTemplates(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getTemplates();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getTemplates(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplates", _params, ArrayResponse.class);
    }

    public ArrayResponse getTemplates(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplates", _params, headers, ArrayResponse.class);
    }

    public NodeSSHResponse restartNodeById(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/restartnodebyid", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse restartNodeById(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/restartnodebyid", _params, headers, NodeSSHResponse.class);
    }

    public Control restartNodeById(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.restartNodeById(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodeById(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.restartNodeById(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse restartNodeById(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/restartnodebyid", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse restartNodeById(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/restartnodebyid", _params, headers, NodeSSHResponse.class);
    }

    public Control restartNodeById(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.restartNodeById(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodeById(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.restartNodeById(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse restartNodeById(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/restartnodebyid", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse restartNodeById(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/restartnodebyid", _params, headers, NodeSSHResponse.class);
    }

    public Control restartNodeById(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.restartNodeById(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodeById(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.restartNodeById(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse restartNodeById(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/restartnodebyid", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse restartNodeById(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/restartnodebyid", _params, headers, NodeSSHResponse.class);
    }

    public NodeSSHResponses restartServices(String envName, String session, String nodeGroup, int nodeId, Integer delay, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses restartServices(String envName, String session, String nodeGroup, int nodeId, Integer delay, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, headers, NodeSSHResponses.class);
    }

    public Control restartServices(final String envName, final String session, final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(envName, session, nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartServices(final String envName, final String session, final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(envName, session, nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses restartServices(String envName, String session, String nodeGroup, int nodeId, Integer delay) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses restartServices(String envName, String session, String nodeGroup, int nodeId, Integer delay, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, headers, NodeSSHResponses.class);
    }

    public Control restartServices(final String envName, final String session, final String nodeGroup, final int nodeId, final Integer delay, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(envName, session, nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartServices(final String envName, final String session, final String nodeGroup, final int nodeId, final Integer delay, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(envName, session, nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses restartServices(String envName, String session, String nodeGroup, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses restartServices(String envName, String session, String nodeGroup, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, headers, NodeSSHResponses.class);
    }

    public Control restartServices(final String envName, final String session, final String nodeGroup, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(envName, session, nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartServices(final String envName, final String session, final String nodeGroup, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(envName, session, nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses restartServices(String session, String nodeGroup, int nodeId, Integer delay, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses restartServices(String session, String nodeGroup, int nodeId, Integer delay, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, headers, NodeSSHResponses.class);
    }

    public Control restartServices(final String session, final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(session, nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartServices(final String session, final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(session, nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses restartServices(String nodeGroup, int nodeId, Integer delay, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses restartServices(String nodeGroup, int nodeId, Integer delay, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, headers, NodeSSHResponses.class);
    }

    public Control restartServices(final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartServices(final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses restartServices(String session, String nodeGroup, int nodeId, Integer delay) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses restartServices(String session, String nodeGroup, int nodeId, Integer delay, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, headers, NodeSSHResponses.class);
    }

    public Control restartServices(final String session, final String nodeGroup, final int nodeId, final Integer delay, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(session, nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartServices(final String session, final String nodeGroup, final int nodeId, final Integer delay, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(session, nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses restartServices(String nodeGroup, int nodeId, Integer delay) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses restartServices(String nodeGroup, int nodeId, Integer delay, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, headers, NodeSSHResponses.class);
    }

    public Control restartServices(final String nodeGroup, final int nodeId, final Integer delay, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartServices(final String nodeGroup, final int nodeId, final Integer delay, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses restartServices(String session, String nodeGroup, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses restartServices(String session, String nodeGroup, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, headers, NodeSSHResponses.class);
    }

    public Control restartServices(final String session, final String nodeGroup, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(session, nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartServices(final String session, final String nodeGroup, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(session, nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses restartServices(String nodeGroup, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses restartServices(String nodeGroup, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, headers, NodeSSHResponses.class);
    }

    public Control restartServices(final String nodeGroup, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartServices(final String nodeGroup, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.restartServices(nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses restartServices(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses restartServices(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/restartservices", _params, headers, NodeSSHResponses.class);
    }

    public Response restartContainerById(String envName, String session, int nodeid) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartcontainerbyid", _params, Response.class);
    }

    public Response restartContainerById(String envName, String session, int nodeid, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartcontainerbyid", _params, headers, Response.class);
    }

    public Control restartContainerById(final String envName, final String session, final int nodeid, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartContainerById(envName, session, nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartContainerById(final String envName, final String session, final int nodeid, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartContainerById(envName, session, nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartContainerById(String session, int nodeid) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartcontainerbyid", _params, Response.class);
    }

    public Response restartContainerById(String session, int nodeid, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartcontainerbyid", _params, headers, Response.class);
    }

    public Control restartContainerById(final String session, final int nodeid, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartContainerById(session, nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartContainerById(final String session, final int nodeid, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartContainerById(session, nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartContainerById(int nodeid) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartcontainerbyid", _params, Response.class);
    }

    public Response restartContainerById(int nodeid, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartcontainerbyid", _params, headers, Response.class);
    }

    public Control restartContainerById(final int nodeid, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartContainerById(nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartContainerById(final int nodeid, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartContainerById(nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartContainerById(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartcontainerbyid", _params, Response.class);
    }

    public Response restartContainerById(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartcontainerbyid", _params, headers, Response.class);
    }

    public Response restartNodes(String envName, String session, String nodeGroup, int nodeId, Integer delay, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, Response.class);
    }

    public Response restartNodes(String envName, String session, String nodeGroup, int nodeId, Integer delay, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, headers, Response.class);
    }

    public Control restartNodes(final String envName, final String session, final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(envName, session, nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodes(final String envName, final String session, final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(envName, session, nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartNodes(String envName, String session, String nodeGroup, int nodeId, Integer delay) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, Response.class);
    }

    public Response restartNodes(String envName, String session, String nodeGroup, int nodeId, Integer delay, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, headers, Response.class);
    }

    public Control restartNodes(final String envName, final String session, final String nodeGroup, final int nodeId, final Integer delay, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(envName, session, nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodes(final String envName, final String session, final String nodeGroup, final int nodeId, final Integer delay, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(envName, session, nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartNodes(String envName, String session, String nodeGroup, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, Response.class);
    }

    public Response restartNodes(String envName, String session, String nodeGroup, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, headers, Response.class);
    }

    public Control restartNodes(final String envName, final String session, final String nodeGroup, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(envName, session, nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodes(final String envName, final String session, final String nodeGroup, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(envName, session, nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartNodes(String session, String nodeGroup, int nodeId, Integer delay, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, Response.class);
    }

    public Response restartNodes(String session, String nodeGroup, int nodeId, Integer delay, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, headers, Response.class);
    }

    public Control restartNodes(final String session, final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(session, nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodes(final String session, final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(session, nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartNodes(String nodeGroup, int nodeId, Integer delay, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, Response.class);
    }

    public Response restartNodes(String nodeGroup, int nodeId, Integer delay, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, headers, Response.class);
    }

    public Control restartNodes(final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodes(final String nodeGroup, final int nodeId, final Integer delay, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(nodeGroup, nodeId, delay, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartNodes(String session, String nodeGroup, int nodeId, Integer delay) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, Response.class);
    }

    public Response restartNodes(String session, String nodeGroup, int nodeId, Integer delay, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, headers, Response.class);
    }

    public Control restartNodes(final String session, final String nodeGroup, final int nodeId, final Integer delay, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(session, nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodes(final String session, final String nodeGroup, final int nodeId, final Integer delay, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(session, nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartNodes(String nodeGroup, int nodeId, Integer delay) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, Response.class);
    }

    public Response restartNodes(String nodeGroup, int nodeId, Integer delay, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, headers, Response.class);
    }

    public Control restartNodes(final String nodeGroup, final int nodeId, final Integer delay, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodes(final String nodeGroup, final int nodeId, final Integer delay, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(nodeGroup, nodeId, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartNodes(String session, String nodeGroup, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, Response.class);
    }

    public Response restartNodes(String session, String nodeGroup, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, headers, Response.class);
    }

    public Control restartNodes(final String session, final String nodeGroup, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(session, nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodes(final String session, final String nodeGroup, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(session, nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartNodes(String nodeGroup, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, Response.class);
    }

    public Response restartNodes(String nodeGroup, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, headers, Response.class);
    }

    public Control restartNodes(final String nodeGroup, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restartNodes(final String nodeGroup, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restartNodes(nodeGroup, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restartNodes(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, Response.class);
    }

    public Response restartNodes(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restartnodes", _params, headers, Response.class);
    }

    public Response setCloudletsCountById(String envName, String session, int count, int nodeid, int flexibleCloudlets, int fixedCloudlets) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("count", count + "");
        _params.put("nodeid", nodeid + "");
        _params.put("flexibleCloudlets", flexibleCloudlets + "");
        _params.put("fixedCloudlets", fixedCloudlets + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcloudletscountbyid", _params, Response.class);
    }

    public Response setCloudletsCountById(String envName, String session, int count, int nodeid, int flexibleCloudlets, int fixedCloudlets, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("count", count + "");
        _params.put("nodeid", nodeid + "");
        _params.put("flexibleCloudlets", flexibleCloudlets + "");
        _params.put("fixedCloudlets", fixedCloudlets + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcloudletscountbyid", _params, headers, Response.class);
    }

    public Control setCloudletsCountById(final String envName, final String session, final int count, final int nodeid, final int flexibleCloudlets, final int fixedCloudlets, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setCloudletsCountById(envName, session, count, nodeid, flexibleCloudlets, fixedCloudlets);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setCloudletsCountById(final String envName, final String session, final int count, final int nodeid, final int flexibleCloudlets, final int fixedCloudlets, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setCloudletsCountById(envName, session, count, nodeid, flexibleCloudlets, fixedCloudlets);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setCloudletsCountById(String session, int count, int nodeid, int flexibleCloudlets, int fixedCloudlets) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("count", count + "");
        _params.put("nodeid", nodeid + "");
        _params.put("flexibleCloudlets", flexibleCloudlets + "");
        _params.put("fixedCloudlets", fixedCloudlets + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcloudletscountbyid", _params, Response.class);
    }

    public Response setCloudletsCountById(String session, int count, int nodeid, int flexibleCloudlets, int fixedCloudlets, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("count", count + "");
        _params.put("nodeid", nodeid + "");
        _params.put("flexibleCloudlets", flexibleCloudlets + "");
        _params.put("fixedCloudlets", fixedCloudlets + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcloudletscountbyid", _params, headers, Response.class);
    }

    public Control setCloudletsCountById(final String session, final int count, final int nodeid, final int flexibleCloudlets, final int fixedCloudlets, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setCloudletsCountById(session, count, nodeid, flexibleCloudlets, fixedCloudlets);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setCloudletsCountById(final String session, final int count, final int nodeid, final int flexibleCloudlets, final int fixedCloudlets, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setCloudletsCountById(session, count, nodeid, flexibleCloudlets, fixedCloudlets);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setCloudletsCountById(int count, int nodeid, int flexibleCloudlets, int fixedCloudlets) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("count", count + "");
        _params.put("nodeid", nodeid + "");
        _params.put("flexibleCloudlets", flexibleCloudlets + "");
        _params.put("fixedCloudlets", fixedCloudlets + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcloudletscountbyid", _params, Response.class);
    }

    public Response setCloudletsCountById(int count, int nodeid, int flexibleCloudlets, int fixedCloudlets, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("count", count + "");
        _params.put("nodeid", nodeid + "");
        _params.put("flexibleCloudlets", flexibleCloudlets + "");
        _params.put("fixedCloudlets", fixedCloudlets + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcloudletscountbyid", _params, headers, Response.class);
    }

    public Control setCloudletsCountById(final int count, final int nodeid, final int flexibleCloudlets, final int fixedCloudlets, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setCloudletsCountById(count, nodeid, flexibleCloudlets, fixedCloudlets);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setCloudletsCountById(final int count, final int nodeid, final int flexibleCloudlets, final int fixedCloudlets, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setCloudletsCountById(count, nodeid, flexibleCloudlets, fixedCloudlets);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setCloudletsCountById(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcloudletscountbyid", _params, Response.class);
    }

    public Response setCloudletsCountById(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcloudletscountbyid", _params, headers, Response.class);
    }

    public NodeSSHResponses deployApp(String envName, String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String envName, String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String envName, final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(envName, session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String envName, final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(envName, session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String envName, String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String envName, String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String envName, final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(envName, session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String envName, final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(envName, session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String envName, String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String envName, String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String envName, final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(envName, session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String envName, final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(envName, session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String envName, String session, String fileUrl, String fileName, String context, boolean atomicDeploy) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String envName, String session, String fileUrl, String fileName, String context, boolean atomicDeploy, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String envName, final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(envName, session, fileUrl, fileName, context, atomicDeploy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String envName, final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(envName, session, fileUrl, fileName, context, atomicDeploy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String envName, String session, String fileUrl, String fileName, String context) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String envName, String session, String fileUrl, String fileName, String context, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String envName, final String session, final String fileUrl, final String fileName, final String context, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(envName, session, fileUrl, fileName, context);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String envName, final String session, final String fileUrl, final String fileName, final String context, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(envName, session, fileUrl, fileName, context);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, String hooks, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("hooks", hooks);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final String hooks, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(fileUrl, fileName, context, atomicDeploy, delay, nodeGroup, hooks);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String session, String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(session, fileUrl, fileName, context, atomicDeploy, delay, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String fileUrl, String fileName, String context, boolean atomicDeploy, int delay, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("delay", delay + "");
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(fileUrl, fileName, context, atomicDeploy, delay, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final int delay, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(fileUrl, fileName, context, atomicDeploy, delay, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String session, String fileUrl, String fileName, String context, boolean atomicDeploy) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String session, String fileUrl, String fileName, String context, boolean atomicDeploy, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(session, fileUrl, fileName, context, atomicDeploy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String session, final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(session, fileUrl, fileName, context, atomicDeploy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String fileUrl, String fileName, String context, boolean atomicDeploy) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String fileUrl, String fileName, String context, boolean atomicDeploy, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("atomicDeploy", atomicDeploy + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(fileUrl, fileName, context, atomicDeploy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String fileUrl, final String fileName, final String context, final boolean atomicDeploy, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(fileUrl, fileName, context, atomicDeploy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String session, String fileUrl, String fileName, String context) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String session, String fileUrl, String fileName, String context, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String session, final String fileUrl, final String fileName, final String context, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(session, fileUrl, fileName, context);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String session, final String fileUrl, final String fileName, final String context, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(session, fileUrl, fileName, context);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(String fileUrl, String fileName, String context) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(String fileUrl, String fileName, String context, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("fileUrl", fileUrl);
        _params.put("fileName", fileName);
        _params.put("context", context);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Control deployApp(final String fileUrl, final String fileName, final String context, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(fileUrl, fileName, context);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control deployApp(final String fileUrl, final String fileName, final String context, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.deployApp(fileUrl, fileName, context);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses deployApp(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses deployApp(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/deployapp", _params, headers, NodeSSHResponses.class);
    }

    public Response removeApp(String envName, String session, String context, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("context", context);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeapp", _params, Response.class);
    }

    public Response removeApp(String envName, String session, String context, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("context", context);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeapp", _params, headers, Response.class);
    }

    public Control removeApp(final String envName, final String session, final String context, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeApp(envName, session, context, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeApp(final String envName, final String session, final String context, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeApp(envName, session, context, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeApp(String session, String context, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("context", context);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeapp", _params, Response.class);
    }

    public Response removeApp(String session, String context, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("context", context);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeapp", _params, headers, Response.class);
    }

    public Control removeApp(final String session, final String context, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeApp(session, context, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeApp(final String session, final String context, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeApp(session, context, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeApp(String context, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("context", context);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeapp", _params, Response.class);
    }

    public Response removeApp(String context, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("context", context);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeapp", _params, headers, Response.class);
    }

    public Control removeApp(final String context, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeApp(context, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeApp(final String context, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeApp(context, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeApp(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeapp", _params, Response.class);
    }

    public Response removeApp(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeapp", _params, headers, Response.class);
    }

    public Response renameApp(String envName, String session, String oldcontext, String newcontext, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("oldcontext", oldcontext);
        _params.put("newcontext", newcontext);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/renameapp", _params, Response.class);
    }

    public Response renameApp(String envName, String session, String oldcontext, String newcontext, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("oldcontext", oldcontext);
        _params.put("newcontext", newcontext);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/renameapp", _params, headers, Response.class);
    }

    public Control renameApp(final String envName, final String session, final String oldcontext, final String newcontext, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.renameApp(envName, session, oldcontext, newcontext, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control renameApp(final String envName, final String session, final String oldcontext, final String newcontext, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.renameApp(envName, session, oldcontext, newcontext, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response renameApp(String session, String oldcontext, String newcontext, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("oldcontext", oldcontext);
        _params.put("newcontext", newcontext);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/renameapp", _params, Response.class);
    }

    public Response renameApp(String session, String oldcontext, String newcontext, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("oldcontext", oldcontext);
        _params.put("newcontext", newcontext);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/renameapp", _params, headers, Response.class);
    }

    public Control renameApp(final String session, final String oldcontext, final String newcontext, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.renameApp(session, oldcontext, newcontext, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control renameApp(final String session, final String oldcontext, final String newcontext, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.renameApp(session, oldcontext, newcontext, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response renameApp(String oldcontext, String newcontext, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("oldcontext", oldcontext);
        _params.put("newcontext", newcontext);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/renameapp", _params, Response.class);
    }

    public Response renameApp(String oldcontext, String newcontext, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("oldcontext", oldcontext);
        _params.put("newcontext", newcontext);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/renameapp", _params, headers, Response.class);
    }

    public Control renameApp(final String oldcontext, final String newcontext, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.renameApp(oldcontext, newcontext, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control renameApp(final String oldcontext, final String newcontext, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.renameApp(oldcontext, newcontext, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response renameApp(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/renameapp", _params, Response.class);
    }

    public Response renameApp(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/renameapp", _params, headers, Response.class);
    }

    public EnvironmentStatisticResponse getSumStat(String envName, String session, long duration, String endtime) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getSumStat(String envName, String session, long duration, String endtime, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getSumStat(final String envName, final String session, final long duration, final String endtime, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(envName, session, duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getSumStat(final String envName, final String session, final long duration, final String endtime, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(envName, session, duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getSumStat(String envName, String session, long duration) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getSumStat(String envName, String session, long duration, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getSumStat(final String envName, final String session, final long duration, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(envName, session, duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getSumStat(final String envName, final String session, final long duration, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(envName, session, duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getSumStat(String session, long duration, String endtime) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getSumStat(String session, long duration, String endtime, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getSumStat(final String session, final long duration, final String endtime, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(session, duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getSumStat(final String session, final long duration, final String endtime, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(session, duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getSumStat(long duration, String endtime) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getSumStat(long duration, String endtime, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getSumStat(final long duration, final String endtime, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getSumStat(final long duration, final String endtime, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getSumStat(String session, long duration) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getSumStat(String session, long duration, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getSumStat(final String session, final long duration, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(session, duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getSumStat(final String session, final long duration, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(session, duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getSumStat(long duration) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getSumStat(long duration, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getSumStat(final long duration, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getSumStat(final long duration, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getSumStat(duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getSumStat(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getSumStat(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getsumstat", _params, headers, EnvironmentStatisticResponse.class);
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String envName, String session, long duration, String endtime) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, EnvironmentsStatisticResponse.class);
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String envName, String session, long duration, String endtime, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, headers, EnvironmentsStatisticResponse.class);
    }

    public Control getAllSumStatByUid(final String envName, final String session, final long duration, final String endtime, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(envName, session, duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getAllSumStatByUid(final String envName, final String session, final long duration, final String endtime, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(envName, session, duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String envName, String session, long duration) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, EnvironmentsStatisticResponse.class);
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String envName, String session, long duration, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, headers, EnvironmentsStatisticResponse.class);
    }

    public Control getAllSumStatByUid(final String envName, final String session, final long duration, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(envName, session, duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getAllSumStatByUid(final String envName, final String session, final long duration, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(envName, session, duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String envName, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, EnvironmentsStatisticResponse.class);
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String envName, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, headers, EnvironmentsStatisticResponse.class);
    }

    public Control getAllSumStatByUid(final String envName, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getAllSumStatByUid(final String envName, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String session, long duration, String endtime) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, EnvironmentsStatisticResponse.class);
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String session, long duration, String endtime, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, headers, EnvironmentsStatisticResponse.class);
    }

    public Control getAllSumStatByUid(final String session, final long duration, final String endtime, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(session, duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getAllSumStatByUid(final String session, final long duration, final String endtime, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(session, duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(long duration, String endtime) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, EnvironmentsStatisticResponse.class);
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(long duration, String endtime, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("endtime", endtime);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, headers, EnvironmentsStatisticResponse.class);
    }

    public Control getAllSumStatByUid(final long duration, final String endtime, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getAllSumStatByUid(final long duration, final String endtime, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(duration, endtime);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String session, long duration) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, EnvironmentsStatisticResponse.class);
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String session, long duration, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, headers, EnvironmentsStatisticResponse.class);
    }

    public Control getAllSumStatByUid(final String session, final long duration, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(session, duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getAllSumStatByUid(final String session, final long duration, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(session, duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(long duration) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, EnvironmentsStatisticResponse.class);
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(long duration, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, headers, EnvironmentsStatisticResponse.class);
    }

    public Control getAllSumStatByUid(final long duration, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getAllSumStatByUid(final long duration, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(duration);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, EnvironmentsStatisticResponse.class);
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, headers, EnvironmentsStatisticResponse.class);
    }

    public Control getAllSumStatByUid(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getAllSumStatByUid(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, EnvironmentsStatisticResponse.class);
    }

    public Control getAllSumStatByUid(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentsStatisticResponse response = Control.this.getAllSumStatByUid();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, EnvironmentsStatisticResponse.class);
    }

    public EnvironmentsStatisticResponse getAllSumStatByUid(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentsStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getallsumstatbyuid", _params, headers, EnvironmentsStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(String envName, String session, long duration, int interval, String endtime, int nodeid, String nodetype, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(String envName, String session, long duration, int interval, String endtime, int nodeid, String nodetype, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final String envName, final String session, final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(envName, session, duration, interval, endtime, nodeid, nodetype, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final String envName, final String session, final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(envName, session, duration, interval, endtime, nodeid, nodetype, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(String envName, String session, long duration, int interval, String endtime, int nodeid, String nodetype) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(String envName, String session, long duration, int interval, String endtime, int nodeid, String nodetype, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final String envName, final String session, final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(envName, session, duration, interval, endtime, nodeid, nodetype);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final String envName, final String session, final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(envName, session, duration, interval, endtime, nodeid, nodetype);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(String envName, String session, long duration, int interval, String endtime, int nodeid) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(String envName, String session, long duration, int interval, String endtime, int nodeid, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final String envName, final String session, final long duration, final int interval, final String endtime, final int nodeid, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(envName, session, duration, interval, endtime, nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final String envName, final String session, final long duration, final int interval, final String endtime, final int nodeid, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(envName, session, duration, interval, endtime, nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(String envName, String session, long duration, int interval) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(String envName, String session, long duration, int interval, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final String envName, final String session, final long duration, final int interval, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(envName, session, duration, interval);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final String envName, final String session, final long duration, final int interval, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(envName, session, duration, interval);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(String session, long duration, int interval, String endtime, int nodeid, String nodetype, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(String session, long duration, int interval, String endtime, int nodeid, String nodetype, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final String session, final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(session, duration, interval, endtime, nodeid, nodetype, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final String session, final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(session, duration, interval, endtime, nodeid, nodetype, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(long duration, int interval, String endtime, int nodeid, String nodetype, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(long duration, int interval, String endtime, int nodeid, String nodetype, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(duration, interval, endtime, nodeid, nodetype, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(duration, interval, endtime, nodeid, nodetype, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(String session, long duration, int interval, String endtime, int nodeid, String nodetype) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(String session, long duration, int interval, String endtime, int nodeid, String nodetype, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final String session, final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(session, duration, interval, endtime, nodeid, nodetype);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final String session, final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(session, duration, interval, endtime, nodeid, nodetype);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(long duration, int interval, String endtime, int nodeid, String nodetype) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(long duration, int interval, String endtime, int nodeid, String nodetype, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("nodetype", nodetype);
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(duration, interval, endtime, nodeid, nodetype);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final long duration, final int interval, final String endtime, final int nodeid, final String nodetype, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(duration, interval, endtime, nodeid, nodetype);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(String session, long duration, int interval, String endtime, int nodeid) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(String session, long duration, int interval, String endtime, int nodeid, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final String session, final long duration, final int interval, final String endtime, final int nodeid, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(session, duration, interval, endtime, nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final String session, final long duration, final int interval, final String endtime, final int nodeid, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(session, duration, interval, endtime, nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(long duration, int interval, String endtime, int nodeid) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(long duration, int interval, String endtime, int nodeid, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("endtime", endtime);
        _params.put("nodeid", nodeid + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final long duration, final int interval, final String endtime, final int nodeid, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(duration, interval, endtime, nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final long duration, final int interval, final String endtime, final int nodeid, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(duration, interval, endtime, nodeid);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(String session, long duration, int interval) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(String session, long duration, int interval, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final String session, final long duration, final int interval, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(session, duration, interval);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final String session, final long duration, final int interval, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(session, duration, interval);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(long duration, int interval) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(long duration, int interval, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("duration", duration + "");
        _params.put("interval", interval + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public Control getStats(final long duration, final int interval, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(duration, interval);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getStats(final long duration, final int interval, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentStatisticResponse response = Control.this.getStats(duration, interval);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentStatisticResponse getStats(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, EnvironmentStatisticResponse.class);
    }

    public EnvironmentStatisticResponse getStats(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentStatisticResponse)this._call(this.appid, this.serviceUrl + "rest/getstats", _params, headers, EnvironmentStatisticResponse.class);
    }

    public EnvironmentInfoResponse getEnvInfo(String envName, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getenvinfo", _params, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponse getEnvInfo(String envName, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getenvinfo", _params, headers, EnvironmentInfoResponse.class);
    }

    public Control getEnvInfo(final String envName, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.getEnvInfo(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getEnvInfo(final String envName, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.getEnvInfo(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponse getEnvInfo(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getenvinfo", _params, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponse getEnvInfo(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getenvinfo", _params, headers, EnvironmentInfoResponse.class);
    }

    public Control getEnvInfo(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.getEnvInfo(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getEnvInfo(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.getEnvInfo(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponse getEnvInfo() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getenvinfo", _params, EnvironmentInfoResponse.class);
    }

    public Control getEnvInfo(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.getEnvInfo();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponse getEnvInfo(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getenvinfo", _params, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponse getEnvInfo(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getenvinfo", _params, headers, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponses getEnvs(String appid, String session, boolean lazy) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("lazy", lazy + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(appid, this.serviceUrl + "rest/getenvs", _params, EnvironmentInfoResponses.class);
    }

    public EnvironmentInfoResponses getEnvs(String appid, String session, boolean lazy, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("lazy", lazy + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(appid, this.serviceUrl + "rest/getenvs", _params, headers, EnvironmentInfoResponses.class);
    }

    public Control getEnvs(final String appid, final String session, final boolean lazy, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs(appid, session, lazy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getEnvs(final String appid, final String session, final boolean lazy, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs(appid, session, lazy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponses getEnvs(String appid, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(appid, this.serviceUrl + "rest/getenvs", _params, EnvironmentInfoResponses.class);
    }

    public EnvironmentInfoResponses getEnvs(String appid, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(appid, this.serviceUrl + "rest/getenvs", _params, headers, EnvironmentInfoResponses.class);
    }

    public Control getEnvs(final String appid, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getEnvs(final String appid, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponses getEnvs(String session, boolean lazy) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("lazy", lazy + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(this.appid, this.serviceUrl + "rest/getenvs", _params, EnvironmentInfoResponses.class);
    }

    public EnvironmentInfoResponses getEnvs(String session, boolean lazy, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("lazy", lazy + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(this.appid, this.serviceUrl + "rest/getenvs", _params, headers, EnvironmentInfoResponses.class);
    }

    public Control getEnvs(final String session, final boolean lazy, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs(session, lazy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getEnvs(final String session, final boolean lazy, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs(session, lazy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponses getEnvs(boolean lazy) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("lazy", lazy + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(this.appid, this.serviceUrl + "rest/getenvs", _params, EnvironmentInfoResponses.class);
    }

    public EnvironmentInfoResponses getEnvs(boolean lazy, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("lazy", lazy + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(this.appid, this.serviceUrl + "rest/getenvs", _params, headers, EnvironmentInfoResponses.class);
    }

    public Control getEnvs(final boolean lazy, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs(lazy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getEnvs(final boolean lazy, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs(lazy);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponses getEnvs(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(this.appid, this.serviceUrl + "rest/getenvs", _params, EnvironmentInfoResponses.class);
    }

    public EnvironmentInfoResponses getEnvs(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(this.appid, this.serviceUrl + "rest/getenvs", _params, headers, EnvironmentInfoResponses.class);
    }

    public Control getEnvs(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getEnvs(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponses getEnvs() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponses)this._call(this.appid, this.serviceUrl + "rest/getenvs", _params, EnvironmentInfoResponses.class);
    }

    public Control getEnvs(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponses response = Control.this.getEnvs();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponses getEnvs(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentInfoResponses)this._call(this.appid, this.serviceUrl + "rest/getenvs", _params, EnvironmentInfoResponses.class);
    }

    public EnvironmentInfoResponses getEnvs(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentInfoResponses)this._call(this.appid, this.serviceUrl + "rest/getenvs", _params, headers, EnvironmentInfoResponses.class);
    }

    public FilesListResponse getLogs(String envName, String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, FilesListResponse.class);
    }

    public FilesListResponse getLogs(String envName, String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, headers, FilesListResponse.class);
    }

    public Control getLogs(final String envName, final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogs(final String envName, final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public FilesListResponse getLogs(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, FilesListResponse.class);
    }

    public FilesListResponse getLogs(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, headers, FilesListResponse.class);
    }

    public Control getLogs(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogs(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public FilesListResponse getLogs(String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, FilesListResponse.class);
    }

    public FilesListResponse getLogs(String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, headers, FilesListResponse.class);
    }

    public Control getLogs(final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogs(final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public FilesListResponse getLogs(int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, FilesListResponse.class);
    }

    public FilesListResponse getLogs(int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, headers, FilesListResponse.class);
    }

    public Control getLogs(final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogs(final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public FilesListResponse getLogs(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, FilesListResponse.class);
    }

    public FilesListResponse getLogs(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, headers, FilesListResponse.class);
    }

    public Control getLogs(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogs(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public FilesListResponse getLogs(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, FilesListResponse.class);
    }

    public FilesListResponse getLogs(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, headers, FilesListResponse.class);
    }

    public Control getLogs(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogs(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                FilesListResponse response = Control.this.getLogs(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public FilesListResponse getLogs(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, FilesListResponse.class);
    }

    public FilesListResponse getLogs(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (FilesListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogs", _params, headers, FilesListResponse.class);
    }

    public LogsListResponse getLogsList(String envName, String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, LogsListResponse.class);
    }

    public LogsListResponse getLogsList(String envName, String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, headers, LogsListResponse.class);
    }

    public Control getLogsList(final String envName, final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogsList(final String envName, final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogsListResponse getLogsList(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, LogsListResponse.class);
    }

    public LogsListResponse getLogsList(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, headers, LogsListResponse.class);
    }

    public Control getLogsList(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogsList(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogsListResponse getLogsList(String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, LogsListResponse.class);
    }

    public LogsListResponse getLogsList(String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, headers, LogsListResponse.class);
    }

    public Control getLogsList(final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogsList(final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogsListResponse getLogsList(int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, LogsListResponse.class);
    }

    public LogsListResponse getLogsList(int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, headers, LogsListResponse.class);
    }

    public Control getLogsList(final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogsList(final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogsListResponse getLogsList(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, LogsListResponse.class);
    }

    public LogsListResponse getLogsList(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, headers, LogsListResponse.class);
    }

    public Control getLogsList(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogsList(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogsListResponse getLogsList(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, LogsListResponse.class);
    }

    public LogsListResponse getLogsList(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, headers, LogsListResponse.class);
    }

    public Control getLogsList(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getLogsList(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogsListResponse response = Control.this.getLogsList(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogsListResponse getLogsList(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, LogsListResponse.class);
    }

    public LogsListResponse getLogsList(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (LogsListResponse)this._call(this.appid, this.serviceUrl + "rest/getlogslist", _params, headers, LogsListResponse.class);
    }

    public Response removeLog(String envName, String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removelog", _params, Response.class);
    }

    public Response removeLog(String envName, String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removelog", _params, headers, Response.class);
    }

    public Control removeLog(final String envName, final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeLog(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeLog(final String envName, final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeLog(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeLog(String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removelog", _params, Response.class);
    }

    public Response removeLog(String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removelog", _params, headers, Response.class);
    }

    public Control removeLog(final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeLog(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeLog(final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeLog(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeLog(int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removelog", _params, Response.class);
    }

    public Response removeLog(int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removelog", _params, headers, Response.class);
    }

    public Control removeLog(final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeLog(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeLog(final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeLog(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeLog(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removelog", _params, Response.class);
    }

    public Response removeLog(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removelog", _params, headers, Response.class);
    }

    public Response clearLog(String envName, String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/clearlog", _params, Response.class);
    }

    public Response clearLog(String envName, String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/clearlog", _params, headers, Response.class);
    }

    public Control clearLog(final String envName, final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.clearLog(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control clearLog(final String envName, final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.clearLog(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response clearLog(String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/clearlog", _params, Response.class);
    }

    public Response clearLog(String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/clearlog", _params, headers, Response.class);
    }

    public Control clearLog(final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.clearLog(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control clearLog(final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.clearLog(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response clearLog(int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/clearlog", _params, Response.class);
    }

    public Response clearLog(int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/clearlog", _params, headers, Response.class);
    }

    public Control clearLog(final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.clearLog(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control clearLog(final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.clearLog(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response clearLog(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/clearlog", _params, Response.class);
    }

    public Response clearLog(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/clearlog", _params, headers, Response.class);
    }

    public LogReadResponse readLog(String envName, String session, int nodeid, String path, Integer from, int count) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("count", count + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, LogReadResponse.class);
    }

    public LogReadResponse readLog(String envName, String session, int nodeid, String path, Integer from, int count, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("count", count + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, headers, LogReadResponse.class);
    }

    public Control readLog(final String envName, final String session, final int nodeid, final String path, final Integer from, final int count, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(envName, session, nodeid, path, from, count);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control readLog(final String envName, final String session, final int nodeid, final String path, final Integer from, final int count, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(envName, session, nodeid, path, from, count);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogReadResponse readLog(String envName, String session, int nodeid, String path, Integer from) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, LogReadResponse.class);
    }

    public LogReadResponse readLog(String envName, String session, int nodeid, String path, Integer from, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, headers, LogReadResponse.class);
    }

    public Control readLog(final String envName, final String session, final int nodeid, final String path, final Integer from, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(envName, session, nodeid, path, from);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control readLog(final String envName, final String session, final int nodeid, final String path, final Integer from, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(envName, session, nodeid, path, from);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogReadResponse readLog(String session, int nodeid, String path, Integer from, int count) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("count", count + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, LogReadResponse.class);
    }

    public LogReadResponse readLog(String session, int nodeid, String path, Integer from, int count, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("count", count + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, headers, LogReadResponse.class);
    }

    public Control readLog(final String session, final int nodeid, final String path, final Integer from, final int count, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(session, nodeid, path, from, count);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control readLog(final String session, final int nodeid, final String path, final Integer from, final int count, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(session, nodeid, path, from, count);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogReadResponse readLog(int nodeid, String path, Integer from, int count) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("count", count + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, LogReadResponse.class);
    }

    public LogReadResponse readLog(int nodeid, String path, Integer from, int count, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("count", count + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, headers, LogReadResponse.class);
    }

    public Control readLog(final int nodeid, final String path, final Integer from, final int count, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(nodeid, path, from, count);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control readLog(final int nodeid, final String path, final Integer from, final int count, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(nodeid, path, from, count);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogReadResponse readLog(String session, int nodeid, String path, Integer from) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, LogReadResponse.class);
    }

    public LogReadResponse readLog(String session, int nodeid, String path, Integer from, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, headers, LogReadResponse.class);
    }

    public Control readLog(final String session, final int nodeid, final String path, final Integer from, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(session, nodeid, path, from);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control readLog(final String session, final int nodeid, final String path, final Integer from, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(session, nodeid, path, from);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogReadResponse readLog(int nodeid, String path, Integer from) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, LogReadResponse.class);
    }

    public LogReadResponse readLog(int nodeid, String path, Integer from, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeid", nodeid + "");
        _params.put("path", path);
        _params.put("from", from + "");
        _params.put("client_source", this.client_source);
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, headers, LogReadResponse.class);
    }

    public Control readLog(final int nodeid, final String path, final Integer from, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(nodeid, path, from);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control readLog(final int nodeid, final String path, final Integer from, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                LogReadResponse response = Control.this.readLog(nodeid, path, from);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public LogReadResponse readLog(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, LogReadResponse.class);
    }

    public LogReadResponse readLog(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (LogReadResponse)this._call(this.appid, this.serviceUrl + "rest/readlog", _params, headers, LogReadResponse.class);
    }

    public ObjectResponse getContainerEnvVars(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvars", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerEnvVars(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvars", _params, headers, ObjectResponse.class);
    }

    public Control getContainerEnvVars(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEnvVars(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerEnvVars(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEnvVars(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerEnvVars(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvars", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerEnvVars(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvars", _params, headers, ObjectResponse.class);
    }

    public Control getContainerEnvVars(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEnvVars(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerEnvVars(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEnvVars(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerEnvVars(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvars", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerEnvVars(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvars", _params, headers, ObjectResponse.class);
    }

    public Control getContainerEnvVars(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEnvVars(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerEnvVars(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEnvVars(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerEnvVars(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvars", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerEnvVars(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvars", _params, headers, ObjectResponse.class);
    }

    public Response setContainerEnvVarsByGroup(String envName, String session, String nodeGroup, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvarsbygroup", _params, Response.class);
    }

    public Response setContainerEnvVarsByGroup(String envName, String session, String nodeGroup, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvarsbygroup", _params, headers, Response.class);
    }

    public Control setContainerEnvVarsByGroup(final String envName, final String session, final String nodeGroup, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVarsByGroup(envName, session, nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEnvVarsByGroup(final String envName, final String session, final String nodeGroup, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVarsByGroup(envName, session, nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEnvVarsByGroup(String session, String nodeGroup, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvarsbygroup", _params, Response.class);
    }

    public Response setContainerEnvVarsByGroup(String session, String nodeGroup, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvarsbygroup", _params, headers, Response.class);
    }

    public Control setContainerEnvVarsByGroup(final String session, final String nodeGroup, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVarsByGroup(session, nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEnvVarsByGroup(final String session, final String nodeGroup, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVarsByGroup(session, nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEnvVarsByGroup(String nodeGroup, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvarsbygroup", _params, Response.class);
    }

    public Response setContainerEnvVarsByGroup(String nodeGroup, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvarsbygroup", _params, headers, Response.class);
    }

    public Control setContainerEnvVarsByGroup(final String nodeGroup, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVarsByGroup(nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEnvVarsByGroup(final String nodeGroup, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVarsByGroup(nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEnvVarsByGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvarsbygroup", _params, Response.class);
    }

    public Response setContainerEnvVarsByGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvarsbygroup", _params, headers, Response.class);
    }

    public Response getContainerEnvVarsByGroup(String envName, String session, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvarsbygroup", _params, Response.class);
    }

    public Response getContainerEnvVarsByGroup(String envName, String session, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvarsbygroup", _params, headers, Response.class);
    }

    public Control getContainerEnvVarsByGroup(final String envName, final String session, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.getContainerEnvVarsByGroup(envName, session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerEnvVarsByGroup(final String envName, final String session, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.getContainerEnvVarsByGroup(envName, session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response getContainerEnvVarsByGroup(String session, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvarsbygroup", _params, Response.class);
    }

    public Response getContainerEnvVarsByGroup(String session, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvarsbygroup", _params, headers, Response.class);
    }

    public Control getContainerEnvVarsByGroup(final String session, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.getContainerEnvVarsByGroup(session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerEnvVarsByGroup(final String session, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.getContainerEnvVarsByGroup(session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response getContainerEnvVarsByGroup(String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvarsbygroup", _params, Response.class);
    }

    public Response getContainerEnvVarsByGroup(String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvarsbygroup", _params, headers, Response.class);
    }

    public Control getContainerEnvVarsByGroup(final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.getContainerEnvVarsByGroup(nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerEnvVarsByGroup(final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.getContainerEnvVarsByGroup(nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response getContainerEnvVarsByGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvarsbygroup", _params, Response.class);
    }

    public Response getContainerEnvVarsByGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/getcontainerenvvarsbygroup", _params, headers, Response.class);
    }

    public Response setContainerEnvVars(String envName, String session, int nodeId, String vars) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvars", _params, Response.class);
    }

    public Response setContainerEnvVars(String envName, String session, int nodeId, String vars, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvars", _params, headers, Response.class);
    }

    public Control setContainerEnvVars(final String envName, final String session, final int nodeId, final String vars, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVars(envName, session, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEnvVars(final String envName, final String session, final int nodeId, final String vars, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVars(envName, session, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEnvVars(String session, int nodeId, String vars) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvars", _params, Response.class);
    }

    public Response setContainerEnvVars(String session, int nodeId, String vars, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvars", _params, headers, Response.class);
    }

    public Control setContainerEnvVars(final String session, final int nodeId, final String vars, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVars(session, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEnvVars(final String session, final int nodeId, final String vars, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVars(session, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEnvVars(int nodeId, String vars) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvars", _params, Response.class);
    }

    public Response setContainerEnvVars(int nodeId, String vars, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvars", _params, headers, Response.class);
    }

    public Control setContainerEnvVars(final int nodeId, final String vars, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVars(nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEnvVars(final int nodeId, final String vars, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEnvVars(nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEnvVars(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvars", _params, Response.class);
    }

    public Response setContainerEnvVars(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerenvvars", _params, headers, Response.class);
    }

    public ObjectResponse getContainerRunCmd(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerruncmd", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerRunCmd(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerruncmd", _params, headers, ObjectResponse.class);
    }

    public Control getContainerRunCmd(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunCmd(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerRunCmd(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunCmd(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerRunCmd(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerruncmd", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerRunCmd(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerruncmd", _params, headers, ObjectResponse.class);
    }

    public Control getContainerRunCmd(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunCmd(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerRunCmd(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunCmd(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerRunCmd(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerruncmd", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerRunCmd(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerruncmd", _params, headers, ObjectResponse.class);
    }

    public Control getContainerRunCmd(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunCmd(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerRunCmd(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunCmd(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerRunCmd(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerruncmd", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerRunCmd(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerruncmd", _params, headers, ObjectResponse.class);
    }

    public Response setContainerRunCmd(String envName, String session, int nodeId, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, Response.class);
    }

    public Response setContainerRunCmd(String envName, String session, int nodeId, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, headers, Response.class);
    }

    public Control setContainerRunCmd(final String envName, final String session, final int nodeId, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(envName, session, nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerRunCmd(final String envName, final String session, final int nodeId, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(envName, session, nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerRunCmd(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, Response.class);
    }

    public Response setContainerRunCmd(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, headers, Response.class);
    }

    public Control setContainerRunCmd(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerRunCmd(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerRunCmd(String session, int nodeId, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, Response.class);
    }

    public Response setContainerRunCmd(String session, int nodeId, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, headers, Response.class);
    }

    public Control setContainerRunCmd(final String session, final int nodeId, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(session, nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerRunCmd(final String session, final int nodeId, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(session, nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerRunCmd(int nodeId, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, Response.class);
    }

    public Response setContainerRunCmd(int nodeId, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, headers, Response.class);
    }

    public Control setContainerRunCmd(final int nodeId, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerRunCmd(final int nodeId, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerRunCmd(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, Response.class);
    }

    public Response setContainerRunCmd(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, headers, Response.class);
    }

    public Control setContainerRunCmd(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerRunCmd(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerRunCmd(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, Response.class);
    }

    public Response setContainerRunCmd(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, headers, Response.class);
    }

    public Control setContainerRunCmd(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerRunCmd(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerRunCmd(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerRunCmd(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, Response.class);
    }

    public Response setContainerRunCmd(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerruncmd", _params, headers, Response.class);
    }

    public ObjectResponse getContainerEntryPoint(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerentrypoint", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerEntryPoint(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerentrypoint", _params, headers, ObjectResponse.class);
    }

    public Control getContainerEntryPoint(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEntryPoint(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerEntryPoint(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEntryPoint(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerEntryPoint(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerentrypoint", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerEntryPoint(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerentrypoint", _params, headers, ObjectResponse.class);
    }

    public Control getContainerEntryPoint(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEntryPoint(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerEntryPoint(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEntryPoint(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerEntryPoint(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerentrypoint", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerEntryPoint(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerentrypoint", _params, headers, ObjectResponse.class);
    }

    public Control getContainerEntryPoint(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEntryPoint(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerEntryPoint(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerEntryPoint(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerEntryPoint(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerentrypoint", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerEntryPoint(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerentrypoint", _params, headers, ObjectResponse.class);
    }

    public Response setContainerEntryPoint(String envName, String session, int nodeId, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, Response.class);
    }

    public Response setContainerEntryPoint(String envName, String session, int nodeId, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, headers, Response.class);
    }

    public Control setContainerEntryPoint(final String envName, final String session, final int nodeId, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(envName, session, nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEntryPoint(final String envName, final String session, final int nodeId, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(envName, session, nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEntryPoint(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, Response.class);
    }

    public Response setContainerEntryPoint(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, headers, Response.class);
    }

    public Control setContainerEntryPoint(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEntryPoint(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEntryPoint(String session, int nodeId, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, Response.class);
    }

    public Response setContainerEntryPoint(String session, int nodeId, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, headers, Response.class);
    }

    public Control setContainerEntryPoint(final String session, final int nodeId, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(session, nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEntryPoint(final String session, final int nodeId, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(session, nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEntryPoint(int nodeId, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, Response.class);
    }

    public Response setContainerEntryPoint(int nodeId, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, headers, Response.class);
    }

    public Control setContainerEntryPoint(final int nodeId, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEntryPoint(final int nodeId, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(nodeId, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEntryPoint(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, Response.class);
    }

    public Response setContainerEntryPoint(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, headers, Response.class);
    }

    public Control setContainerEntryPoint(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEntryPoint(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEntryPoint(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, Response.class);
    }

    public Response setContainerEntryPoint(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, headers, Response.class);
    }

    public Control setContainerEntryPoint(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setContainerEntryPoint(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setContainerEntryPoint(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setContainerEntryPoint(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, Response.class);
    }

    public Response setContainerEntryPoint(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setcontainerentrypoint", _params, headers, Response.class);
    }

    public Response resetServicePassword(String envName, String session, String nodeGroup, int nodeId, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetservicepassword", _params, Response.class);
    }

    public Response resetServicePassword(String envName, String session, String nodeGroup, int nodeId, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetservicepassword", _params, headers, Response.class);
    }

    public Control resetServicePassword(final String envName, final String session, final String nodeGroup, final int nodeId, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetServicePassword(envName, session, nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetServicePassword(final String envName, final String session, final String nodeGroup, final int nodeId, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetServicePassword(envName, session, nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetServicePassword(String session, String nodeGroup, int nodeId, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetservicepassword", _params, Response.class);
    }

    public Response resetServicePassword(String session, String nodeGroup, int nodeId, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetservicepassword", _params, headers, Response.class);
    }

    public Control resetServicePassword(final String session, final String nodeGroup, final int nodeId, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetServicePassword(session, nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetServicePassword(final String session, final String nodeGroup, final int nodeId, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetServicePassword(session, nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetServicePassword(String nodeGroup, int nodeId, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetservicepassword", _params, Response.class);
    }

    public Response resetServicePassword(String nodeGroup, int nodeId, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetservicepassword", _params, headers, Response.class);
    }

    public Control resetServicePassword(final String nodeGroup, final int nodeId, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetServicePassword(nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetServicePassword(final String nodeGroup, final int nodeId, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetServicePassword(nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetServicePassword(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetservicepassword", _params, Response.class);
    }

    public Response resetServicePassword(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetservicepassword", _params, headers, Response.class);
    }

    public Response resetNodePasswordByType(String envName, String session, String nodeType, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbytype", _params, Response.class);
    }

    public Response resetNodePasswordByType(String envName, String session, String nodeType, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbytype", _params, headers, Response.class);
    }

    public Control resetNodePasswordByType(final String envName, final String session, final String nodeType, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordByType(envName, session, nodeType, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetNodePasswordByType(final String envName, final String session, final String nodeType, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordByType(envName, session, nodeType, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetNodePasswordByType(String session, String nodeType, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbytype", _params, Response.class);
    }

    public Response resetNodePasswordByType(String session, String nodeType, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbytype", _params, headers, Response.class);
    }

    public Control resetNodePasswordByType(final String session, final String nodeType, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordByType(session, nodeType, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetNodePasswordByType(final String session, final String nodeType, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordByType(session, nodeType, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetNodePasswordByType(String nodeType, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeType", nodeType);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbytype", _params, Response.class);
    }

    public Response resetNodePasswordByType(String nodeType, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeType", nodeType);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbytype", _params, headers, Response.class);
    }

    public Control resetNodePasswordByType(final String nodeType, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordByType(nodeType, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetNodePasswordByType(final String nodeType, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordByType(nodeType, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetNodePasswordByType(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbytype", _params, Response.class);
    }

    public Response resetNodePasswordByType(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbytype", _params, headers, Response.class);
    }

    public Response resetNodePasswordById(String envName, String session, int nodeId, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbyid", _params, Response.class);
    }

    public Response resetNodePasswordById(String envName, String session, int nodeId, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbyid", _params, headers, Response.class);
    }

    public Control resetNodePasswordById(final String envName, final String session, final int nodeId, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordById(envName, session, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetNodePasswordById(final String envName, final String session, final int nodeId, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordById(envName, session, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetNodePasswordById(String session, int nodeId, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbyid", _params, Response.class);
    }

    public Response resetNodePasswordById(String session, int nodeId, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbyid", _params, headers, Response.class);
    }

    public Control resetNodePasswordById(final String session, final int nodeId, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordById(session, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetNodePasswordById(final String session, final int nodeId, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordById(session, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetNodePasswordById(int nodeId, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbyid", _params, Response.class);
    }

    public Response resetNodePasswordById(int nodeId, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbyid", _params, headers, Response.class);
    }

    public Control resetNodePasswordById(final int nodeId, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordById(nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetNodePasswordById(final int nodeId, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePasswordById(nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetNodePasswordById(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbyid", _params, Response.class);
    }

    public Response resetNodePasswordById(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepasswordbyid", _params, headers, Response.class);
    }

    public Response resetNodePassword(String envName, String session, String nodeGroup, int nodeId, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepassword", _params, Response.class);
    }

    public Response resetNodePassword(String envName, String session, String nodeGroup, int nodeId, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepassword", _params, headers, Response.class);
    }

    public Control resetNodePassword(final String envName, final String session, final String nodeGroup, final int nodeId, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePassword(envName, session, nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetNodePassword(final String envName, final String session, final String nodeGroup, final int nodeId, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePassword(envName, session, nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetNodePassword(String session, String nodeGroup, int nodeId, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepassword", _params, Response.class);
    }

    public Response resetNodePassword(String session, String nodeGroup, int nodeId, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepassword", _params, headers, Response.class);
    }

    public Control resetNodePassword(final String session, final String nodeGroup, final int nodeId, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePassword(session, nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetNodePassword(final String session, final String nodeGroup, final int nodeId, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePassword(session, nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetNodePassword(String nodeGroup, int nodeId, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepassword", _params, Response.class);
    }

    public Response resetNodePassword(String nodeGroup, int nodeId, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepassword", _params, headers, Response.class);
    }

    public Control resetNodePassword(final String nodeGroup, final int nodeId, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePassword(nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetNodePassword(final String nodeGroup, final int nodeId, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetNodePassword(nodeGroup, nodeId, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetNodePassword(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepassword", _params, Response.class);
    }

    public Response resetNodePassword(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetnodepassword", _params, headers, Response.class);
    }

    public Response resetContainerPasswordById(String envName, String session, int nodeid, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerpasswordbyid", _params, Response.class);
    }

    public Response resetContainerPasswordById(String envName, String session, int nodeid, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerpasswordbyid", _params, headers, Response.class);
    }

    public Control resetContainerPasswordById(final String envName, final String session, final int nodeid, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainerPasswordById(envName, session, nodeid, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetContainerPasswordById(final String envName, final String session, final int nodeid, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainerPasswordById(envName, session, nodeid, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetContainerPasswordById(String session, int nodeid, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerpasswordbyid", _params, Response.class);
    }

    public Response resetContainerPasswordById(String session, int nodeid, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeid", nodeid + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerpasswordbyid", _params, headers, Response.class);
    }

    public Control resetContainerPasswordById(final String session, final int nodeid, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainerPasswordById(session, nodeid, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetContainerPasswordById(final String session, final int nodeid, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainerPasswordById(session, nodeid, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetContainerPasswordById(int nodeid, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeid", nodeid + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerpasswordbyid", _params, Response.class);
    }

    public Response resetContainerPasswordById(int nodeid, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeid", nodeid + "");
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerpasswordbyid", _params, headers, Response.class);
    }

    public Control resetContainerPasswordById(final int nodeid, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainerPasswordById(nodeid, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetContainerPasswordById(final int nodeid, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainerPasswordById(nodeid, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetContainerPasswordById(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerpasswordbyid", _params, Response.class);
    }

    public Response resetContainerPasswordById(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerpasswordbyid", _params, headers, Response.class);
    }

    public Response resetContainersPasswordByGroup(String envName, String session, String nodeGroup, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerspasswordbygroup", _params, Response.class);
    }

    public Response resetContainersPasswordByGroup(String envName, String session, String nodeGroup, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerspasswordbygroup", _params, headers, Response.class);
    }

    public Control resetContainersPasswordByGroup(final String envName, final String session, final String nodeGroup, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainersPasswordByGroup(envName, session, nodeGroup, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetContainersPasswordByGroup(final String envName, final String session, final String nodeGroup, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainersPasswordByGroup(envName, session, nodeGroup, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetContainersPasswordByGroup(String session, String nodeGroup, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerspasswordbygroup", _params, Response.class);
    }

    public Response resetContainersPasswordByGroup(String session, String nodeGroup, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerspasswordbygroup", _params, headers, Response.class);
    }

    public Control resetContainersPasswordByGroup(final String session, final String nodeGroup, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainersPasswordByGroup(session, nodeGroup, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetContainersPasswordByGroup(final String session, final String nodeGroup, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainersPasswordByGroup(session, nodeGroup, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetContainersPasswordByGroup(String nodeGroup, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerspasswordbygroup", _params, Response.class);
    }

    public Response resetContainersPasswordByGroup(String nodeGroup, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerspasswordbygroup", _params, headers, Response.class);
    }

    public Control resetContainersPasswordByGroup(final String nodeGroup, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainersPasswordByGroup(nodeGroup, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control resetContainersPasswordByGroup(final String nodeGroup, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.resetContainersPasswordByGroup(nodeGroup, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response resetContainersPasswordByGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerspasswordbygroup", _params, Response.class);
    }

    public Response resetContainersPasswordByGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/resetcontainerspasswordbygroup", _params, headers, Response.class);
    }

    public EnvironmentInfoResponse cloneEnv(String srcEnvName, String session, String dstEnvName, Boolean useExternalMounts) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", srcEnvName);
        _params.put("session", session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("useExternalMounts", useExternalMounts + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponse cloneEnv(String srcEnvName, String session, String dstEnvName, Boolean useExternalMounts, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", srcEnvName);
        _params.put("session", session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("useExternalMounts", useExternalMounts + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, headers, EnvironmentInfoResponse.class);
    }

    public Control cloneEnv(final String srcEnvName, final String session, final String dstEnvName, final Boolean useExternalMounts, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(srcEnvName, session, dstEnvName, useExternalMounts);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control cloneEnv(final String srcEnvName, final String session, final String dstEnvName, final Boolean useExternalMounts, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(srcEnvName, session, dstEnvName, useExternalMounts);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponse cloneEnv(String srcEnvName, String session, String dstEnvName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", srcEnvName);
        _params.put("session", session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponse cloneEnv(String srcEnvName, String session, String dstEnvName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", srcEnvName);
        _params.put("session", session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, headers, EnvironmentInfoResponse.class);
    }

    public Control cloneEnv(final String srcEnvName, final String session, final String dstEnvName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(srcEnvName, session, dstEnvName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control cloneEnv(final String srcEnvName, final String session, final String dstEnvName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(srcEnvName, session, dstEnvName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponse cloneEnv(String session, String dstEnvName, Boolean useExternalMounts) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", this.appid);
        _params.put("session", session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("useExternalMounts", useExternalMounts + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponse cloneEnv(String session, String dstEnvName, Boolean useExternalMounts, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", this.appid);
        _params.put("session", session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("useExternalMounts", useExternalMounts + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, headers, EnvironmentInfoResponse.class);
    }

    public Control cloneEnv(final String session, final String dstEnvName, final Boolean useExternalMounts, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(session, dstEnvName, useExternalMounts);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control cloneEnv(final String session, final String dstEnvName, final Boolean useExternalMounts, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(session, dstEnvName, useExternalMounts);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponse cloneEnv(String dstEnvName, Boolean useExternalMounts) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", this.appid);
        _params.put("session", this.session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("useExternalMounts", useExternalMounts + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponse cloneEnv(String dstEnvName, Boolean useExternalMounts, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", this.appid);
        _params.put("session", this.session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("useExternalMounts", useExternalMounts + "");
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, headers, EnvironmentInfoResponse.class);
    }

    public Control cloneEnv(final String dstEnvName, final Boolean useExternalMounts, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(dstEnvName, useExternalMounts);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control cloneEnv(final String dstEnvName, final Boolean useExternalMounts, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(dstEnvName, useExternalMounts);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponse cloneEnv(String session, String dstEnvName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", this.appid);
        _params.put("session", session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponse cloneEnv(String session, String dstEnvName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", this.appid);
        _params.put("session", session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, headers, EnvironmentInfoResponse.class);
    }

    public Control cloneEnv(final String session, final String dstEnvName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(session, dstEnvName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control cloneEnv(final String session, final String dstEnvName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(session, dstEnvName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponse cloneEnv(String dstEnvName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", this.appid);
        _params.put("session", this.session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponse cloneEnv(String dstEnvName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("srcEnvName", this.appid);
        _params.put("session", this.session);
        _params.put("dstEnvName", dstEnvName);
        _params.put("client_source", this.client_source);
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, headers, EnvironmentInfoResponse.class);
    }

    public Control cloneEnv(final String dstEnvName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(dstEnvName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control cloneEnv(final String dstEnvName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EnvironmentInfoResponse response = Control.this.cloneEnv(dstEnvName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public EnvironmentInfoResponse cloneEnv(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, EnvironmentInfoResponse.class);
    }

    public EnvironmentInfoResponse cloneEnv(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (EnvironmentInfoResponse)this._call(this.appid, this.serviceUrl + "rest/cloneenv", _params, headers, EnvironmentInfoResponse.class);
    }

    public ArrayResponse getSoftwarePackages(String envName, String session, String nodeType, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getsoftwarepackages", _params, ArrayResponse.class);
    }

    public ArrayResponse getSoftwarePackages(String envName, String session, String nodeType, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getsoftwarepackages", _params, headers, ArrayResponse.class);
    }

    public Control getSoftwarePackages(final String envName, final String session, final String nodeType, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getSoftwarePackages(envName, session, nodeType, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getSoftwarePackages(final String envName, final String session, final String nodeType, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getSoftwarePackages(envName, session, nodeType, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getSoftwarePackages(String session, String nodeType, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getsoftwarepackages", _params, ArrayResponse.class);
    }

    public ArrayResponse getSoftwarePackages(String session, String nodeType, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getsoftwarepackages", _params, headers, ArrayResponse.class);
    }

    public Control getSoftwarePackages(final String session, final String nodeType, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getSoftwarePackages(session, nodeType, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getSoftwarePackages(final String session, final String nodeType, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getSoftwarePackages(session, nodeType, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getSoftwarePackages(String nodeType, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeType", nodeType);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getsoftwarepackages", _params, ArrayResponse.class);
    }

    public ArrayResponse getSoftwarePackages(String nodeType, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeType", nodeType);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getsoftwarepackages", _params, headers, ArrayResponse.class);
    }

    public Control getSoftwarePackages(final String nodeType, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getSoftwarePackages(nodeType, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getSoftwarePackages(final String nodeType, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getSoftwarePackages(nodeType, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getSoftwarePackages(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getsoftwarepackages", _params, ArrayResponse.class);
    }

    public ArrayResponse getSoftwarePackages(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getsoftwarepackages", _params, headers, ArrayResponse.class);
    }

    public Response restoreDump(String envName, String session, String nodeType, String dbName, String password, String dumpUrl, String user) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("dbName", dbName);
        _params.put("password", password);
        _params.put("dumpUrl", dumpUrl);
        _params.put("user", user);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restoredump", _params, Response.class);
    }

    public Response restoreDump(String envName, String session, String nodeType, String dbName, String password, String dumpUrl, String user, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("dbName", dbName);
        _params.put("password", password);
        _params.put("dumpUrl", dumpUrl);
        _params.put("user", user);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restoredump", _params, headers, Response.class);
    }

    public Control restoreDump(final String envName, final String session, final String nodeType, final String dbName, final String password, final String dumpUrl, final String user, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restoreDump(envName, session, nodeType, dbName, password, dumpUrl, user);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restoreDump(final String envName, final String session, final String nodeType, final String dbName, final String password, final String dumpUrl, final String user, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restoreDump(envName, session, nodeType, dbName, password, dumpUrl, user);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restoreDump(String envName, String session, String nodeType, String dbName, String password, String dumpUrl) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("dbName", dbName);
        _params.put("password", password);
        _params.put("dumpUrl", dumpUrl);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restoredump", _params, Response.class);
    }

    public Response restoreDump(String envName, String session, String nodeType, String dbName, String password, String dumpUrl, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("dbName", dbName);
        _params.put("password", password);
        _params.put("dumpUrl", dumpUrl);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restoredump", _params, headers, Response.class);
    }

    public Control restoreDump(final String envName, final String session, final String nodeType, final String dbName, final String password, final String dumpUrl, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restoreDump(envName, session, nodeType, dbName, password, dumpUrl);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restoreDump(final String envName, final String session, final String nodeType, final String dbName, final String password, final String dumpUrl, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restoreDump(envName, session, nodeType, dbName, password, dumpUrl);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restoreDump(String nodeType, String dbName, String password, String dumpUrl, String user) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeType", nodeType);
        _params.put("dbName", dbName);
        _params.put("password", password);
        _params.put("dumpUrl", dumpUrl);
        _params.put("user", user);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restoredump", _params, Response.class);
    }

    public Response restoreDump(String nodeType, String dbName, String password, String dumpUrl, String user, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeType", nodeType);
        _params.put("dbName", dbName);
        _params.put("password", password);
        _params.put("dumpUrl", dumpUrl);
        _params.put("user", user);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restoredump", _params, headers, Response.class);
    }

    public Control restoreDump(final String nodeType, final String dbName, final String password, final String dumpUrl, final String user, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restoreDump(nodeType, dbName, password, dumpUrl, user);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restoreDump(final String nodeType, final String dbName, final String password, final String dumpUrl, final String user, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restoreDump(nodeType, dbName, password, dumpUrl, user);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restoreDump(String nodeType, String dbName, String password, String dumpUrl) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeType", nodeType);
        _params.put("dbName", dbName);
        _params.put("password", password);
        _params.put("dumpUrl", dumpUrl);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restoredump", _params, Response.class);
    }

    public Response restoreDump(String nodeType, String dbName, String password, String dumpUrl, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeType", nodeType);
        _params.put("dbName", dbName);
        _params.put("password", password);
        _params.put("dumpUrl", dumpUrl);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restoredump", _params, headers, Response.class);
    }

    public Control restoreDump(final String nodeType, final String dbName, final String password, final String dumpUrl, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restoreDump(nodeType, dbName, password, dumpUrl);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control restoreDump(final String nodeType, final String dbName, final String password, final String dumpUrl, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.restoreDump(nodeType, dbName, password, dumpUrl);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response restoreDump(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restoredump", _params, Response.class);
    }

    public Response restoreDump(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/restoredump", _params, headers, Response.class);
    }

    public ScriptEvalResponse createEnvironment(String appid, String session, String env, String nodes, String actionkey) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("actionkey", actionkey);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(appid, this.serviceUrl + "rest/createenvironment", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse createEnvironment(String appid, String session, String env, String nodes, String actionkey, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("actionkey", actionkey);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(appid, this.serviceUrl + "rest/createenvironment", _params, headers, ScriptEvalResponse.class);
    }

    public Control createEnvironment(final String appid, final String session, final String env, final String nodes, final String actionkey, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.createEnvironment(appid, session, env, nodes, actionkey);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control createEnvironment(final String appid, final String session, final String env, final String nodes, final String actionkey, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.createEnvironment(appid, session, env, nodes, actionkey);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ScriptEvalResponse createEnvironment(String appid, String session, String env, String nodes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(appid, this.serviceUrl + "rest/createenvironment", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse createEnvironment(String appid, String session, String env, String nodes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(appid, this.serviceUrl + "rest/createenvironment", _params, headers, ScriptEvalResponse.class);
    }

    public Control createEnvironment(final String appid, final String session, final String env, final String nodes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.createEnvironment(appid, session, env, nodes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control createEnvironment(final String appid, final String session, final String env, final String nodes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.createEnvironment(appid, session, env, nodes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ScriptEvalResponse createEnvironment(String env, String nodes, String actionkey) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("actionkey", actionkey);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/createenvironment", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse createEnvironment(String env, String nodes, String actionkey, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("actionkey", actionkey);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/createenvironment", _params, headers, ScriptEvalResponse.class);
    }

    public Control createEnvironment(final String env, final String nodes, final String actionkey, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.createEnvironment(env, nodes, actionkey);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control createEnvironment(final String env, final String nodes, final String actionkey, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.createEnvironment(env, nodes, actionkey);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ScriptEvalResponse createEnvironment(String env, String nodes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/createenvironment", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse createEnvironment(String env, String nodes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/createenvironment", _params, headers, ScriptEvalResponse.class);
    }

    public Control createEnvironment(final String env, final String nodes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.createEnvironment(env, nodes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control createEnvironment(final String env, final String nodes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.createEnvironment(env, nodes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ScriptEvalResponse createEnvironment(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/createenvironment", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse createEnvironment(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/createenvironment", _params, headers, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse changeTopology(String envName, String session, String actionkey, String env, String nodes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("actionkey", actionkey);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse changeTopology(String envName, String session, String actionkey, String env, String nodes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("actionkey", actionkey);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, headers, ScriptEvalResponse.class);
    }

    public Control changeTopology(final String envName, final String session, final String actionkey, final String env, final String nodes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology(envName, session, actionkey, env, nodes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control changeTopology(final String envName, final String session, final String actionkey, final String env, final String nodes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology(envName, session, actionkey, env, nodes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ScriptEvalResponse changeTopology(String envName, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse changeTopology(String envName, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, headers, ScriptEvalResponse.class);
    }

    public Control changeTopology(final String envName, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control changeTopology(final String envName, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ScriptEvalResponse changeTopology(String session, String actionkey, String env, String nodes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("actionkey", actionkey);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse changeTopology(String session, String actionkey, String env, String nodes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("actionkey", actionkey);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, headers, ScriptEvalResponse.class);
    }

    public Control changeTopology(final String session, final String actionkey, final String env, final String nodes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology(session, actionkey, env, nodes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control changeTopology(final String session, final String actionkey, final String env, final String nodes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology(session, actionkey, env, nodes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ScriptEvalResponse changeTopology(String actionkey, String env, String nodes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("actionkey", actionkey);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse changeTopology(String actionkey, String env, String nodes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("actionkey", actionkey);
        _params.put("env", env);
        _params.put("nodes", nodes);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, headers, ScriptEvalResponse.class);
    }

    public Control changeTopology(final String actionkey, final String env, final String nodes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology(actionkey, env, nodes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control changeTopology(final String actionkey, final String env, final String nodes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology(actionkey, env, nodes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ScriptEvalResponse changeTopology(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse changeTopology(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, headers, ScriptEvalResponse.class);
    }

    public Control changeTopology(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control changeTopology(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ScriptEvalResponse changeTopology() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, ScriptEvalResponse.class);
    }

    public Control changeTopology(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScriptEvalResponse response = Control.this.changeTopology();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ScriptEvalResponse changeTopology(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, ScriptEvalResponse.class);
    }

    public ScriptEvalResponse changeTopology(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ScriptEvalResponse)this._call(this.appid, this.serviceUrl + "rest/changetopology", _params, headers, ScriptEvalResponse.class);
    }

    public ExecResponse execCmdById(String envName, String session, int nodeId, String commandList, boolean sayYes, String userName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, ExecResponse.class);
    }

    public ExecResponse execCmdById(String envName, String session, int nodeId, String commandList, boolean sayYes, String userName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, headers, ExecResponse.class);
    }

    public Control execCmdById(final String envName, final String session, final int nodeId, final String commandList, final boolean sayYes, final String userName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(envName, session, nodeId, commandList, sayYes, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdById(final String envName, final String session, final int nodeId, final String commandList, final boolean sayYes, final String userName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(envName, session, nodeId, commandList, sayYes, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdById(String envName, String session, int nodeId, String commandList, boolean sayYes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, ExecResponse.class);
    }

    public ExecResponse execCmdById(String envName, String session, int nodeId, String commandList, boolean sayYes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, headers, ExecResponse.class);
    }

    public Control execCmdById(final String envName, final String session, final int nodeId, final String commandList, final boolean sayYes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(envName, session, nodeId, commandList, sayYes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdById(final String envName, final String session, final int nodeId, final String commandList, final boolean sayYes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(envName, session, nodeId, commandList, sayYes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdById(String session, int nodeId, String commandList, boolean sayYes, String userName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, ExecResponse.class);
    }

    public ExecResponse execCmdById(String session, int nodeId, String commandList, boolean sayYes, String userName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, headers, ExecResponse.class);
    }

    public Control execCmdById(final String session, final int nodeId, final String commandList, final boolean sayYes, final String userName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(session, nodeId, commandList, sayYes, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdById(final String session, final int nodeId, final String commandList, final boolean sayYes, final String userName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(session, nodeId, commandList, sayYes, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdById(int nodeId, String commandList, boolean sayYes, String userName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, ExecResponse.class);
    }

    public ExecResponse execCmdById(int nodeId, String commandList, boolean sayYes, String userName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, headers, ExecResponse.class);
    }

    public Control execCmdById(final int nodeId, final String commandList, final boolean sayYes, final String userName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(nodeId, commandList, sayYes, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdById(final int nodeId, final String commandList, final boolean sayYes, final String userName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(nodeId, commandList, sayYes, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdById(String session, int nodeId, String commandList, boolean sayYes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, ExecResponse.class);
    }

    public ExecResponse execCmdById(String session, int nodeId, String commandList, boolean sayYes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, headers, ExecResponse.class);
    }

    public Control execCmdById(final String session, final int nodeId, final String commandList, final boolean sayYes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(session, nodeId, commandList, sayYes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdById(final String session, final int nodeId, final String commandList, final boolean sayYes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(session, nodeId, commandList, sayYes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdById(int nodeId, String commandList, boolean sayYes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, ExecResponse.class);
    }

    public ExecResponse execCmdById(int nodeId, String commandList, boolean sayYes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, headers, ExecResponse.class);
    }

    public Control execCmdById(final int nodeId, final String commandList, final boolean sayYes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(nodeId, commandList, sayYes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdById(final int nodeId, final String commandList, final boolean sayYes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdById(nodeId, commandList, sayYes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdById(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, ExecResponse.class);
    }

    public ExecResponse execCmdById(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbyid", _params, headers, ExecResponse.class);
    }

    public ExecResponse execCmdByGroup(String envName, String session, String nodeGroup, String commandList, boolean sayYes, boolean async, String userName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, ExecResponse.class);
    }

    public ExecResponse execCmdByGroup(String envName, String session, String nodeGroup, String commandList, boolean sayYes, boolean async, String userName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, headers, ExecResponse.class);
    }

    public Control execCmdByGroup(final String envName, final String session, final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, final String userName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(envName, session, nodeGroup, commandList, sayYes, async, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdByGroup(final String envName, final String session, final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, final String userName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(envName, session, nodeGroup, commandList, sayYes, async, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdByGroup(String envName, String session, String nodeGroup, String commandList, boolean sayYes, boolean async) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, ExecResponse.class);
    }

    public ExecResponse execCmdByGroup(String envName, String session, String nodeGroup, String commandList, boolean sayYes, boolean async, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, headers, ExecResponse.class);
    }

    public Control execCmdByGroup(final String envName, final String session, final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(envName, session, nodeGroup, commandList, sayYes, async);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdByGroup(final String envName, final String session, final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(envName, session, nodeGroup, commandList, sayYes, async);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdByGroup(String session, String nodeGroup, String commandList, boolean sayYes, boolean async, String userName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, ExecResponse.class);
    }

    public ExecResponse execCmdByGroup(String session, String nodeGroup, String commandList, boolean sayYes, boolean async, String userName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, headers, ExecResponse.class);
    }

    public Control execCmdByGroup(final String session, final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, final String userName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(session, nodeGroup, commandList, sayYes, async, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdByGroup(final String session, final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, final String userName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(session, nodeGroup, commandList, sayYes, async, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdByGroup(String nodeGroup, String commandList, boolean sayYes, boolean async, String userName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, ExecResponse.class);
    }

    public ExecResponse execCmdByGroup(String nodeGroup, String commandList, boolean sayYes, boolean async, String userName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("userName", userName);
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, headers, ExecResponse.class);
    }

    public Control execCmdByGroup(final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, final String userName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(nodeGroup, commandList, sayYes, async, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdByGroup(final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, final String userName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(nodeGroup, commandList, sayYes, async, userName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdByGroup(String session, String nodeGroup, String commandList, boolean sayYes, boolean async) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, ExecResponse.class);
    }

    public ExecResponse execCmdByGroup(String session, String nodeGroup, String commandList, boolean sayYes, boolean async, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, headers, ExecResponse.class);
    }

    public Control execCmdByGroup(final String session, final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(session, nodeGroup, commandList, sayYes, async);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdByGroup(final String session, final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(session, nodeGroup, commandList, sayYes, async);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdByGroup(String nodeGroup, String commandList, boolean sayYes, boolean async) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, ExecResponse.class);
    }

    public ExecResponse execCmdByGroup(String nodeGroup, String commandList, boolean sayYes, boolean async, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("commandList", commandList);
        _params.put("sayYes", sayYes + "");
        _params.put("async", async + "");
        _params.put("client_source", this.client_source);
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, headers, ExecResponse.class);
    }

    public Control execCmdByGroup(final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(nodeGroup, commandList, sayYes, async);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control execCmdByGroup(final String nodeGroup, final String commandList, final boolean sayYes, final boolean async, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ExecResponse response = Control.this.execCmdByGroup(nodeGroup, commandList, sayYes, async);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ExecResponse execCmdByGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, ExecResponse.class);
    }

    public ExecResponse execCmdByGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ExecResponse)this._call(this.appid, this.serviceUrl + "rest/execcmdbygroup", _params, headers, ExecResponse.class);
    }

    public Response setEnvDisplayName(String envName, String session, String displayName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvdisplayname", _params, Response.class);
    }

    public Response setEnvDisplayName(String envName, String session, String displayName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvdisplayname", _params, headers, Response.class);
    }

    public Control setEnvDisplayName(final String envName, final String session, final String displayName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvDisplayName(envName, session, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setEnvDisplayName(final String envName, final String session, final String displayName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvDisplayName(envName, session, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setEnvDisplayName(String envName, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvdisplayname", _params, Response.class);
    }

    public Response setEnvDisplayName(String envName, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvdisplayname", _params, headers, Response.class);
    }

    public Control setEnvDisplayName(final String envName, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvDisplayName(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setEnvDisplayName(final String envName, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvDisplayName(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setEnvDisplayName(String displayName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvdisplayname", _params, Response.class);
    }

    public Response setEnvDisplayName(String displayName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvdisplayname", _params, headers, Response.class);
    }

    public Control setEnvDisplayName(final String displayName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvDisplayName(displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setEnvDisplayName(final String displayName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvDisplayName(displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setEnvDisplayName() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvdisplayname", _params, Response.class);
    }

    public Control setEnvDisplayName(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvDisplayName();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setEnvDisplayName(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvdisplayname", _params, Response.class);
    }

    public Response setEnvDisplayName(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvdisplayname", _params, headers, Response.class);
    }

    public Response setNodeDisplayName(String envName, String session, int nodeId, String displayName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, Response.class);
    }

    public Response setNodeDisplayName(String envName, String session, int nodeId, String displayName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, headers, Response.class);
    }

    public Control setNodeDisplayName(final String envName, final String session, final int nodeId, final String displayName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(envName, session, nodeId, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setNodeDisplayName(final String envName, final String session, final int nodeId, final String displayName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(envName, session, nodeId, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setNodeDisplayName(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, Response.class);
    }

    public Response setNodeDisplayName(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, headers, Response.class);
    }

    public Control setNodeDisplayName(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setNodeDisplayName(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setNodeDisplayName(String session, int nodeId, String displayName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, Response.class);
    }

    public Response setNodeDisplayName(String session, int nodeId, String displayName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, headers, Response.class);
    }

    public Control setNodeDisplayName(final String session, final int nodeId, final String displayName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(session, nodeId, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setNodeDisplayName(final String session, final int nodeId, final String displayName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(session, nodeId, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setNodeDisplayName(int nodeId, String displayName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, Response.class);
    }

    public Response setNodeDisplayName(int nodeId, String displayName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, headers, Response.class);
    }

    public Control setNodeDisplayName(final int nodeId, final String displayName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(nodeId, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setNodeDisplayName(final int nodeId, final String displayName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(nodeId, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setNodeDisplayName(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, Response.class);
    }

    public Response setNodeDisplayName(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, headers, Response.class);
    }

    public Control setNodeDisplayName(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setNodeDisplayName(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setNodeDisplayName(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, Response.class);
    }

    public Response setNodeDisplayName(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, headers, Response.class);
    }

    public Control setNodeDisplayName(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setNodeDisplayName(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeDisplayName(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setNodeDisplayName(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, Response.class);
    }

    public Response setNodeDisplayName(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodedisplayname", _params, headers, Response.class);
    }

    public Response export(String envName, String session, String settings) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("settings", settings);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/export", _params, Response.class);
    }

    public Response export(String envName, String session, String settings, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("settings", settings);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/export", _params, headers, Response.class);
    }

    public Control export(final String envName, final String session, final String settings, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.export(envName, session, settings);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control export(final String envName, final String session, final String settings, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.export(envName, session, settings);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response export(String session, String settings) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("settings", settings);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/export", _params, Response.class);
    }

    public Response export(String session, String settings, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("settings", settings);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/export", _params, headers, Response.class);
    }

    public Control export(final String session, final String settings, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.export(session, settings);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control export(final String session, final String settings, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.export(session, settings);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response export(String settings) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("settings", settings);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/export", _params, Response.class);
    }

    public Response export(String settings, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("settings", settings);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/export", _params, headers, Response.class);
    }

    public Control export(final String settings, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.export(settings);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control export(final String settings, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.export(settings);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response export(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/export", _params, Response.class);
    }

    public Response export(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/export", _params, headers, Response.class);
    }

    public ArrayResponse getRegions(String appid, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/getregions", _params, ArrayResponse.class);
    }

    public ArrayResponse getRegions(String appid, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/getregions", _params, headers, ArrayResponse.class);
    }

    public Control getRegions(final String appid, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegions(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegions(final String appid, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegions(appid, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getRegions(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregions", _params, ArrayResponse.class);
    }

    public ArrayResponse getRegions(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregions", _params, headers, ArrayResponse.class);
    }

    public Control getRegions(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegions(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegions(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegions(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getRegions() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregions", _params, ArrayResponse.class);
    }

    public Control getRegions(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegions();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getRegions(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregions", _params, ArrayResponse.class);
    }

    public ArrayResponse getRegions(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregions", _params, headers, ArrayResponse.class);
    }

    public ArrayResponse getRegionsInner(String appid, String session, String groupName, boolean isEnabled) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("groupName", groupName);
        _params.put("isEnabled", isEnabled + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/getregionsinner", _params, ArrayResponse.class);
    }

    public ArrayResponse getRegionsInner(String appid, String session, String groupName, boolean isEnabled, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("groupName", groupName);
        _params.put("isEnabled", isEnabled + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/getregionsinner", _params, headers, ArrayResponse.class);
    }

    public Control getRegionsInner(final String appid, final String session, final String groupName, final boolean isEnabled, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(appid, session, groupName, isEnabled);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegionsInner(final String appid, final String session, final String groupName, final boolean isEnabled, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(appid, session, groupName, isEnabled);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getRegionsInner(String appid, String session, String groupName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("groupName", groupName);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/getregionsinner", _params, ArrayResponse.class);
    }

    public ArrayResponse getRegionsInner(String appid, String session, String groupName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("groupName", groupName);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(appid, this.serviceUrl + "rest/getregionsinner", _params, headers, ArrayResponse.class);
    }

    public Control getRegionsInner(final String appid, final String session, final String groupName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(appid, session, groupName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegionsInner(final String appid, final String session, final String groupName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(appid, session, groupName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getRegionsInner(String session, String groupName, boolean isEnabled) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("groupName", groupName);
        _params.put("isEnabled", isEnabled + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregionsinner", _params, ArrayResponse.class);
    }

    public ArrayResponse getRegionsInner(String session, String groupName, boolean isEnabled, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("groupName", groupName);
        _params.put("isEnabled", isEnabled + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregionsinner", _params, headers, ArrayResponse.class);
    }

    public Control getRegionsInner(final String session, final String groupName, final boolean isEnabled, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(session, groupName, isEnabled);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegionsInner(final String session, final String groupName, final boolean isEnabled, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(session, groupName, isEnabled);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getRegionsInner(String groupName, boolean isEnabled) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("groupName", groupName);
        _params.put("isEnabled", isEnabled + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregionsinner", _params, ArrayResponse.class);
    }

    public ArrayResponse getRegionsInner(String groupName, boolean isEnabled, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("groupName", groupName);
        _params.put("isEnabled", isEnabled + "");
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregionsinner", _params, headers, ArrayResponse.class);
    }

    public Control getRegionsInner(final String groupName, final boolean isEnabled, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(groupName, isEnabled);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegionsInner(final String groupName, final boolean isEnabled, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(groupName, isEnabled);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getRegionsInner(String session, String groupName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("groupName", groupName);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregionsinner", _params, ArrayResponse.class);
    }

    public ArrayResponse getRegionsInner(String session, String groupName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("groupName", groupName);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregionsinner", _params, headers, ArrayResponse.class);
    }

    public Control getRegionsInner(final String session, final String groupName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(session, groupName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegionsInner(final String session, final String groupName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(session, groupName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getRegionsInner(String groupName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("groupName", groupName);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregionsinner", _params, ArrayResponse.class);
    }

    public ArrayResponse getRegionsInner(String groupName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("groupName", groupName);
        _params.put("client_source", this.client_source);
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregionsinner", _params, headers, ArrayResponse.class);
    }

    public Control getRegionsInner(final String groupName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(groupName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegionsInner(final String groupName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ArrayResponse response = Control.this.getRegionsInner(groupName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ArrayResponse getRegionsInner(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregionsinner", _params, ArrayResponse.class);
    }

    public ArrayResponse getRegionsInner(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ArrayResponse)this._call(this.appid, this.serviceUrl + "rest/getregionsinner", _params, headers, ArrayResponse.class);
    }

    public Response checkMigrationPossibility(String envName, String session, String hardwareNodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/checkmigrationpossibility", _params, Response.class);
    }

    public Response checkMigrationPossibility(String envName, String session, String hardwareNodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/checkmigrationpossibility", _params, headers, Response.class);
    }

    public Control checkMigrationPossibility(final String envName, final String session, final String hardwareNodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.checkMigrationPossibility(envName, session, hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control checkMigrationPossibility(final String envName, final String session, final String hardwareNodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.checkMigrationPossibility(envName, session, hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response checkMigrationPossibility(String session, String hardwareNodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/checkmigrationpossibility", _params, Response.class);
    }

    public Response checkMigrationPossibility(String session, String hardwareNodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/checkmigrationpossibility", _params, headers, Response.class);
    }

    public Control checkMigrationPossibility(final String session, final String hardwareNodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.checkMigrationPossibility(session, hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control checkMigrationPossibility(final String session, final String hardwareNodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.checkMigrationPossibility(session, hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response checkMigrationPossibility(String hardwareNodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/checkmigrationpossibility", _params, Response.class);
    }

    public Response checkMigrationPossibility(String hardwareNodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/checkmigrationpossibility", _params, headers, Response.class);
    }

    public Control checkMigrationPossibility(final String hardwareNodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.checkMigrationPossibility(hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control checkMigrationPossibility(final String hardwareNodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.checkMigrationPossibility(hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response checkMigrationPossibility(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/checkmigrationpossibility", _params, Response.class);
    }

    public Response checkMigrationPossibility(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/checkmigrationpossibility", _params, headers, Response.class);
    }

    public Response migrate(String envName, String session, String hardwareNodeGroup, boolean isOnline) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("isOnline", isOnline + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, Response.class);
    }

    public Response migrate(String envName, String session, String hardwareNodeGroup, boolean isOnline, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("isOnline", isOnline + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, headers, Response.class);
    }

    public Control migrate(final String envName, final String session, final String hardwareNodeGroup, final boolean isOnline, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(envName, session, hardwareNodeGroup, isOnline);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control migrate(final String envName, final String session, final String hardwareNodeGroup, final boolean isOnline, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(envName, session, hardwareNodeGroup, isOnline);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response migrate(String envName, String session, String hardwareNodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, Response.class);
    }

    public Response migrate(String envName, String session, String hardwareNodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, headers, Response.class);
    }

    public Control migrate(final String envName, final String session, final String hardwareNodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(envName, session, hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control migrate(final String envName, final String session, final String hardwareNodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(envName, session, hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response migrate(String session, String hardwareNodeGroup, boolean isOnline) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("isOnline", isOnline + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, Response.class);
    }

    public Response migrate(String session, String hardwareNodeGroup, boolean isOnline, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("isOnline", isOnline + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, headers, Response.class);
    }

    public Control migrate(final String session, final String hardwareNodeGroup, final boolean isOnline, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(session, hardwareNodeGroup, isOnline);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control migrate(final String session, final String hardwareNodeGroup, final boolean isOnline, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(session, hardwareNodeGroup, isOnline);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response migrate(String hardwareNodeGroup, boolean isOnline) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("isOnline", isOnline + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, Response.class);
    }

    public Response migrate(String hardwareNodeGroup, boolean isOnline, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("isOnline", isOnline + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, headers, Response.class);
    }

    public Control migrate(final String hardwareNodeGroup, final boolean isOnline, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(hardwareNodeGroup, isOnline);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control migrate(final String hardwareNodeGroup, final boolean isOnline, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(hardwareNodeGroup, isOnline);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response migrate(String session, String hardwareNodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, Response.class);
    }

    public Response migrate(String session, String hardwareNodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, headers, Response.class);
    }

    public Control migrate(final String session, final String hardwareNodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(session, hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control migrate(final String session, final String hardwareNodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(session, hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response migrate(String hardwareNodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, Response.class);
    }

    public Response migrate(String hardwareNodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("hardwareNodeGroup", hardwareNodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, headers, Response.class);
    }

    public Control migrate(final String hardwareNodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control migrate(final String hardwareNodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.migrate(hardwareNodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response migrate(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, Response.class);
    }

    public Response migrate(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/migrate", _params, headers, Response.class);
    }

    public ObjectResponse addEndpoint(String envName, String session, int nodeId, int privatePort, String protocol, String name) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("name", name);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/addendpoint", _params, ObjectResponse.class);
    }

    public ObjectResponse addEndpoint(String envName, String session, int nodeId, int privatePort, String protocol, String name, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("name", name);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/addendpoint", _params, headers, ObjectResponse.class);
    }

    public Control addEndpoint(final String envName, final String session, final int nodeId, final int privatePort, final String protocol, final String name, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.addEndpoint(envName, session, nodeId, privatePort, protocol, name);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addEndpoint(final String envName, final String session, final int nodeId, final int privatePort, final String protocol, final String name, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.addEndpoint(envName, session, nodeId, privatePort, protocol, name);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse addEndpoint(String session, int nodeId, int privatePort, String protocol, String name) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("name", name);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/addendpoint", _params, ObjectResponse.class);
    }

    public ObjectResponse addEndpoint(String session, int nodeId, int privatePort, String protocol, String name, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("name", name);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/addendpoint", _params, headers, ObjectResponse.class);
    }

    public Control addEndpoint(final String session, final int nodeId, final int privatePort, final String protocol, final String name, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.addEndpoint(session, nodeId, privatePort, protocol, name);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addEndpoint(final String session, final int nodeId, final int privatePort, final String protocol, final String name, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.addEndpoint(session, nodeId, privatePort, protocol, name);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse addEndpoint(int nodeId, int privatePort, String protocol, String name) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("name", name);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/addendpoint", _params, ObjectResponse.class);
    }

    public ObjectResponse addEndpoint(int nodeId, int privatePort, String protocol, String name, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("name", name);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/addendpoint", _params, headers, ObjectResponse.class);
    }

    public Control addEndpoint(final int nodeId, final int privatePort, final String protocol, final String name, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.addEndpoint(nodeId, privatePort, protocol, name);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addEndpoint(final int nodeId, final int privatePort, final String protocol, final String name, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.addEndpoint(nodeId, privatePort, protocol, name);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse addEndpoint(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/addendpoint", _params, ObjectResponse.class);
    }

    public ObjectResponse addEndpoint(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/addendpoint", _params, headers, ObjectResponse.class);
    }

    public ObjectResponse editEndpoint(String envName, String session, int id, String name, int privatePort, String protocol) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("name", name);
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/editendpoint", _params, ObjectResponse.class);
    }

    public ObjectResponse editEndpoint(String envName, String session, int id, String name, int privatePort, String protocol, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("name", name);
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/editendpoint", _params, headers, ObjectResponse.class);
    }

    public Control editEndpoint(final String envName, final String session, final int id, final String name, final int privatePort, final String protocol, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.editEndpoint(envName, session, id, name, privatePort, protocol);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editEndpoint(final String envName, final String session, final int id, final String name, final int privatePort, final String protocol, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.editEndpoint(envName, session, id, name, privatePort, protocol);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse editEndpoint(String session, int id, String name, int privatePort, String protocol) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("name", name);
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/editendpoint", _params, ObjectResponse.class);
    }

    public ObjectResponse editEndpoint(String session, int id, String name, int privatePort, String protocol, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("name", name);
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/editendpoint", _params, headers, ObjectResponse.class);
    }

    public Control editEndpoint(final String session, final int id, final String name, final int privatePort, final String protocol, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.editEndpoint(session, id, name, privatePort, protocol);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editEndpoint(final String session, final int id, final String name, final int privatePort, final String protocol, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.editEndpoint(session, id, name, privatePort, protocol);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse editEndpoint(int id, String name, int privatePort, String protocol) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("id", id + "");
        _params.put("name", name);
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/editendpoint", _params, ObjectResponse.class);
    }

    public ObjectResponse editEndpoint(int id, String name, int privatePort, String protocol, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("id", id + "");
        _params.put("name", name);
        _params.put("privatePort", privatePort + "");
        _params.put("protocol", protocol);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/editendpoint", _params, headers, ObjectResponse.class);
    }

    public Control editEndpoint(final int id, final String name, final int privatePort, final String protocol, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.editEndpoint(id, name, privatePort, protocol);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editEndpoint(final int id, final String name, final int privatePort, final String protocol, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.editEndpoint(id, name, privatePort, protocol);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse editEndpoint(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/editendpoint", _params, ObjectResponse.class);
    }

    public ObjectResponse editEndpoint(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/editendpoint", _params, headers, ObjectResponse.class);
    }

    public Response removeEndpoint(String envName, String session, int id) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeendpoint", _params, Response.class);
    }

    public Response removeEndpoint(String envName, String session, int id, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeendpoint", _params, headers, Response.class);
    }

    public Control removeEndpoint(final String envName, final String session, final int id, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeEndpoint(envName, session, id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeEndpoint(final String envName, final String session, final int id, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeEndpoint(envName, session, id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeEndpoint(String session, int id) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeendpoint", _params, Response.class);
    }

    public Response removeEndpoint(String session, int id, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeendpoint", _params, headers, Response.class);
    }

    public Control removeEndpoint(final String session, final int id, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeEndpoint(session, id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeEndpoint(final String session, final int id, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeEndpoint(session, id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeEndpoint(int id) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeendpoint", _params, Response.class);
    }

    public Response removeEndpoint(int id, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeendpoint", _params, headers, Response.class);
    }

    public Control removeEndpoint(final int id, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeEndpoint(id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeEndpoint(final int id, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeEndpoint(id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeEndpoint(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeendpoint", _params, Response.class);
    }

    public Response removeEndpoint(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removeendpoint", _params, headers, Response.class);
    }

    public ObjectResponse getContainerManifest(String appid, String session, String image, String registry, String userName, String password, String imageId, boolean ignoreFormat) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("imageId", imageId);
        _params.put("ignoreFormat", ignoreFormat + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(String appid, String session, String image, String registry, String userName, String password, String imageId, boolean ignoreFormat, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("imageId", imageId);
        _params.put("ignoreFormat", ignoreFormat + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public Control getContainerManifest(final String appid, final String session, final String image, final String registry, final String userName, final String password, final String imageId, final boolean ignoreFormat, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(appid, session, image, registry, userName, password, imageId, ignoreFormat);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerManifest(final String appid, final String session, final String image, final String registry, final String userName, final String password, final String imageId, final boolean ignoreFormat, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(appid, session, image, registry, userName, password, imageId, ignoreFormat);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerManifest(String appid, String session, String image, String registry, String userName, String password, String imageId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("imageId", imageId);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(String appid, String session, String image, String registry, String userName, String password, String imageId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("imageId", imageId);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public Control getContainerManifest(final String appid, final String session, final String image, final String registry, final String userName, final String password, final String imageId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(appid, session, image, registry, userName, password, imageId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerManifest(final String appid, final String session, final String image, final String registry, final String userName, final String password, final String imageId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(appid, session, image, registry, userName, password, imageId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerManifest(String appid, String session, String image, String registry, String userName, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(String appid, String session, String image, String registry, String userName, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public Control getContainerManifest(final String appid, final String session, final String image, final String registry, final String userName, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(appid, session, image, registry, userName, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerManifest(final String appid, final String session, final String image, final String registry, final String userName, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(appid, session, image, registry, userName, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerManifest(String appid, String session, String image, String registry) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(String appid, String session, String image, String registry, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public Control getContainerManifest(final String appid, final String session, final String image, final String registry, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(appid, session, image, registry);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerManifest(final String appid, final String session, final String image, final String registry, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(appid, session, image, registry);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerManifest(String appid, String session, String image) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(String appid, String session, String image, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public Control getContainerManifest(final String appid, final String session, final String image, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(appid, session, image);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerManifest(final String appid, final String session, final String image, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(appid, session, image);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerManifest(String session, String image, String registry, String userName, String password, String imageId, boolean ignoreFormat) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("imageId", imageId);
        _params.put("ignoreFormat", ignoreFormat + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(String session, String image, String registry, String userName, String password, String imageId, boolean ignoreFormat, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("imageId", imageId);
        _params.put("ignoreFormat", ignoreFormat + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public Control getContainerManifest(final String session, final String image, final String registry, final String userName, final String password, final String imageId, final boolean ignoreFormat, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(session, image, registry, userName, password, imageId, ignoreFormat);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerManifest(final String session, final String image, final String registry, final String userName, final String password, final String imageId, final boolean ignoreFormat, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(session, image, registry, userName, password, imageId, ignoreFormat);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerManifest(String image, String registry, String userName, String password, String imageId, boolean ignoreFormat) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("imageId", imageId);
        _params.put("ignoreFormat", ignoreFormat + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(String image, String registry, String userName, String password, String imageId, boolean ignoreFormat, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("imageId", imageId);
        _params.put("ignoreFormat", ignoreFormat + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public Control getContainerManifest(final String image, final String registry, final String userName, final String password, final String imageId, final boolean ignoreFormat, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(image, registry, userName, password, imageId, ignoreFormat);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerManifest(final String image, final String registry, final String userName, final String password, final String imageId, final boolean ignoreFormat, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(image, registry, userName, password, imageId, ignoreFormat);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerManifest(String image, String registry, String userName, String password, String imageId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("imageId", imageId);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(String image, String registry, String userName, String password, String imageId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("imageId", imageId);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public Control getContainerManifest(final String image, final String registry, final String userName, final String password, final String imageId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(image, registry, userName, password, imageId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerManifest(final String image, final String registry, final String userName, final String password, final String imageId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(image, registry, userName, password, imageId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerManifest(String image, String registry) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(String image, String registry, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public Control getContainerManifest(final String image, final String registry, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(image, registry);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerManifest(final String image, final String registry, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(image, registry);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerManifest(String image) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(String image, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public Control getContainerManifest(final String image, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(image);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerManifest(final String image, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerManifest(image);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerManifest(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerManifest(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainermanifest", _params, headers, ObjectResponse.class);
    }

    public ObjectResponse getContainerTags(String appid, String session, String image, String registry, String userName, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainertags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerTags(String appid, String session, String image, String registry, String userName, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainertags", _params, headers, ObjectResponse.class);
    }

    public Control getContainerTags(final String appid, final String session, final String image, final String registry, final String userName, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(appid, session, image, registry, userName, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerTags(final String appid, final String session, final String image, final String registry, final String userName, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(appid, session, image, registry, userName, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerTags(String appid, String session, String image, String registry) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainertags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerTags(String appid, String session, String image, String registry, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainertags", _params, headers, ObjectResponse.class);
    }

    public Control getContainerTags(final String appid, final String session, final String image, final String registry, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(appid, session, image, registry);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerTags(final String appid, final String session, final String image, final String registry, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(appid, session, image, registry);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerTags(String appid, String session, String image) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainertags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerTags(String appid, String session, String image, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/getcontainertags", _params, headers, ObjectResponse.class);
    }

    public Control getContainerTags(final String appid, final String session, final String image, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(appid, session, image);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerTags(final String appid, final String session, final String image, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(appid, session, image);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerTags(String session, String image, String registry, String userName, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainertags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerTags(String session, String image, String registry, String userName, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("userName", userName);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainertags", _params, headers, ObjectResponse.class);
    }

    public Control getContainerTags(final String session, final String image, final String registry, final String userName, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(session, image, registry, userName, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerTags(final String session, final String image, final String registry, final String userName, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(session, image, registry, userName, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerTags(String image, String registry) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainertags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerTags(String image, String registry, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("registry", registry);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainertags", _params, headers, ObjectResponse.class);
    }

    public Control getContainerTags(final String image, final String registry, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(image, registry);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerTags(final String image, final String registry, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(image, registry);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerTags(String image) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainertags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerTags(String image, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("image", image);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainertags", _params, headers, ObjectResponse.class);
    }

    public Control getContainerTags(final String image, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(image);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerTags(final String image, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerTags(image);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerTags(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainertags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerTags(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainertags", _params, headers, ObjectResponse.class);
    }

    public ObjectResponse getContainerNodeTags(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainernodetags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerNodeTags(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainernodetags", _params, headers, ObjectResponse.class);
    }

    public Control getContainerNodeTags(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerNodeTags(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerNodeTags(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerNodeTags(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerNodeTags(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainernodetags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerNodeTags(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainernodetags", _params, headers, ObjectResponse.class);
    }

    public Control getContainerNodeTags(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerNodeTags(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerNodeTags(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerNodeTags(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerNodeTags(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainernodetags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerNodeTags(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainernodetags", _params, headers, ObjectResponse.class);
    }

    public Control getContainerNodeTags(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerNodeTags(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerNodeTags(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerNodeTags(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerNodeTags(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainernodetags", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerNodeTags(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainernodetags", _params, headers, ObjectResponse.class);
    }

    public NodeSSHResponses redeployContainerById(String envName, String session, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(String envName, String session, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final String envName, final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(envName, session, nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final String envName, final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(envName, session, nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(String envName, String session, int nodeId, String tag, Boolean useExistingVolumes, String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(String envName, String session, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final String envName, final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(envName, session, nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final String envName, final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(envName, session, nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(String envName, String session, int nodeId, String tag, Boolean useExistingVolumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(String envName, String session, int nodeId, String tag, Boolean useExistingVolumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final String envName, final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(envName, session, nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final String envName, final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(envName, session, nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(String envName, String session, int nodeId, String tag) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(String envName, String session, int nodeId, String tag, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final String envName, final String session, final int nodeId, final String tag, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(envName, session, nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final String envName, final String session, final int nodeId, final String tag, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(envName, session, nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(String session, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(String session, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(session, nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(session, nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(String session, int nodeId, String tag, Boolean useExistingVolumes, String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(String session, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(session, nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(session, nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(int nodeId, String tag, Boolean useExistingVolumes, String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(int nodeId, String tag, Boolean useExistingVolumes, String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(String session, int nodeId, String tag, Boolean useExistingVolumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(String session, int nodeId, String tag, Boolean useExistingVolumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(session, nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final String session, final int nodeId, final String tag, final Boolean useExistingVolumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(session, nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(int nodeId, String tag, Boolean useExistingVolumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(int nodeId, String tag, Boolean useExistingVolumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final int nodeId, final String tag, final Boolean useExistingVolumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final int nodeId, final String tag, final Boolean useExistingVolumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(String session, int nodeId, String tag) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(String session, int nodeId, String tag, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final String session, final int nodeId, final String tag, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(session, nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final String session, final int nodeId, final String tag, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(session, nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(int nodeId, String tag) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(int nodeId, String tag, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainerById(final int nodeId, final String tag, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainerById(final int nodeId, final String tag, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainerById(nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainerById(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainerById(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainerbyid", _params, headers, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String envName, String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password, boolean skipReinstall) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String envName, String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password, boolean skipReinstall, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String envName, final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, final boolean skipReinstall, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(envName, session, nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String envName, final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, final boolean skipReinstall, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(envName, session, nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String envName, String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String envName, String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String envName, final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(envName, session, nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String envName, final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(envName, session, nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String envName, String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String envName, String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String envName, final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(envName, session, nodeGroup, tag, isSequential, useExistingVolumes, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String envName, final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(envName, session, nodeGroup, tag, isSequential, useExistingVolumes, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String envName, String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String envName, String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String envName, final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(envName, session, nodeGroup, tag, isSequential, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String envName, final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(envName, session, nodeGroup, tag, isSequential, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String envName, String session, String nodeGroup, String tag, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String envName, String session, String nodeGroup, String tag, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String envName, final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(envName, session, nodeGroup, tag, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String envName, final String session, final String nodeGroup, final String tag, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(envName, session, nodeGroup, tag, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password, boolean skipReinstall) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password, boolean skipReinstall, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, final boolean skipReinstall, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(session, nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, final boolean skipReinstall, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(session, nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password, boolean skipReinstall) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password, boolean skipReinstall, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, final boolean skipReinstall, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, final boolean skipReinstall, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(session, nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(session, nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(nodeGroup, tag, isSequential, useExistingVolumes, delay, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(session, nodeGroup, tag, isSequential, useExistingVolumes, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(session, nodeGroup, tag, isSequential, useExistingVolumes, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Integer delay, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("delay", delay + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(nodeGroup, tag, isSequential, useExistingVolumes, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Integer delay, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(nodeGroup, tag, isSequential, useExistingVolumes, delay);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String session, String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(session, nodeGroup, tag, isSequential, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(session, nodeGroup, tag, isSequential, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String nodeGroup, String tag, Boolean isSequential, Boolean useExistingVolumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(nodeGroup, tag, isSequential, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String nodeGroup, final String tag, final Boolean isSequential, final Boolean useExistingVolumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(nodeGroup, tag, isSequential, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String session, String nodeGroup, String tag, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String session, String nodeGroup, String tag, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String session, final String nodeGroup, final String tag, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(session, nodeGroup, tag, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String session, final String nodeGroup, final String tag, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(session, nodeGroup, tag, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(String nodeGroup, String tag, Boolean isSequential) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(String nodeGroup, String tag, Boolean isSequential, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("tag", tag);
        _params.put("isSequential", isSequential + "");
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Control redeployContainersByGroup(final String nodeGroup, final String tag, final Boolean isSequential, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(nodeGroup, tag, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainersByGroup(final String nodeGroup, final String tag, final Boolean isSequential, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.redeployContainersByGroup(nodeGroup, tag, isSequential);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses redeployContainersByGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses redeployContainersByGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/redeploycontainersbygroup", _params, headers, NodeSSHResponses.class);
    }

    public Response redeployContainers(String envName, String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String envName, String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String envName, final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(envName, session, nodeGroup, nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String envName, final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(envName, session, nodeGroup, nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String envName, String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String envName, String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String envName, final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(envName, session, nodeGroup, nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String envName, final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(envName, session, nodeGroup, nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String envName, String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String envName, String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String envName, final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(envName, session, nodeGroup, nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String envName, final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(envName, session, nodeGroup, nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String envName, String session, String nodeGroup, int nodeId, String tag) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String envName, String session, String nodeGroup, int nodeId, String tag, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String envName, final String session, final String nodeGroup, final int nodeId, final String tag, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(envName, session, nodeGroup, nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String envName, final String session, final String nodeGroup, final int nodeId, final String tag, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(envName, session, nodeGroup, nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String envName, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String envName, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String envName, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String envName, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(session, nodeGroup, nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(session, nodeGroup, nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, boolean skipReinstall, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("skipReinstall", skipReinstall + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(nodeGroup, nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final boolean skipReinstall, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(nodeGroup, nodeId, tag, useExistingVolumes, login, password, skipReinstall);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(session, nodeGroup, nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(session, nodeGroup, nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, String login, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("login", login);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(nodeGroup, nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final String login, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(nodeGroup, nodeId, tag, useExistingVolumes, login, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String session, String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(session, nodeGroup, nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String session, final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(session, nodeGroup, nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String nodeGroup, int nodeId, String tag, Boolean useExistingVolumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("useExistingVolumes", useExistingVolumes + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(nodeGroup, nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String nodeGroup, final int nodeId, final String tag, final Boolean useExistingVolumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(nodeGroup, nodeId, tag, useExistingVolumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String session, String nodeGroup, int nodeId, String tag) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String session, String nodeGroup, int nodeId, String tag, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String session, final String nodeGroup, final int nodeId, final String tag, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(session, nodeGroup, nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String session, final String nodeGroup, final int nodeId, final String tag, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(session, nodeGroup, nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String nodeGroup, int nodeId, String tag) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String nodeGroup, int nodeId, String tag, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String nodeGroup, final int nodeId, final String tag, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(nodeGroup, nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String nodeGroup, final int nodeId, final String tag, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(nodeGroup, nodeId, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public Control redeployContainers(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control redeployContainers(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Control redeployContainers(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.redeployContainers();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response redeployContainers(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, Response.class);
    }

    public Response redeployContainers(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/redeploycontainers", _params, headers, Response.class);
    }

    public ObjectResponse getContainerRunConfig(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerrunconfig", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerRunConfig(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerrunconfig", _params, headers, ObjectResponse.class);
    }

    public Control getContainerRunConfig(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunConfig(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerRunConfig(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunConfig(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerRunConfig(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerrunconfig", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerRunConfig(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerrunconfig", _params, headers, ObjectResponse.class);
    }

    public Control getContainerRunConfig(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunConfig(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerRunConfig(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunConfig(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerRunConfig(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerrunconfig", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerRunConfig(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerrunconfig", _params, headers, ObjectResponse.class);
    }

    public Control getContainerRunConfig(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunConfig(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerRunConfig(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerRunConfig(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerRunConfig(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerrunconfig", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerRunConfig(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainerrunconfig", _params, headers, ObjectResponse.class);
    }

    public NodeSSHResponse addContainerVolume(String envName, String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolume", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse addContainerVolume(String envName, String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolume", _params, headers, NodeSSHResponse.class);
    }

    public Control addContainerVolume(final String envName, final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolume(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerVolume(final String envName, final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolume(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse addContainerVolume(String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolume", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse addContainerVolume(String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolume", _params, headers, NodeSSHResponse.class);
    }

    public Control addContainerVolume(final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolume(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerVolume(final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolume(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse addContainerVolume(int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolume", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse addContainerVolume(int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolume", _params, headers, NodeSSHResponse.class);
    }

    public Control addContainerVolume(final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolume(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerVolume(final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolume(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse addContainerVolume(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolume", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse addContainerVolume(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolume", _params, headers, NodeSSHResponse.class);
    }

    public NodeSSHResponse removeContainerVolume(String envName, String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolume", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse removeContainerVolume(String envName, String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolume", _params, headers, NodeSSHResponse.class);
    }

    public Control removeContainerVolume(final String envName, final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolume(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerVolume(final String envName, final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolume(envName, session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse removeContainerVolume(String session, int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolume", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse removeContainerVolume(String session, int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolume", _params, headers, NodeSSHResponse.class);
    }

    public Control removeContainerVolume(final String session, final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolume(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerVolume(final String session, final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolume(session, nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse removeContainerVolume(int nodeId, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolume", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse removeContainerVolume(int nodeId, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolume", _params, headers, NodeSSHResponse.class);
    }

    public Control removeContainerVolume(final int nodeId, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolume(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerVolume(final int nodeId, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolume(nodeId, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse removeContainerVolume(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolume", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse removeContainerVolume(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolume", _params, headers, NodeSSHResponse.class);
    }

    public NodeSSHResponse addContainerVolumeByGroup(String envName, String session, String nodeGroup, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumebygroup", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse addContainerVolumeByGroup(String envName, String session, String nodeGroup, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumebygroup", _params, headers, NodeSSHResponse.class);
    }

    public Control addContainerVolumeByGroup(final String envName, final String session, final String nodeGroup, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolumeByGroup(envName, session, nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerVolumeByGroup(final String envName, final String session, final String nodeGroup, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolumeByGroup(envName, session, nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse addContainerVolumeByGroup(String session, String nodeGroup, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumebygroup", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse addContainerVolumeByGroup(String session, String nodeGroup, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumebygroup", _params, headers, NodeSSHResponse.class);
    }

    public Control addContainerVolumeByGroup(final String session, final String nodeGroup, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolumeByGroup(session, nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerVolumeByGroup(final String session, final String nodeGroup, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolumeByGroup(session, nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse addContainerVolumeByGroup(String nodeGroup, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumebygroup", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse addContainerVolumeByGroup(String nodeGroup, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumebygroup", _params, headers, NodeSSHResponse.class);
    }

    public Control addContainerVolumeByGroup(final String nodeGroup, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolumeByGroup(nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerVolumeByGroup(final String nodeGroup, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.addContainerVolumeByGroup(nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse addContainerVolumeByGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumebygroup", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse addContainerVolumeByGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumebygroup", _params, headers, NodeSSHResponse.class);
    }

    public NodeSSHResponses addContainerVolumes(String envName, String session, String nodeGroup, int nodeId, String volumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumes", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses addContainerVolumes(String envName, String session, String nodeGroup, int nodeId, String volumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumes", _params, headers, NodeSSHResponses.class);
    }

    public Control addContainerVolumes(final String envName, final String session, final String nodeGroup, final int nodeId, final String volumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.addContainerVolumes(envName, session, nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerVolumes(final String envName, final String session, final String nodeGroup, final int nodeId, final String volumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.addContainerVolumes(envName, session, nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses addContainerVolumes(String session, String nodeGroup, int nodeId, String volumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumes", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses addContainerVolumes(String session, String nodeGroup, int nodeId, String volumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumes", _params, headers, NodeSSHResponses.class);
    }

    public Control addContainerVolumes(final String session, final String nodeGroup, final int nodeId, final String volumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.addContainerVolumes(session, nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerVolumes(final String session, final String nodeGroup, final int nodeId, final String volumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.addContainerVolumes(session, nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses addContainerVolumes(String nodeGroup, int nodeId, String volumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumes", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses addContainerVolumes(String nodeGroup, int nodeId, String volumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumes", _params, headers, NodeSSHResponses.class);
    }

    public Control addContainerVolumes(final String nodeGroup, final int nodeId, final String volumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.addContainerVolumes(nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerVolumes(final String nodeGroup, final int nodeId, final String volumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.addContainerVolumes(nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses addContainerVolumes(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumes", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses addContainerVolumes(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/addcontainervolumes", _params, headers, NodeSSHResponses.class);
    }

    public NodeSSHResponse removeContainerVolumeByGroup(String envName, String session, String nodeGroup, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumebygroup", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse removeContainerVolumeByGroup(String envName, String session, String nodeGroup, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumebygroup", _params, headers, NodeSSHResponse.class);
    }

    public Control removeContainerVolumeByGroup(final String envName, final String session, final String nodeGroup, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolumeByGroup(envName, session, nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerVolumeByGroup(final String envName, final String session, final String nodeGroup, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolumeByGroup(envName, session, nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse removeContainerVolumeByGroup(String session, String nodeGroup, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumebygroup", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse removeContainerVolumeByGroup(String session, String nodeGroup, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumebygroup", _params, headers, NodeSSHResponse.class);
    }

    public Control removeContainerVolumeByGroup(final String session, final String nodeGroup, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolumeByGroup(session, nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerVolumeByGroup(final String session, final String nodeGroup, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolumeByGroup(session, nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse removeContainerVolumeByGroup(String nodeGroup, String path) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumebygroup", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse removeContainerVolumeByGroup(String nodeGroup, String path, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("path", path);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumebygroup", _params, headers, NodeSSHResponse.class);
    }

    public Control removeContainerVolumeByGroup(final String nodeGroup, final String path, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolumeByGroup(nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerVolumeByGroup(final String nodeGroup, final String path, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponse response = Control.this.removeContainerVolumeByGroup(nodeGroup, path);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponse removeContainerVolumeByGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumebygroup", _params, NodeSSHResponse.class);
    }

    public NodeSSHResponse removeContainerVolumeByGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponse)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumebygroup", _params, headers, NodeSSHResponse.class);
    }

    public NodeSSHResponses removeContainerVolumes(String envName, String session, String nodeGroup, int nodeId, String volumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumes", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses removeContainerVolumes(String envName, String session, String nodeGroup, int nodeId, String volumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumes", _params, headers, NodeSSHResponses.class);
    }

    public Control removeContainerVolumes(final String envName, final String session, final String nodeGroup, final int nodeId, final String volumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.removeContainerVolumes(envName, session, nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerVolumes(final String envName, final String session, final String nodeGroup, final int nodeId, final String volumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.removeContainerVolumes(envName, session, nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses removeContainerVolumes(String session, String nodeGroup, int nodeId, String volumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumes", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses removeContainerVolumes(String session, String nodeGroup, int nodeId, String volumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumes", _params, headers, NodeSSHResponses.class);
    }

    public Control removeContainerVolumes(final String session, final String nodeGroup, final int nodeId, final String volumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.removeContainerVolumes(session, nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerVolumes(final String session, final String nodeGroup, final int nodeId, final String volumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.removeContainerVolumes(session, nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses removeContainerVolumes(String nodeGroup, int nodeId, String volumes) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumes", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses removeContainerVolumes(String nodeGroup, int nodeId, String volumes, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("volumes", volumes);
        _params.put("client_source", this.client_source);
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumes", _params, headers, NodeSSHResponses.class);
    }

    public Control removeContainerVolumes(final String nodeGroup, final int nodeId, final String volumes, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.removeContainerVolumes(nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerVolumes(final String nodeGroup, final int nodeId, final String volumes, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NodeSSHResponses response = Control.this.removeContainerVolumes(nodeGroup, nodeId, volumes);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public NodeSSHResponses removeContainerVolumes(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumes", _params, NodeSSHResponses.class);
    }

    public NodeSSHResponses removeContainerVolumes(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (NodeSSHResponses)this._call(this.appid, this.serviceUrl + "rest/removecontainervolumes", _params, headers, NodeSSHResponses.class);
    }

    public ObjectResponse getContainerVolumesById(String envName, String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbyid", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerVolumesById(String envName, String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbyid", _params, headers, ObjectResponse.class);
    }

    public Control getContainerVolumesById(final String envName, final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesById(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerVolumesById(final String envName, final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesById(envName, session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerVolumesById(String session, int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbyid", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerVolumesById(String session, int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbyid", _params, headers, ObjectResponse.class);
    }

    public Control getContainerVolumesById(final String session, final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesById(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerVolumesById(final String session, final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesById(session, nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerVolumesById(int nodeId) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbyid", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerVolumesById(int nodeId, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbyid", _params, headers, ObjectResponse.class);
    }

    public Control getContainerVolumesById(final int nodeId, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesById(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerVolumesById(final int nodeId, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesById(nodeId);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerVolumesById(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbyid", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerVolumesById(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbyid", _params, headers, ObjectResponse.class);
    }

    public ObjectResponse getContainerVolumesByGroup(String envName, String session, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbygroup", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerVolumesByGroup(String envName, String session, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbygroup", _params, headers, ObjectResponse.class);
    }

    public Control getContainerVolumesByGroup(final String envName, final String session, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesByGroup(envName, session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerVolumesByGroup(final String envName, final String session, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesByGroup(envName, session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerVolumesByGroup(String session, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbygroup", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerVolumesByGroup(String session, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbygroup", _params, headers, ObjectResponse.class);
    }

    public Control getContainerVolumesByGroup(final String session, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesByGroup(session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerVolumesByGroup(final String session, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesByGroup(session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerVolumesByGroup(String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbygroup", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerVolumesByGroup(String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbygroup", _params, headers, ObjectResponse.class);
    }

    public Control getContainerVolumesByGroup(final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesByGroup(nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getContainerVolumesByGroup(final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getContainerVolumesByGroup(nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getContainerVolumesByGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbygroup", _params, ObjectResponse.class);
    }

    public ObjectResponse getContainerVolumesByGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getcontainervolumesbygroup", _params, headers, ObjectResponse.class);
    }

    public ObjectResponse getNodeGroups(String envName, String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getnodegroups", _params, ObjectResponse.class);
    }

    public ObjectResponse getNodeGroups(String envName, String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getnodegroups", _params, headers, ObjectResponse.class);
    }

    public Control getNodeGroups(final String envName, final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getNodeGroups(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getNodeGroups(final String envName, final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getNodeGroups(envName, session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getNodeGroups(String session) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getnodegroups", _params, ObjectResponse.class);
    }

    public ObjectResponse getNodeGroups(String session, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getnodegroups", _params, headers, ObjectResponse.class);
    }

    public Control getNodeGroups(final String session, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getNodeGroups(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getNodeGroups(final String session, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getNodeGroups(session);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getNodeGroups() {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getnodegroups", _params, ObjectResponse.class);
    }

    public Control getNodeGroups(final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getNodeGroups();
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getNodeGroups(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getnodegroups", _params, ObjectResponse.class);
    }

    public ObjectResponse getNodeGroups(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/getnodegroups", _params, headers, ObjectResponse.class);
    }

    public Response editNodeGroup(String envName, String session, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/editnodegroup", _params, Response.class);
    }

    public Response editNodeGroup(String envName, String session, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/editnodegroup", _params, headers, Response.class);
    }

    public Control editNodeGroup(final String envName, final String session, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.editNodeGroup(envName, session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editNodeGroup(final String envName, final String session, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.editNodeGroup(envName, session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response editNodeGroup(String session, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/editnodegroup", _params, Response.class);
    }

    public Response editNodeGroup(String session, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/editnodegroup", _params, headers, Response.class);
    }

    public Control editNodeGroup(final String session, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.editNodeGroup(session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editNodeGroup(final String session, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.editNodeGroup(session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response editNodeGroup(String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/editnodegroup", _params, Response.class);
    }

    public Response editNodeGroup(String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/editnodegroup", _params, headers, Response.class);
    }

    public Control editNodeGroup(final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.editNodeGroup(nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editNodeGroup(final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.editNodeGroup(nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response editNodeGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/editnodegroup", _params, Response.class);
    }

    public Response editNodeGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/editnodegroup", _params, headers, Response.class);
    }

    public Response setNodeGroupDisplayName(String envName, String session, String nodeGroup, String displayName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodegroupdisplayname", _params, Response.class);
    }

    public Response setNodeGroupDisplayName(String envName, String session, String nodeGroup, String displayName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodegroupdisplayname", _params, headers, Response.class);
    }

    public Control setNodeGroupDisplayName(final String envName, final String session, final String nodeGroup, final String displayName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeGroupDisplayName(envName, session, nodeGroup, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setNodeGroupDisplayName(final String envName, final String session, final String nodeGroup, final String displayName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeGroupDisplayName(envName, session, nodeGroup, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setNodeGroupDisplayName(String envName, String session, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodegroupdisplayname", _params, Response.class);
    }

    public Response setNodeGroupDisplayName(String envName, String session, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodegroupdisplayname", _params, headers, Response.class);
    }

    public Control setNodeGroupDisplayName(final String envName, final String session, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeGroupDisplayName(envName, session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setNodeGroupDisplayName(final String envName, final String session, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeGroupDisplayName(envName, session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setNodeGroupDisplayName(String nodeGroup, String displayName) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodegroupdisplayname", _params, Response.class);
    }

    public Response setNodeGroupDisplayName(String nodeGroup, String displayName, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("displayName", displayName);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodegroupdisplayname", _params, headers, Response.class);
    }

    public Control setNodeGroupDisplayName(final String nodeGroup, final String displayName, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeGroupDisplayName(nodeGroup, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setNodeGroupDisplayName(final String nodeGroup, final String displayName, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeGroupDisplayName(nodeGroup, displayName);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setNodeGroupDisplayName(String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodegroupdisplayname", _params, Response.class);
    }

    public Response setNodeGroupDisplayName(String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodegroupdisplayname", _params, headers, Response.class);
    }

    public Control setNodeGroupDisplayName(final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeGroupDisplayName(nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setNodeGroupDisplayName(final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setNodeGroupDisplayName(nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setNodeGroupDisplayName(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodegroupdisplayname", _params, Response.class);
    }

    public Response setNodeGroupDisplayName(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setnodegroupdisplayname", _params, headers, Response.class);
    }

    public Response applyNodeGroupData(String envName, String session, String nodeGroup, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/applynodegroupdata", _params, Response.class);
    }

    public Response applyNodeGroupData(String envName, String session, String nodeGroup, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/applynodegroupdata", _params, headers, Response.class);
    }

    public Control applyNodeGroupData(final String envName, final String session, final String nodeGroup, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.applyNodeGroupData(envName, session, nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control applyNodeGroupData(final String envName, final String session, final String nodeGroup, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.applyNodeGroupData(envName, session, nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response applyNodeGroupData(String session, String nodeGroup, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/applynodegroupdata", _params, Response.class);
    }

    public Response applyNodeGroupData(String session, String nodeGroup, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/applynodegroupdata", _params, headers, Response.class);
    }

    public Control applyNodeGroupData(final String session, final String nodeGroup, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.applyNodeGroupData(session, nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control applyNodeGroupData(final String session, final String nodeGroup, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.applyNodeGroupData(session, nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response applyNodeGroupData(String nodeGroup, String data) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/applynodegroupdata", _params, Response.class);
    }

    public Response applyNodeGroupData(String nodeGroup, String data, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("data", data);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/applynodegroupdata", _params, headers, Response.class);
    }

    public Control applyNodeGroupData(final String nodeGroup, final String data, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.applyNodeGroupData(nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control applyNodeGroupData(final String nodeGroup, final String data, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.applyNodeGroupData(nodeGroup, data);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response applyNodeGroupData(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/applynodegroupdata", _params, Response.class);
    }

    public Response applyNodeGroupData(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/applynodegroupdata", _params, headers, Response.class);
    }

    public Response attachEnvGroup(String envName, String session, String envGroup, String envGroups) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/attachenvgroup", _params, Response.class);
    }

    public Response attachEnvGroup(String envName, String session, String envGroup, String envGroups, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/attachenvgroup", _params, headers, Response.class);
    }

    public Control attachEnvGroup(final String envName, final String session, final String envGroup, final String envGroups, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.attachEnvGroup(envName, session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control attachEnvGroup(final String envName, final String session, final String envGroup, final String envGroups, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.attachEnvGroup(envName, session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response attachEnvGroup(String session, String envGroup, String envGroups) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/attachenvgroup", _params, Response.class);
    }

    public Response attachEnvGroup(String session, String envGroup, String envGroups, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/attachenvgroup", _params, headers, Response.class);
    }

    public Control attachEnvGroup(final String session, final String envGroup, final String envGroups, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.attachEnvGroup(session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control attachEnvGroup(final String session, final String envGroup, final String envGroups, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.attachEnvGroup(session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response attachEnvGroup(String envGroup, String envGroups) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/attachenvgroup", _params, Response.class);
    }

    public Response attachEnvGroup(String envGroup, String envGroups, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/attachenvgroup", _params, headers, Response.class);
    }

    public Control attachEnvGroup(final String envGroup, final String envGroups, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.attachEnvGroup(envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control attachEnvGroup(final String envGroup, final String envGroups, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.attachEnvGroup(envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response attachEnvGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/attachenvgroup", _params, Response.class);
    }

    public Response attachEnvGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/attachenvgroup", _params, headers, Response.class);
    }

    public Response detachEnvGroup(String envName, String session, String envGroup, String envGroups) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/detachenvgroup", _params, Response.class);
    }

    public Response detachEnvGroup(String envName, String session, String envGroup, String envGroups, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/detachenvgroup", _params, headers, Response.class);
    }

    public Control detachEnvGroup(final String envName, final String session, final String envGroup, final String envGroups, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.detachEnvGroup(envName, session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control detachEnvGroup(final String envName, final String session, final String envGroup, final String envGroups, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.detachEnvGroup(envName, session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response detachEnvGroup(String session, String envGroup, String envGroups) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/detachenvgroup", _params, Response.class);
    }

    public Response detachEnvGroup(String session, String envGroup, String envGroups, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/detachenvgroup", _params, headers, Response.class);
    }

    public Control detachEnvGroup(final String session, final String envGroup, final String envGroups, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.detachEnvGroup(session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control detachEnvGroup(final String session, final String envGroup, final String envGroups, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.detachEnvGroup(session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response detachEnvGroup(String envGroup, String envGroups) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/detachenvgroup", _params, Response.class);
    }

    public Response detachEnvGroup(String envGroup, String envGroups, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/detachenvgroup", _params, headers, Response.class);
    }

    public Control detachEnvGroup(final String envGroup, final String envGroups, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.detachEnvGroup(envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control detachEnvGroup(final String envGroup, final String envGroups, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.detachEnvGroup(envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response detachEnvGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/detachenvgroup", _params, Response.class);
    }

    public Response detachEnvGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/detachenvgroup", _params, headers, Response.class);
    }

    public Response setEnvGroup(String envName, String session, String envGroup, String envGroups) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvgroup", _params, Response.class);
    }

    public Response setEnvGroup(String envName, String session, String envGroup, String envGroups, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvgroup", _params, headers, Response.class);
    }

    public Control setEnvGroup(final String envName, final String session, final String envGroup, final String envGroups, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvGroup(envName, session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setEnvGroup(final String envName, final String session, final String envGroup, final String envGroups, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvGroup(envName, session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setEnvGroup(String session, String envGroup, String envGroups) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvgroup", _params, Response.class);
    }

    public Response setEnvGroup(String session, String envGroup, String envGroups, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvgroup", _params, headers, Response.class);
    }

    public Control setEnvGroup(final String session, final String envGroup, final String envGroups, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvGroup(session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setEnvGroup(final String session, final String envGroup, final String envGroups, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvGroup(session, envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setEnvGroup(String envGroup, String envGroups) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvgroup", _params, Response.class);
    }

    public Response setEnvGroup(String envGroup, String envGroups, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("envGroup", envGroup);
        _params.put("envGroups", envGroups);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvgroup", _params, headers, Response.class);
    }

    public Control setEnvGroup(final String envGroup, final String envGroups, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvGroup(envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setEnvGroup(final String envGroup, final String envGroups, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setEnvGroup(envGroup, envGroups);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setEnvGroup(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvgroup", _params, Response.class);
    }

    public Response setEnvGroup(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setenvgroup", _params, headers, Response.class);
    }

    public ObjectResponse getTemplateManifest(String appid, String session, String nodeType, String tag) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/gettemplatemanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getTemplateManifest(String appid, String session, String nodeType, String tag, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(appid, this.serviceUrl + "rest/gettemplatemanifest", _params, headers, ObjectResponse.class);
    }

    public Control getTemplateManifest(final String appid, final String session, final String nodeType, final String tag, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getTemplateManifest(appid, session, nodeType, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getTemplateManifest(final String appid, final String session, final String nodeType, final String tag, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getTemplateManifest(appid, session, nodeType, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getTemplateManifest(String session, String nodeType, String tag) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplatemanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getTemplateManifest(String session, String nodeType, String tag, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("nodeType", nodeType);
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplatemanifest", _params, headers, ObjectResponse.class);
    }

    public Control getTemplateManifest(final String session, final String nodeType, final String tag, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getTemplateManifest(session, nodeType, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getTemplateManifest(final String session, final String nodeType, final String tag, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getTemplateManifest(session, nodeType, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getTemplateManifest(String nodeType, String tag) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("nodeType", nodeType);
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplatemanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getTemplateManifest(String nodeType, String tag, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("nodeType", nodeType);
        _params.put("tag", tag);
        _params.put("client_source", this.client_source);
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplatemanifest", _params, headers, ObjectResponse.class);
    }

    public Control getTemplateManifest(final String nodeType, final String tag, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getTemplateManifest(nodeType, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getTemplateManifest(final String nodeType, final String tag, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectResponse response = Control.this.getTemplateManifest(nodeType, tag);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectResponse getTemplateManifest(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplatemanifest", _params, ObjectResponse.class);
    }

    public ObjectResponse getTemplateManifest(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectResponse)this._call(this.appid, this.serviceUrl + "rest/gettemplatemanifest", _params, headers, ObjectResponse.class);
    }

    public Response addContainerEnvVars(String envName, String session, String nodeGroup, int nodeId, String vars) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/addcontainerenvvars", _params, Response.class);
    }

    public Response addContainerEnvVars(String envName, String session, String nodeGroup, int nodeId, String vars, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/addcontainerenvvars", _params, headers, Response.class);
    }

    public Control addContainerEnvVars(final String envName, final String session, final String nodeGroup, final int nodeId, final String vars, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.addContainerEnvVars(envName, session, nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerEnvVars(final String envName, final String session, final String nodeGroup, final int nodeId, final String vars, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.addContainerEnvVars(envName, session, nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response addContainerEnvVars(String session, String nodeGroup, int nodeId, String vars) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/addcontainerenvvars", _params, Response.class);
    }

    public Response addContainerEnvVars(String session, String nodeGroup, int nodeId, String vars, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/addcontainerenvvars", _params, headers, Response.class);
    }

    public Control addContainerEnvVars(final String session, final String nodeGroup, final int nodeId, final String vars, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.addContainerEnvVars(session, nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerEnvVars(final String session, final String nodeGroup, final int nodeId, final String vars, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.addContainerEnvVars(session, nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response addContainerEnvVars(String nodeGroup, int nodeId, String vars) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/addcontainerenvvars", _params, Response.class);
    }

    public Response addContainerEnvVars(String nodeGroup, int nodeId, String vars, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/addcontainerenvvars", _params, headers, Response.class);
    }

    public Control addContainerEnvVars(final String nodeGroup, final int nodeId, final String vars, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.addContainerEnvVars(nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control addContainerEnvVars(final String nodeGroup, final int nodeId, final String vars, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.addContainerEnvVars(nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response addContainerEnvVars(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/addcontainerenvvars", _params, Response.class);
    }

    public Response addContainerEnvVars(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/addcontainerenvvars", _params, headers, Response.class);
    }

    public Response removeContainerEnvVars(String envName, String session, String nodeGroup, int nodeId, String vars) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removecontainerenvvars", _params, Response.class);
    }

    public Response removeContainerEnvVars(String envName, String session, String nodeGroup, int nodeId, String vars, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removecontainerenvvars", _params, headers, Response.class);
    }

    public Control removeContainerEnvVars(final String envName, final String session, final String nodeGroup, final int nodeId, final String vars, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeContainerEnvVars(envName, session, nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerEnvVars(final String envName, final String session, final String nodeGroup, final int nodeId, final String vars, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeContainerEnvVars(envName, session, nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeContainerEnvVars(String session, String nodeGroup, int nodeId, String vars) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removecontainerenvvars", _params, Response.class);
    }

    public Response removeContainerEnvVars(String session, String nodeGroup, int nodeId, String vars, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removecontainerenvvars", _params, headers, Response.class);
    }

    public Control removeContainerEnvVars(final String session, final String nodeGroup, final int nodeId, final String vars, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeContainerEnvVars(session, nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerEnvVars(final String session, final String nodeGroup, final int nodeId, final String vars, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeContainerEnvVars(session, nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeContainerEnvVars(String nodeGroup, int nodeId, String vars) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removecontainerenvvars", _params, Response.class);
    }

    public Response removeContainerEnvVars(String nodeGroup, int nodeId, String vars, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("nodeId", nodeId + "");
        _params.put("vars", vars);
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removecontainerenvvars", _params, headers, Response.class);
    }

    public Control removeContainerEnvVars(final String nodeGroup, final int nodeId, final String vars, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeContainerEnvVars(nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control removeContainerEnvVars(final String nodeGroup, final int nodeId, final String vars, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.removeContainerEnvVars(nodeGroup, nodeId, vars);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response removeContainerEnvVars(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removecontainerenvvars", _params, Response.class);
    }

    public Response removeContainerEnvVars(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/removecontainerenvvars", _params, headers, Response.class);
    }

    public ObjectsCountResponse editRegistryCredentials(String appid, String session, String filter, String user, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("filter", filter);
        _params.put("user", user);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ObjectsCountResponse)this._call(appid, this.serviceUrl + "rest/editregistrycredentials", _params, ObjectsCountResponse.class);
    }

    public ObjectsCountResponse editRegistryCredentials(String appid, String session, String filter, String user, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("filter", filter);
        _params.put("user", user);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ObjectsCountResponse)this._call(appid, this.serviceUrl + "rest/editregistrycredentials", _params, headers, ObjectsCountResponse.class);
    }

    public Control editRegistryCredentials(final String appid, final String session, final String filter, final String user, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectsCountResponse response = Control.this.editRegistryCredentials(appid, session, filter, user, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editRegistryCredentials(final String appid, final String session, final String filter, final String user, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectsCountResponse response = Control.this.editRegistryCredentials(appid, session, filter, user, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectsCountResponse editRegistryCredentials(String appid, String session, String filter) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("filter", filter);
        _params.put("client_source", this.client_source);
        return (ObjectsCountResponse)this._call(appid, this.serviceUrl + "rest/editregistrycredentials", _params, ObjectsCountResponse.class);
    }

    public ObjectsCountResponse editRegistryCredentials(String appid, String session, String filter, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", appid);
        _params.put("session", session);
        _params.put("filter", filter);
        _params.put("client_source", this.client_source);
        return (ObjectsCountResponse)this._call(appid, this.serviceUrl + "rest/editregistrycredentials", _params, headers, ObjectsCountResponse.class);
    }

    public Control editRegistryCredentials(final String appid, final String session, final String filter, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectsCountResponse response = Control.this.editRegistryCredentials(appid, session, filter);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editRegistryCredentials(final String appid, final String session, final String filter, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectsCountResponse response = Control.this.editRegistryCredentials(appid, session, filter);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectsCountResponse editRegistryCredentials(String session, String filter, String user, String password) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("filter", filter);
        _params.put("user", user);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ObjectsCountResponse)this._call(this.appid, this.serviceUrl + "rest/editregistrycredentials", _params, ObjectsCountResponse.class);
    }

    public ObjectsCountResponse editRegistryCredentials(String session, String filter, String user, String password, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("filter", filter);
        _params.put("user", user);
        _params.put("password", password);
        _params.put("client_source", this.client_source);
        return (ObjectsCountResponse)this._call(this.appid, this.serviceUrl + "rest/editregistrycredentials", _params, headers, ObjectsCountResponse.class);
    }

    public Control editRegistryCredentials(final String session, final String filter, final String user, final String password, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectsCountResponse response = Control.this.editRegistryCredentials(session, filter, user, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editRegistryCredentials(final String session, final String filter, final String user, final String password, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectsCountResponse response = Control.this.editRegistryCredentials(session, filter, user, password);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectsCountResponse editRegistryCredentials(String session, String filter) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("filter", filter);
        _params.put("client_source", this.client_source);
        return (ObjectsCountResponse)this._call(this.appid, this.serviceUrl + "rest/editregistrycredentials", _params, ObjectsCountResponse.class);
    }

    public ObjectsCountResponse editRegistryCredentials(String session, String filter, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", session);
        _params.put("filter", filter);
        _params.put("client_source", this.client_source);
        return (ObjectsCountResponse)this._call(this.appid, this.serviceUrl + "rest/editregistrycredentials", _params, headers, ObjectsCountResponse.class);
    }

    public Control editRegistryCredentials(final String session, final String filter, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectsCountResponse response = Control.this.editRegistryCredentials(session, filter);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editRegistryCredentials(final String session, final String filter, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectsCountResponse response = Control.this.editRegistryCredentials(session, filter);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectsCountResponse editRegistryCredentials(String filter) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("filter", filter);
        _params.put("client_source", this.client_source);
        return (ObjectsCountResponse)this._call(this.appid, this.serviceUrl + "rest/editregistrycredentials", _params, ObjectsCountResponse.class);
    }

    public ObjectsCountResponse editRegistryCredentials(String filter, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("appid", this.appid);
        _params.put("session", this.session);
        _params.put("filter", filter);
        _params.put("client_source", this.client_source);
        return (ObjectsCountResponse)this._call(this.appid, this.serviceUrl + "rest/editregistrycredentials", _params, headers, ObjectsCountResponse.class);
    }

    public Control editRegistryCredentials(final String filter, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectsCountResponse response = Control.this.editRegistryCredentials(filter);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control editRegistryCredentials(final String filter, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                ObjectsCountResponse response = Control.this.editRegistryCredentials(filter);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public ObjectsCountResponse editRegistryCredentials(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectsCountResponse)this._call(this.appid, this.serviceUrl + "rest/editregistrycredentials", _params, ObjectsCountResponse.class);
    }

    public ObjectsCountResponse editRegistryCredentials(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (ObjectsCountResponse)this._call(this.appid, this.serviceUrl + "rest/editregistrycredentials", _params, headers, ObjectsCountResponse.class);
    }

    public RegistryInfoResponse getRegistryInfo(String envName, String session, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (RegistryInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getregistryinfo", _params, RegistryInfoResponse.class);
    }

    public RegistryInfoResponse getRegistryInfo(String envName, String session, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (RegistryInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getregistryinfo", _params, headers, RegistryInfoResponse.class);
    }

    public Control getRegistryInfo(final String envName, final String session, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RegistryInfoResponse response = Control.this.getRegistryInfo(envName, session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegistryInfo(final String envName, final String session, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RegistryInfoResponse response = Control.this.getRegistryInfo(envName, session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public RegistryInfoResponse getRegistryInfo(String session, String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (RegistryInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getregistryinfo", _params, RegistryInfoResponse.class);
    }

    public RegistryInfoResponse getRegistryInfo(String session, String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (RegistryInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getregistryinfo", _params, headers, RegistryInfoResponse.class);
    }

    public Control getRegistryInfo(final String session, final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RegistryInfoResponse response = Control.this.getRegistryInfo(session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegistryInfo(final String session, final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RegistryInfoResponse response = Control.this.getRegistryInfo(session, nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public RegistryInfoResponse getRegistryInfo(String nodeGroup) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (RegistryInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getregistryinfo", _params, RegistryInfoResponse.class);
    }

    public RegistryInfoResponse getRegistryInfo(String nodeGroup, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("client_source", this.client_source);
        return (RegistryInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getregistryinfo", _params, headers, RegistryInfoResponse.class);
    }

    public Control getRegistryInfo(final String nodeGroup, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RegistryInfoResponse response = Control.this.getRegistryInfo(nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control getRegistryInfo(final String nodeGroup, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RegistryInfoResponse response = Control.this.getRegistryInfo(nodeGroup);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public RegistryInfoResponse getRegistryInfo(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (RegistryInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getregistryinfo", _params, RegistryInfoResponse.class);
    }

    public RegistryInfoResponse getRegistryInfo(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (RegistryInfoResponse)this._call(this.appid, this.serviceUrl + "rest/getregistryinfo", _params, headers, RegistryInfoResponse.class);
    }

    public Response skipMessage(String envName, String session, int nodeId, int id) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/skipmessage", _params, Response.class);
    }

    public Response skipMessage(String envName, String session, int nodeId, int id, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/skipmessage", _params, headers, Response.class);
    }

    public Control skipMessage(final String envName, final String session, final int nodeId, final int id, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.skipMessage(envName, session, nodeId, id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control skipMessage(final String envName, final String session, final int nodeId, final int id, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.skipMessage(envName, session, nodeId, id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response skipMessage(String session, int nodeId, int id) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/skipmessage", _params, Response.class);
    }

    public Response skipMessage(String session, int nodeId, int id, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", session);
        _params.put("nodeId", nodeId + "");
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/skipmessage", _params, headers, Response.class);
    }

    public Control skipMessage(final String session, final int nodeId, final int id, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.skipMessage(session, nodeId, id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control skipMessage(final String session, final int nodeId, final int id, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.skipMessage(session, nodeId, id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response skipMessage(int nodeId, int id) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/skipmessage", _params, Response.class);
    }

    public Response skipMessage(int nodeId, int id, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", this.appid);
        _params.put("session", this.session);
        _params.put("nodeId", nodeId + "");
        _params.put("id", id + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/skipmessage", _params, headers, Response.class);
    }

    public Control skipMessage(final int nodeId, final int id, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.skipMessage(nodeId, id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control skipMessage(final int nodeId, final int id, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.skipMessage(nodeId, id);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response skipMessage(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/skipmessage", _params, Response.class);
    }

    public Response skipMessage(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/skipmessage", _params, headers, Response.class);
    }

    public Response setSLBAccessEnabled(String envName, String session, String nodeGroup, Boolean enabled) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("enabled", enabled + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setslbaccessenabled", _params, Response.class);
    }

    public Response setSLBAccessEnabled(String envName, String session, String nodeGroup, Boolean enabled, Map headers) {
        HashMap<String, String> _params = new HashMap<String, String>();
        _params.put("envName", envName);
        _params.put("session", session);
        _params.put("nodeGroup", nodeGroup);
        _params.put("enabled", enabled + "");
        _params.put("client_source", this.client_source);
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setslbaccessenabled", _params, headers, Response.class);
    }

    public Control setSLBAccessEnabled(final String envName, final String session, final String nodeGroup, final Boolean enabled, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setSLBAccessEnabled(envName, session, nodeGroup, enabled);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Control setSLBAccessEnabled(final String envName, final String session, final String nodeGroup, final Boolean enabled, Map headers, final Callback callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Response response = Control.this.setSLBAccessEnabled(envName, session, nodeGroup, enabled);
                callback.fire(response);
            }
        }, "callback").start();
        return this;
    }

    public Response setSLBAccessEnabled(Map _params) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setslbaccessenabled", _params, Response.class);
    }

    public Response setSLBAccessEnabled(Map _params, Map headers) {
        if (!_params.containsKey("appid")) {
            _params.put("appid", this.appid);
        }
        if (!_params.containsKey("session")) {
            _params.put("session", this.session);
        }
        if (!_params.containsKey("client_source")) {
            _params.put("client_source", this.client_source);
        }
        return (Response)this._call(this.appid, this.serviceUrl + "rest/setslbaccessenabled", _params, headers, Response.class);
    }
}

