/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.development.response.interfaces;

import com.jelastic.api.core.utils.DateUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ArrayItem {
    protected int id;

    public void set(final String name, final Object value) {
        Permissions perms = new Permissions();
        perms.add(new AllPermission());
        ProtectionDomain domain = new ProtectionDomain(new CodeSource((URL)null, (Certificate[])null), perms);
        AccessControlContext relaxedAcc = new AccessControlContext(new ProtectionDomain[]{domain});
        final Class<?> clazz = this.getClass();
        final ArrayItem _this = this;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field field = null;
                    try {
                        field = clazz.getDeclaredField(name);
                    }
                    catch (NoSuchFieldException ex1) {
                        try {
                            field = clazz.getField(name);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    field.setAccessible(true);
                    field.set(_this, value);
                    return 0;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, relaxedAcc);
    }

    public Object get(final String name) {
        Permissions perms = new Permissions();
        perms.add(new AllPermission());
        ProtectionDomain domain = new ProtectionDomain(new CodeSource((URL)null, (Certificate[])null), perms);
        AccessControlContext relaxedAcc = new AccessControlContext(new ProtectionDomain[]{domain});
        final Class<?> clazz = this.getClass();
        final ArrayItem _this = this;
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Field field = null;
                    try {
                        field = clazz.getDeclaredField(name);
                    }
                    catch (NoSuchFieldException ex1) {
                        try {
                            field = clazz.getField(name);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            // empty catch block
                        }
                    }
                    if (field != null) {
                        field.setAccessible(true);
                        return field.get(_this);
                    }
                    String methodName = "get" + name.substring(0, 1).toUpperCase() + name.substring(1);
                    Method method = null;
                    try {
                        method = clazz.getDeclaredMethod(methodName, new Class[0]);
                    }
                    catch (NoSuchMethodException ex1) {
                        try {
                            method = clazz.getMethod(methodName, new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (method != null) {
                        method.setAccessible(true);
                        return method.invoke(_this, new Object[0]);
                    }
                    throw new RuntimeException("field [" + name + "] or method [" + methodName + "] not exist");
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }, relaxedAcc);
    }

    public JSONObject _toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        this.primaryKeyToJson(json);
        for (Field field : this.getClass().getDeclaredFields()) {
            Object value = this.get(field.getName());
            if (value == null) continue;
            if (ArrayItem.class.isAssignableFrom(field.getType())) {
                json.put(field.getName(), (Object)((ArrayItem)value)._toJSON());
                continue;
            }
            json.put(field.getName(), value);
        }
        return json;
    }

    public ArrayItem _fromString(String stringJson) throws JSONException {
        JSONObject json = new JSONObject(stringJson);
        return this._fromJSON(json);
    }

    public ArrayItem _fromJSON(JSONObject json) throws JSONException {
        this.primaryKeyFromJson(json);
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!json.has(field.getName())) continue;
            try {
                if (ArrayItem.class.isAssignableFrom(field.getType())) {
                    this.set(field.getName(), ((ArrayItem)Class.forName(field.getType().getCanonicalName()).newInstance())._fromJSON(json.getJSONObject(field.getName())));
                    continue;
                }
                field.set(this, this.getFromJson(field, json));
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this;
    }

    private Object getFromJson(Field field, JSONObject jsonObject) throws JSONException {
        if (field.getType().equals(String.class)) {
            return jsonObject.getString(field.getName());
        }
        if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE)) {
            return jsonObject.getInt(field.getName());
        }
        if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
            return jsonObject.getLong(field.getName());
        }
        if (field.getType().equals(Double.class) || field.getType().equals(Double.TYPE)) {
            return jsonObject.getDouble(field.getName());
        }
        if (field.getType().equals(Date.class)) {
            try {
                return DateUtils.parseSqlDateTime(jsonObject.getString(field.getName()));
            }
            catch (ParseException ex) {
                throw new JSONException("JSONObject['" + field.getName() + "'] is not a Date.");
            }
        }
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            String stringBoolean = jsonObject.getString(field.getName());
            if (stringBoolean.equalsIgnoreCase(Boolean.TRUE.toString()) || stringBoolean.equals("1")) {
                return Boolean.TRUE;
            }
            if (stringBoolean.equalsIgnoreCase(Boolean.FALSE.toString()) || stringBoolean.equals("0")) {
                return Boolean.FALSE;
            }
            throw new JSONException("JSONObject['" + field.getName() + "'] is not a Boolean.");
        }
        return jsonObject.get(field.getName());
    }

    protected void primaryKeyToJson(JSONObject json) throws JSONException {
        try {
            Method getIdMethod = this.getClass().getMethod("getId", null);
            int id = (Integer)getIdMethod.invoke((Object)this, new Object[0]);
            json.put("id", id);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    protected void primaryKeyFromJson(JSONObject json) throws JSONException {
        if (json.has("id")) {
            try {
                Method getIdMethod = this.getClass().getMethod("setId", Integer.TYPE);
                getIdMethod.invoke((Object)this, json.getInt("id"));
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public static Map<String, String> convertJSONObjectToStringMap(JSONObject jsonObject) {
        Iterator iterator = jsonObject.keys();
        HashMap<String, String> map = new HashMap<String, String>();
        while (iterator.hasNext()) {
            String fieldName = iterator.next().toString();
            String fieldValue = null;
            if (!jsonObject.isNull(fieldName)) {
                try {
                    fieldValue = jsonObject.getString(fieldName);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            map.put(fieldName, fieldValue);
        }
        return map;
    }
}

