/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.development.response;

import com.jelastic.api.Response;
import com.jelastic.api.development.persistence.ApplicationHost;
import com.jelastic.api.json.JSONSerializable;
import java.util.Collection;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ApplicationHostsResponse
extends Response
implements JSONSerializable {
    private Collection<ApplicationHost> hosts = null;
    private ApplicationHost optimal = null;

    public ApplicationHostsResponse(ApplicationHost optimal, Collection<ApplicationHost> hosts) {
        super(0);
        this.optimal = optimal;
        this.hosts = hosts;
    }

    public ApplicationHostsResponse() {
        super(0);
    }

    public ApplicationHostsResponse(int result) {
        super(result);
    }

    public ApplicationHostsResponse(int result, String error) {
        super(result, error);
    }

    public ApplicationHostsResponse(Response resp) {
        this.setResult(resp.getResult());
        this.setError(resp.getError());
    }

    public Collection<ApplicationHost> getHosts() {
        return this.hosts;
    }

    public void setHosts(Collection<ApplicationHost> hosts) {
        this.hosts = hosts;
    }

    public ApplicationHost getOptimal() {
        return this.optimal;
    }

    public void setOptimal(ApplicationHost optimal) {
        this.optimal = optimal;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        try {
            if (this.optimal != null) {
                json.put("optimal", (Object)new Host(this.optimal).toJSON());
            }
            if (this.hosts != null) {
                JSONArray array = new JSONArray();
                for (ApplicationHost host : this.hosts) {
                    array.put((Object)new Host(host).toJSON());
                }
                json.put("hosts", (Object)array);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                json.put("result", 99).put("error", (Object)ex.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return json;
    }

    @Override
    public ApplicationHostsResponse fromJSON(JSONObject json) {
        Response response = super.fromJSON(json);
        try {
            if (json.has("optimal")) {
                this.optimal = new ApplicationHost();
                Host host = new Host().fromJSON(json.getJSONObject("optimal"));
                this.optimal.setDomain(host.domain);
                this.optimal.setIp(host.ip);
            }
            if (json.has("hosts")) {
                JSONArray jsonHosts = json.getJSONArray("hosts");
                this.hosts = new LinkedList<ApplicationHost>();
                for (int i = 0; i < jsonHosts.length(); ++i) {
                    Host host = new Host().fromJSON(jsonHosts.getJSONObject(i));
                    ApplicationHost appHost = new ApplicationHost();
                    appHost.setDomain(host.domain);
                    appHost.setIp(host.ip);
                    this.hosts.add(appHost);
                }
            }
        }
        catch (JSONException ex) {
            response = new Response(99, ex.toString());
        }
        this.setResult(response.getResult());
        this.setError(response.getError());
        return this;
    }

    public class Host {
        public String domain = null;
        public String ip = null;
        public String context = null;

        public Host() {
        }

        public Host(ApplicationHost host) {
            this(host.getDomain(), host.getIp(), host.getContext());
        }

        public Host(String domain, String ip, String context) {
            this.domain = domain;
            this.ip = ip;
            this.context = context;
        }

        public JSONObject toJSON() throws JSONException {
            return new JSONObject().put("domain", (Object)this.domain).put("ip", (Object)this.ip).put("context", (Object)this.context);
        }

        public Host fromJSON(JSONObject json) throws JSONException {
            if (json.has("domain")) {
                this.domain = json.getString("domain");
            }
            if (json.has("ip")) {
                this.ip = json.getString("ip");
            }
            if (json.has("context")) {
                this.context = json.getString("ip");
            }
            return this;
        }
    }
}

