/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.development.persistence;

public enum ApplicationStatus {
    ENABLED(0),
    BLOCKED(1),
    SYSTEM_BLOCKED(2);

    private int id;

    private ApplicationStatus(int id) {
        this.id = id;
    }

    public static final ApplicationStatus get(String status) {
        if (status == null) {
            return null;
        }
        int id = -1;
        if (status.equalsIgnoreCase(ENABLED.toString())) {
            id = 0;
        } else if (status.equalsIgnoreCase(BLOCKED.toString())) {
            id = 1;
        } else if (status.equalsIgnoreCase(SYSTEM_BLOCKED.toString())) {
            id = 2;
        } else {
            try {
                id = Integer.parseInt(status);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return ApplicationStatus.get(id);
    }

    public static final ApplicationStatus get(int id) {
        switch (id) {
            case 0: {
                return ENABLED;
            }
            case 1: {
                return BLOCKED;
            }
            case 2: {
                return SYSTEM_BLOCKED;
            }
        }
        return null;
    }
}

