/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.development.persistence;

public enum ApplicationRight {
    OWNER(0),
    ADMIN(1),
    VIEW(2),
    RESELLER(3);

    private int id;

    private ApplicationRight(int id) {
        this.id = id;
    }

    public static final ApplicationRight get(String right) {
        if (right == null) {
            return null;
        }
        int id = -1;
        if (right.equalsIgnoreCase(OWNER.toString())) {
            id = 0;
        } else if (right.equalsIgnoreCase(ADMIN.toString())) {
            id = 1;
        } else if (right.equalsIgnoreCase(VIEW.toString())) {
            id = 2;
        } else if (right.equalsIgnoreCase(RESELLER.toString())) {
            id = 3;
        } else {
            try {
                id = Integer.parseInt(right);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return ApplicationRight.get(id);
    }

    public static final ApplicationRight get(int id) {
        switch (id) {
            case 0: {
                return OWNER;
            }
            case 1: {
                return ADMIN;
            }
            case 2: {
                return VIEW;
            }
            case 3: {
                return RESELLER;
            }
        }
        return null;
    }
}

