/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.development.persistence;

import com.jelastic.api.core.utils.DateUtils;
import com.jelastic.api.development.persistence.ApiTokenPermission;
import com.jelastic.api.development.persistence.User;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiToken
implements Serializable {
    public static final String ID = "id";
    public static final String TOKEN = "key";
    public static final String API_LIST = "apiList";
    public static final String EXPIRES_AT = "expiresAt";
    public static final String DESCRIPTION = "description";
    private static final String TOKEN_TEMPLATE = "tokenTemplate";
    private static final String CREATED_ON = "createdOn";
    private static final String LAST_USED = "lastUsed";
    private Integer id;
    private String token;
    private User user;
    private Set<ApiTokenPermission> permissions = new HashSet<ApiTokenPermission>();
    private Date validTill;
    private Date expiresAt;
    private String description;
    private String tokenTemplate;
    private Date createdOn;
    private Date lastUsed;

    public ApiToken(String token, User user, Set<ApiTokenPermission> permissions) {
        this.token = token;
        this.user = user;
        this.permissions = permissions;
    }

    public ApiToken() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Set<ApiTokenPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<ApiTokenPermission> permissions) {
        this.permissions = permissions;
    }

    public Date getValidTill() {
        return this.validTill;
    }

    public void setValidTill(Date validTill) {
        this.validTill = validTill;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }

    public String getTokenTemplate() {
        return this.tokenTemplate;
    }

    public void setTokenTemplate(String tokenTemplate) {
        this.tokenTemplate = tokenTemplate;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(Date lastUsed) {
        this.lastUsed = lastUsed;
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        try {
            json.put(ID, (Object)this.getId());
            if (this.tokenTemplate != null) {
                json.put(TOKEN_TEMPLATE, (Object)this.tokenTemplate);
            }
            if (this.getPermissions() != null) {
                JSONArray permissionsJson = new JSONArray();
                for (ApiTokenPermission apiListItem : this.getPermissions()) {
                    permissionsJson.put((Object)apiListItem);
                }
                json.put(API_LIST, (Object)permissionsJson);
            }
            if (this.expiresAt != null) {
                json.put(EXPIRES_AT, (Object)DateUtils.formatSqlDateTime(this.expiresAt));
            }
            if (this.description != null) {
                json.put(DESCRIPTION, (Object)this.description);
            }
            if (this.createdOn != null) {
                json.put(CREATED_ON, (Object)DateUtils.formatSqlDateTime(this.createdOn));
            }
            if (this.lastUsed != null) {
                json.put(LAST_USED, (Object)DateUtils.formatSqlDateTime(this.lastUsed));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return json;
    }

    public ApiToken _fromJSON(JSONObject json) throws JSONException {
        if (json.has(ID)) {
            this.setId(json.getInt(ID));
        }
        if (json.has(TOKEN_TEMPLATE)) {
            this.setTokenTemplate(json.getString(TOKEN_TEMPLATE));
        }
        if (json.has(API_LIST)) {
            JSONArray permissionsJson = json.getJSONArray(API_LIST);
            for (int i = 0; i < permissionsJson.length(); ++i) {
                this.permissions.add(new ApiTokenPermission(permissionsJson.getString(i)));
            }
        }
        if (json.has(EXPIRES_AT)) {
            try {
                this.setExpiresAt(DateUtils.parseSqlDateTime(json.getString(EXPIRES_AT)));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (json.has(DESCRIPTION)) {
            this.setDescription(json.getString(DESCRIPTION));
        }
        if (json.has(CREATED_ON)) {
            try {
                this.setCreatedOn(DateUtils.parseSqlDateTime(json.getString(CREATED_ON)));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (json.has(LAST_USED)) {
            try {
                this.setLastUsed(DateUtils.parseSqlDateTime(json.getString(LAST_USED)));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return this;
    }
}

