/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.data.response;

import com.jelastic.api.Response;
import com.jelastic.api.json.JSONSerializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjectsResponse
extends Response
implements JSONSerializable {
    protected Collection<Map<String, Object>> fields = null;
    private JSONObject[] objects = null;
    private JSONObject jsonResponse = null;

    public ObjectsResponse(ObjectsResponse response) {
        this.fields = response.fields;
    }

    public ObjectsResponse(Collection<Map<String, Object>> objects) {
        super(0);
        this.fields = objects;
        this.toJSON();
    }

    public ObjectsResponse() {
        super(0);
    }

    public ObjectsResponse(int result, String error) {
        super(result, error);
    }

    public ObjectsResponse(Response resp) {
        this.setResult(resp.getResult());
        this.setError(resp.getError());
    }

    public int size() {
        return this.fields == null ? 0 : this.fields.size();
    }

    public Map<String, Object> getFirstObject() {
        return this.size() == 0 ? null : this.fields.iterator().next();
    }

    public JSONObject[] getObjects() {
        return this.objects;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        try {
            if (this.jsonResponse == null) {
                if (this.fields != null) {
                    JSONArray array = new JSONArray();
                    JSONObject[] arrayObjects = new JSONObject[this.fields.size()];
                    int i = 0;
                    for (Map<String, Object> f : this.fields) {
                        JSONObject fieldJson = new JSONObject();
                        Iterator<String> iterator = f.keySet().iterator();
                        while (iterator.hasNext()) {
                            String field;
                            Object value = f.get(field = iterator.next());
                            fieldJson.put(field, value == null ? JSONObject.NULL : value);
                        }
                        array.put((Object)fieldJson);
                        arrayObjects[i++] = fieldJson;
                    }
                    this.objects = arrayObjects;
                    json.put("objects", (Object)array);
                    this.jsonResponse = json;
                }
            } else {
                json = this.jsonResponse;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                json.put("result", 99).put("error", (Object)ex.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return json;
    }

    @Override
    public ObjectsResponse _fromJSON(JSONObject json) throws JSONException {
        super._fromJSON(json);
        this.jsonResponse = json;
        if (json.has("objects")) {
            JSONArray arr = json.getJSONArray("objects");
            this.objects = new JSONObject[arr.length()];
            this.fields = new LinkedList<Map<String, Object>>();
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject object;
                this.objects[i] = object = this.objects[i];
                HashMap<String, Object> fields = new HashMap<String, Object>();
                Iterator keys = object.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    fields.put(key, object.get(key));
                }
                this.fields.add(fields);
            }
        }
        return this;
    }
}

