/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.data.response;

import com.jelastic.api.Response;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class ObjectResponse
extends Response {
    protected int id = -1;
    protected Map<String, Object> fields = null;
    private JSONObject object = null;

    public ObjectResponse(int id) {
        super(0);
        this.id = id;
    }

    public ObjectResponse(Map<String, Object> fields) {
        super(0);
        this.setFields(fields);
    }

    public ObjectResponse() {
        super(0);
    }

    public ObjectResponse(int result, String error) {
        super(result, error);
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Object> fields) {
        this.fields = fields;
        this.toJSON();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public JSONObject getObject() {
        return this.object;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        try {
            if (this.id > -1) {
                json.put("id", this.id);
            }
            if (this.fields != null) {
                JSONObject fieldJson = new JSONObject();
                Iterator<String> iterator = this.fields.keySet().iterator();
                while (iterator.hasNext()) {
                    String field;
                    Object value = this.fields.get(field = iterator.next());
                    fieldJson.put(field, value == null ? JSONObject.NULL : value);
                }
                this.object = fieldJson;
                json.put("object", (Object)fieldJson);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                json.put("result", 99).put("error", (Object)ex.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return json;
    }

    @Override
    public ObjectResponse _fromJSON(JSONObject json) throws JSONException {
        super._fromJSON(json);
        if (json.has("id")) {
            this.id = json.getInt("id");
        }
        if (json.has("object")) {
            this.object = json.getJSONObject("object");
            Iterator keys = this.object.keys();
            this.fields = new HashMap<String, Object>();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                this.fields.put(key, this.object.get(key));
            }
        }
        return this;
    }
}

