/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.data.po;

import com.jelastic.api.data.po.FilePermissionCreator;
import com.jelastic.api.data.po.MountPointType;
import com.jelastic.api.data.po.SourceAddressType;
import com.jelastic.api.development.response.interfaces.ArrayItem;
import java.io.Serializable;
import org.json.JSONException;
import org.json.JSONObject;

public class MountPoint
extends ArrayItem
implements Serializable {
    public static final String NODE_ID = "nodeId";
    public static final String SOURCE_NODE_ID = "sourceNodeId";
    public static final String SOURCE_HOST = "sourceHost";
    public static final String SOURCE_PATH = "sourcePath";
    public static final String PATH = "path";
    public static final String PROTOCOL = "protocol";
    public static final String NAME = "name";
    public static final String PERMISSION = "permission";
    public static final String CREATOR = "creator";
    public static final String TYPE = "type";
    public static final String READ_ONLY = "readOnly";
    public static final String SOURCE_ADDRESS_TYPE = "sourceAddressType";
    public static final String FILE_READ_ONLY_PERMISSIONS = "r";
    public static final String FILE_RW_PERMISSIONS = "rw";
    private Integer nodeId;
    private Integer sourceNodeId;
    private String sourceHost;
    private String sourcePath;
    private String path;
    private String protocol;
    private String name;
    private Boolean readOnly = false;
    private FilePermissionCreator creator;
    private MountPointType type;
    private SourceAddressType sourceAddressType;

    public MountPoint() {
    }

    public MountPoint(Integer nodeId, Integer sourceNodeId, String sourceHost, String sourcePath, String path, String protocol, String name, Boolean readOnly, FilePermissionCreator creator, MountPointType type, SourceAddressType sourceAddressType) {
        this.nodeId = nodeId;
        this.sourceNodeId = sourceNodeId;
        this.sourceHost = sourceHost;
        this.sourcePath = sourcePath;
        this.path = path;
        this.protocol = protocol;
        this.name = name;
        this.readOnly = readOnly;
        this.creator = creator;
        this.type = type;
        this.sourceAddressType = sourceAddressType;
    }

    public Integer getSourceNodeId() {
        return this.sourceNodeId;
    }

    public void setSourceNodeId(Integer sourceNodeId) {
        this.sourceNodeId = sourceNodeId;
    }

    public String getSourceHost() {
        return this.sourceHost;
    }

    public void setSourceHost(String sourceHost) {
        this.sourceHost = sourceHost;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.nodeId = nodeId;
    }

    public FilePermissionCreator getCreator() {
        return this.creator;
    }

    public void setCreator(FilePermissionCreator creator) {
        this.creator = creator;
    }

    public MountPointType getType() {
        return this.type;
    }

    public void setType(MountPointType type) {
        this.type = type;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getPermission() {
        return this.readOnly != false ? FILE_READ_ONLY_PERMISSIONS : FILE_RW_PERMISSIONS;
    }

    public SourceAddressType getSourceAddressType() {
        return this.sourceAddressType;
    }

    public void setSourceAddressType(SourceAddressType sourceAddressType) {
        this.sourceAddressType = sourceAddressType;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(NODE_ID, (Object)this.nodeId);
        jsonObject.put(SOURCE_NODE_ID, (Object)this.sourceNodeId);
        jsonObject.put(SOURCE_HOST, (Object)this.sourceHost);
        jsonObject.put(SOURCE_PATH, (Object)this.sourcePath);
        jsonObject.put(PATH, (Object)this.path);
        jsonObject.put(PROTOCOL, (Object)this.protocol);
        jsonObject.put(NAME, (Object)this.name);
        jsonObject.put(READ_ONLY, (Object)this.readOnly);
        jsonObject.put(CREATOR, (Object)this.creator);
        jsonObject.put(TYPE, (Object)this.type);
        jsonObject.put(PERMISSION, (Object)this.getPermission());
        jsonObject.put(SOURCE_ADDRESS_TYPE, (Object)this.sourceAddressType);
        return jsonObject;
    }

    @Override
    public MountPoint _fromJSON(JSONObject jsonObject) throws JSONException {
        if (jsonObject.has(NODE_ID)) {
            this.nodeId = jsonObject.getInt(NODE_ID);
        }
        if (jsonObject.has(SOURCE_NODE_ID)) {
            this.sourceNodeId = jsonObject.getInt(SOURCE_NODE_ID);
        }
        if (jsonObject.has(SOURCE_HOST)) {
            this.sourceHost = jsonObject.getString(SOURCE_HOST);
        }
        if (jsonObject.has(SOURCE_PATH)) {
            this.sourcePath = jsonObject.getString(SOURCE_PATH);
        }
        if (jsonObject.has(PATH)) {
            this.path = jsonObject.getString(PATH);
        }
        if (jsonObject.has(PROTOCOL)) {
            this.protocol = jsonObject.getString(PROTOCOL);
        }
        if (jsonObject.has(NAME)) {
            this.name = jsonObject.getString(NAME);
        }
        if (jsonObject.has(READ_ONLY)) {
            this.readOnly = jsonObject.getBoolean(READ_ONLY);
        }
        if (jsonObject.has(CREATOR) && !jsonObject.isNull(CREATOR)) {
            this.creator = FilePermissionCreator.valueOf(jsonObject.getString(CREATOR).toUpperCase());
        }
        if (jsonObject.has(TYPE) && !jsonObject.isNull(TYPE)) {
            this.type = MountPointType.valueOf(jsonObject.getString(TYPE));
        }
        if (jsonObject.has(SOURCE_ADDRESS_TYPE) && !jsonObject.isNull(SOURCE_ADDRESS_TYPE)) {
            this.sourceAddressType = SourceAddressType.valueOf(jsonObject.getString(SOURCE_ADDRESS_TYPE).toUpperCase());
        }
        return this;
    }
}

