/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.data.po;

import com.jelastic.api.core.utils.JSONUtils;
import com.jelastic.api.data.po.DBItem;
import com.jelastic.api.data.po.DockerLink;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DockerMetadata
implements DBItem {
    public static final String DOCKER_VERSION_SEPARATOR = ":";
    public static final String DOCKER_LINKS = "dockerLinks";
    public static final String DOCKER_NAME = "dockerName";
    public static final String DOCKER_HUB_URL = "registryUrl";
    public static final String DOCKER_HUB_USER = "registryUser";
    public static final String DOCKER_HUB_PASSWORD = "registryPassword";
    public static final String DOCKER_TAG = "dockerTag";
    public static final String DOCKER_OS = "dockerOs";
    public static final String DOCKER_MANIFEST = "dockerManifest";
    public static final String DOCKER_VOLUMES = "dockerVolumes";
    public static final String DOCKER_VOLUMES_FROM = "dockerVolumesFrom";
    private JSONObject jsonObject = new JSONObject();

    public DockerMetadata(String data) throws JSONException {
        this._fromString(data);
    }

    public DockerMetadata(JSONObject data) throws JSONException {
        this._fromJSON(data);
    }

    public JSONObject getManifest() {
        return (JSONObject)JSONUtils.getFieldValueFromJson(this.jsonObject, DOCKER_MANIFEST);
    }

    public void setManifest(JSONObject manifest) {
        this.jsonObject.put(DOCKER_MANIFEST, (Object)manifest);
    }

    public String getFullName() {
        return this.getName() + DOCKER_VERSION_SEPARATOR + this.getTag();
    }

    public String getName() {
        return (String)JSONUtils.getFieldValueFromJson(this.jsonObject, DOCKER_NAME);
    }

    public void setName(String name) {
        this.jsonObject.put(DOCKER_NAME, (Object)name);
    }

    public String getHubUrl() {
        return (String)JSONUtils.getFieldValueFromJson(this.jsonObject, DOCKER_HUB_URL);
    }

    public void setHubUrl(String hubUrl) {
        this.jsonObject.put(DOCKER_HUB_URL, (Object)hubUrl);
    }

    public String getTag() {
        return (String)JSONUtils.getFieldValueFromJson(this.jsonObject, DOCKER_TAG);
    }

    public void setTag(String tag) {
        this.jsonObject.put(DOCKER_TAG, (Object)tag);
    }

    public String getOs() {
        return (String)JSONUtils.getFieldValueFromJson(this.jsonObject, DOCKER_OS);
    }

    public void setOs(String os) {
        this.jsonObject.put(DOCKER_OS, (Object)os);
    }

    public String getHubUser() {
        return (String)JSONUtils.getFieldValueFromJson(this.jsonObject, DOCKER_HUB_USER);
    }

    public void setHubUser(String hubUser) {
        this.jsonObject.put(DOCKER_HUB_USER, (Object)hubUser);
    }

    public String getHubPassword() {
        return (String)JSONUtils.getFieldValueFromJson(this.jsonObject, DOCKER_HUB_PASSWORD);
    }

    public void setHubPassword(String hubPassword) {
        this.jsonObject.put(DOCKER_HUB_PASSWORD, (Object)hubPassword);
    }

    public Set<DockerLink> getLinks() {
        HashSet<DockerLink> dockerLinkSet = new HashSet<DockerLink>();
        JSONArray dockerLinkJsonArray = (JSONArray)JSONUtils.getFieldValueFromJson(this.jsonObject, DOCKER_LINKS);
        if (dockerLinkJsonArray == null) {
            return dockerLinkSet;
        }
        for (int i = 0; i < dockerLinkJsonArray.length(); ++i) {
            dockerLinkSet.add(new DockerLink()._fromJSON(dockerLinkJsonArray.getJSONObject(i)));
        }
        return dockerLinkSet;
    }

    public void setLinks(Set<DockerLink> dockerLinks) {
        JSONArray dockerLinkJsonArray = new JSONArray();
        for (DockerLink dockerLink : dockerLinks) {
            dockerLinkJsonArray.put((Object)dockerLink._toJSON());
        }
        this.jsonObject.put(DOCKER_LINKS, (Object)dockerLinkJsonArray);
    }

    public Set<String> getVolumes() {
        HashSet<String> dockerVolumeSet = new HashSet<String>();
        JSONArray dockerVolumeJsonArray = (JSONArray)JSONUtils.getFieldValueFromJson(this.jsonObject, DOCKER_VOLUMES);
        if (dockerVolumeJsonArray == null) {
            return dockerVolumeSet;
        }
        for (int i = 0; i < dockerVolumeJsonArray.length(); ++i) {
            dockerVolumeSet.add(dockerVolumeJsonArray.getString(i));
        }
        return dockerVolumeSet;
    }

    public void setVolumes(Set<String> dockerVolumes) {
        JSONArray dockerVolumeJsonArray = new JSONArray();
        for (String dockerVolume : dockerVolumes) {
            dockerVolumeJsonArray.put((Object)dockerVolume);
        }
        this.jsonObject.put(DOCKER_VOLUMES, (Object)dockerVolumeJsonArray);
    }

    public List<String> getVolumesFrom() throws JSONException {
        ArrayList<String> dockerVolumeSet = new ArrayList<String>();
        JSONArray dockerVolumeJsonArray = (JSONArray)JSONUtils.getFieldValueFromJson(this.jsonObject, DOCKER_VOLUMES_FROM);
        if (dockerVolumeJsonArray == null) {
            return dockerVolumeSet;
        }
        for (int i = 0; i < dockerVolumeJsonArray.length(); ++i) {
            dockerVolumeSet.add(dockerVolumeJsonArray.getString(i));
        }
        return dockerVolumeSet;
    }

    public void setVolumesFrom(List<String> dockerVolumes) throws JSONException {
        JSONArray dockerVolumeJsonArray = new JSONArray();
        for (String dockerVolume : dockerVolumes) {
            dockerVolumeJsonArray.put((Object)dockerVolume);
        }
        this.jsonObject.put(DOCKER_VOLUMES_FROM, (Object)dockerVolumeJsonArray);
    }

    public String getRaw() {
        return this.jsonObject.toString();
    }

    private void _fromString(String stringJson) throws JSONException {
        JSONObject json = new JSONObject(stringJson);
        this._fromJSON(json);
    }

    @Override
    public String toString() {
        return this.jsonObject.toString();
    }

    @Override
    public JSONObject _toJSON() {
        JSONObject jsonObject = new JSONObject(this.jsonObject.toString());
        jsonObject.remove(DOCKER_HUB_USER);
        jsonObject.remove(DOCKER_HUB_PASSWORD);
        return jsonObject;
    }

    @Override
    public DockerMetadata _fromJSON(JSONObject json) throws JSONException {
        this.jsonObject = new JSONObject(json.toString());
        return this;
    }
}

