/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.core.utils;

import com.jelastic.api.Response;
import com.jelastic.api.ResponseInterface;
import com.jelastic.api.core.utils.AfterRequestAction;
import com.jelastic.api.core.utils.BeforeRequestAction;
import com.jelastic.api.core.utils.JSONUtils;
import com.jelastic.api.core.utils.TransportInterface;
import com.jelastic.api.exception.TransportException;
import com.jelastic.api.utils.UserAgent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Transport
implements TransportInterface {
    private static final int BUFFER_LENGTH = 8192;
    private List<BeforeRequestAction> beforeRequestActionsList = new LinkedList<BeforeRequestAction>();
    private List<AfterRequestAction> afterRequestActionsList = new LinkedList<AfterRequestAction>();
    @Deprecated
    private BeforeRequestAction beforeRequestAction = null;

    public Response getResponse(String url) {
        return (Response)this.get(url, null, Response.class);
    }

    public Response postResponse(String url, Map params) {
        return (Response)this.post(url, params, Response.class);
    }

    public String get(String url) throws IOException, TransportException {
        return this.get(url, new HashMap());
    }

    public String get(String url, Map params) throws IOException, TransportException {
        return this.request(url, "GET", params, null);
    }

    public Object get(String url, Class clazz) {
        return this.get(url, null, clazz);
    }

    public Object get(String url, Map params, Class clazz) {
        ResponseInterface respObj = null;
        try {
            respObj = (ResponseInterface)clazz.newInstance();
            String response = this.get(url, params);
            respObj.fromString(response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (respObj == null) {
                respObj = new Response();
            }
            respObj.setError(ex.getMessage());
            respObj.setResult(17);
            respObj.setSource("transport");
        }
        return respObj;
    }

    public Object request(String url, Map params, Map headers, Class clazz) {
        ResponseInterface respObj = null;
        try {
            respObj = (ResponseInterface)clazz.newInstance();
            String response = this.request(url, "POST", params, headers);
            respObj.fromString(response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (respObj == null) {
                respObj = new Response();
            }
            respObj.setError(ex.getMessage());
            respObj.setResult(17);
            respObj.setSource("transport");
        }
        return respObj;
    }

    public String post(String url, Map params) throws IOException, TransportException {
        return this.request(url, "POST", params, null);
    }

    public Object post(String url, Map params, Class clazz) {
        ResponseInterface respObj = null;
        try {
            respObj = (ResponseInterface)clazz.newInstance();
            String response = this.post(url, params);
            respObj.fromString(response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (respObj == null) {
                respObj = new Response();
            }
            respObj.setError(ex.getMessage());
            respObj.setResult(17);
            respObj.setSource("transport");
        }
        return respObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String request(String url, String method, Map params, Map headers) throws IOException, TransportException {
        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream in = null;
        ByteArrayOutputStream baos = null;
        try {
            String encodedParams = null;
            if (params != null && params.size() > 0) {
                encodedParams = this.getEncodedParams(params);
            }
            if (method == null) {
                method = encodedParams == null || encodedParams.length() < 2000 ? "GET" : "POST";
            }
            String string = method = method != null && method.equalsIgnoreCase("POST") ? "POST" : "GET";
            if (url.contains("signin")) {
                method = "POST";
            }
            if (method.equalsIgnoreCase("GET")) {
                if (encodedParams != null) {
                    url = url + (url.indexOf("?") == -1 ? "?" : "&") + encodedParams;
                    encodedParams = null;
                }
                url = url + (url.indexOf("?") == -1 ? "?" : "&") + "_rnd=" + Math.round(Math.random() * 1.0E7);
            }
            URL urlObj = new URL(url);
            conn = (HttpURLConnection)urlObj.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod(method);
            conn.setRequestProperty("User-Agent", UserAgent.getUserAgent("1.3.1"));
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            if (headers != null) {
                for (Object key : headers.keySet()) {
                    Object value;
                    if (key == null || (value = headers.get(key)) == null) continue;
                    conn.setRequestProperty(key.toString(), value.toString());
                }
            }
            if (this.beforeRequestAction != null) {
                this.beforeRequestAction.fire(conn);
            }
            for (BeforeRequestAction action : this.beforeRequestActionsList) {
                action.fire(conn);
            }
            if (encodedParams != null) {
                byte[] bytes = encodedParams.getBytes("UTF-8");
                String lengthStr = bytes.length + "";
                conn.setRequestProperty("Content-Length", lengthStr);
                out = conn.getOutputStream();
                out.write(bytes);
                out.flush();
            }
            try {
                in = conn.getInputStream();
            }
            catch (IOException e) {
                if (conn.getResponseCode() == 503) {
                    throw new TransportException("503 Service Unavailable for url :[" + url + "]");
                }
                if (conn.getResponseCode() == 429) {
                    throw new TransportException("429 Too Many Requests for url :[" + url + "]");
                }
                in = conn.getErrorStream();
            }
            baos = new ByteArrayOutputStream();
            int n = 0;
            byte[] buff = new byte[8192];
            while ((n = in.read(buff)) > -1) {
                baos.write(buff, 0, n);
            }
            baos.flush();
            String response = new String(baos.toByteArray(), "UTF-8");
            for (AfterRequestAction action : this.afterRequestActionsList) {
                action.fire(conn, response);
            }
            String string2 = response;
            return string2;
        }
        finally {
            try {
                baos.close();
            }
            catch (Exception exception) {}
            try {
                out.close();
            }
            catch (Exception exception) {}
            try {
                in.close();
            }
            catch (Exception exception) {}
            try {
                conn.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public String getEncodedParams(Map params) throws IOException {
        String str = "";
        for (Object name : params.keySet()) {
            Object value = params.get(name);
            if (value == null || name == null) continue;
            if (value instanceof Map) {
                value = JSONUtils.jsonStringify(value);
            }
            str = str + "&" + URLEncoder.encode(name.toString(), "UTF-8") + "=" + URLEncoder.encode(value.toString(), "UTF-8");
        }
        if (str.length() > 1) {
            str = str.substring(1);
        }
        return str;
    }

    @Override
    public void addBeforeRequestAction(BeforeRequestAction action) {
        this.beforeRequestActionsList.add(action);
    }

    @Override
    public void removeBeforeRequestAction(BeforeRequestAction action) {
        this.beforeRequestActionsList.remove(action);
    }

    @Override
    public void addAfterRequestAction(AfterRequestAction action) {
        this.afterRequestActionsList.add(action);
    }

    @Override
    public void removeAfterRequestAction(AfterRequestAction action) {
        this.afterRequestActionsList.remove(action);
    }

    @Override
    @Deprecated
    public void setBeforeRequestAction(BeforeRequestAction beforeRequestAction) {
        this.beforeRequestAction = beforeRequestAction;
    }
}

