/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.core.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtils {
    public static final Object toJSON(Object obj) {
        if (obj == null) {
            return null;
        }
        Object respone = null;
        try {
            if (JSONUtils.isSimpleType(obj) || obj instanceof JSONObject || obj instanceof JSONArray) {
                respone = obj;
            } else if (obj instanceof Map) {
                respone = new JSONObject((Map)obj);
            } else if (obj instanceof String) {
                String str = ((String)obj).trim();
                respone = str.startsWith("[") && str.endsWith("]") ? new JSONArray(str) : (str.startsWith("{") && str.endsWith("}") ? new JSONObject(str) : obj);
            } else if (obj instanceof Collection) {
                respone = new JSONArray((Collection)obj);
            } else if (obj.getClass().isArray()) {
                Object[] arr = (Object[])obj;
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < arr.length; ++i) {
                    jsonArray.put(JSONUtils.toJSON(arr[i]));
                }
                respone = jsonArray;
            } else {
                respone = obj;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            respone = ex.toString();
        }
        return respone;
    }

    public static final String jsonStringify(Object obj) {
        if (obj instanceof String) {
            return (String)obj;
        }
        return JSONUtils.toJSON(obj).toString();
    }

    public static final Map mapify(Object obj) {
        if (obj != null && obj instanceof Map) {
            return (Map)obj;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (obj != null) {
            Object toJson = JSONUtils.toJSON(obj);
            if (toJson instanceof String && !(obj instanceof String)) {
                toJson = JSONUtils.toJSON(toJson);
            }
            if (toJson instanceof JSONObject) {
                JSONObject json = (JSONObject)toJson;
                Iterator keys = json.keys();
                try {
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        map.put(key, json.get(key));
                    }
                }
                catch (JSONException ex) {
                    throw new RuntimeException(ex.toString());
                }
            } else {
                throw new RuntimeException("error mapify object [" + obj.getClass() + " -> " + obj + "]");
            }
        }
        return map;
    }

    public static final boolean isSimpleType(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        return clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || clazz == Boolean.class || clazz == Byte.class || clazz == Character.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class;
    }

    public static Object getFieldValueFromJson(JSONObject jsonObject, String fieldName) {
        if (jsonObject == null) {
            return null;
        }
        if (jsonObject.has(fieldName) && !jsonObject.isNull(fieldName)) {
            try {
                return jsonObject.get(fieldName);
            }
            catch (JSONException e) {
                return null;
            }
        }
        return null;
    }

    public static JSONObject mergeJsonObjects(JSONObject ... jsonObject) {
        JSONObject mergedJsonObject = new JSONObject();
        return JSONUtils.mergeIntoJsonObject(mergedJsonObject, jsonObject);
    }

    public static JSONObject mergeIntoJsonObject(JSONObject baseObject, JSONObject ... jsonObject) {
        for (JSONObject item : jsonObject) {
            Iterator iterator = item.keys();
            while (iterator.hasNext()) {
                String fieldName = iterator.next().toString();
                try {
                    baseObject.put(fieldName, item.get(fieldName));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return baseObject;
    }
}

