/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.core.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    public static final SimpleDateFormat SQL_DATE = new SimpleDateFormat("yyyy-MM-dd");
    public static final SimpleDateFormat SQL_DATETIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final SimpleDateFormat SQL_TIME = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat SQL_YEAR = new SimpleDateFormat("yyyy");
    public static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final int ONE_HOUR_SEC = 3600;
    public static final int ONE_HOUR_MSEC = 3600000;
    public static final long ONE_HOUR_NANOSEC = 3600000000000L;
    public static final int ONE_HOUR_MIN = 60;
    public static final int HALF_HOUR_SEC = 1800;
    public static final int ONE_DAY_SEC = 86400;
    public static final int ONE_DAY_MSEC = 86400000;
    public static final int ONE_DAY_MIN = 1440;
    private static final int MIN_VALID_YEAR = 1969;

    public static final synchronized Date parseSqlDate(String date) throws ParseException {
        return SQL_DATE.parse(date);
    }

    public static final synchronized String formatSqlDate(Date date) {
        return SQL_DATE.format(date);
    }

    public static final synchronized Date parseSqlDateTime(String date) throws ParseException {
        Date parsedDate = SQL_DATETIME.parse(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(parsedDate);
        if (calendar.get(1) < 1969) {
            throw new ParseException("Illegal year. Please use year greater than 1969.", -1);
        }
        return parsedDate;
    }

    public static final synchronized String formatSqlDateTime(Date date) {
        return SQL_DATETIME.format(date);
    }

    public static final synchronized Date parseSqlTime(String date) throws ParseException {
        return SQL_TIME.parse(date);
    }

    public static final synchronized String formatSqlTime(Date date) {
        return SQL_TIME.format(date);
    }

    public static final synchronized Date parseSqlYear(String date) throws ParseException {
        return SQL_YEAR.parse(date);
    }

    public static final synchronized String formatSqlYear(Date date) {
        return SQL_YEAR.format(date);
    }

    public static final synchronized int getDays(Date end, Date start) {
        return (int)((end.getTime() - start.getTime()) / 86400000L);
    }

    public static final synchronized int getSeconds(Date end, Date start) {
        return (int)((end.getTime() - start.getTime()) / 1000L);
    }

    public static final synchronized int getMinutes(Date end, Date start) {
        return DateUtils.getSeconds(end, start) / 60;
    }

    public static final synchronized Date getDiffHours(Date date, int diff) {
        return new Date(date.getTime() - (long)(diff * 3600000));
    }

    public static final synchronized Date getDiffSeconds(Date date, int diff) {
        return new Date(date.getTime() - (long)(diff * 1000));
    }

    public static final String getCopyrightYears() {
        return "2008-" + Calendar.getInstance().get(1);
    }

    static {
        SQL_DATE.setTimeZone(GMT_TIME_ZONE);
        SQL_DATETIME.setTimeZone(GMT_TIME_ZONE);
        SQL_TIME.setTimeZone(GMT_TIME_ZONE);
        SQL_YEAR.setTimeZone(GMT_TIME_ZONE);
    }
}

