/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.billing.response.interfaces;

import com.jelastic.api.core.utils.DateUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class ArrayItem {
    protected int id;

    public JSONObject _toJSON() throws JSONException {
        JSONObject json = new JSONObject();
        this.primaryKeyToJson(json);
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(this);
                if (value == null) continue;
                if (ArrayItem.class.isAssignableFrom(field.getType())) {
                    json.put(field.getName(), (Object)((ArrayItem)value)._toJSON());
                    continue;
                }
                if (value instanceof Double) {
                    json.put(field.getName(), ((Double)value).doubleValue());
                    continue;
                }
                json.put(field.getName(), value);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
        return json;
    }

    public ArrayItem _fromString(String stringJson) throws JSONException {
        JSONObject json = new JSONObject(stringJson);
        return this._fromJSON(json);
    }

    public ArrayItem _fromJSON(JSONObject json) throws JSONException {
        this.primaryKeyFromJson(json);
        for (Field field : this.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!json.has(field.getName())) continue;
            try {
                if (ArrayItem.class.isAssignableFrom(field.getType())) {
                    field.set(this, ((ArrayItem)Class.forName(field.getType().getCanonicalName()).newInstance())._fromJSON(json.getJSONObject(field.getName())));
                    continue;
                }
                field.set(this, this.getFromJson(field, json));
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this;
    }

    private Object getFromJson(Field field, JSONObject jsonObject) throws JSONException {
        if (field.getType().equals(String.class)) {
            return jsonObject.getString(field.getName());
        }
        if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE)) {
            return jsonObject.getInt(field.getName());
        }
        if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
            return jsonObject.getLong(field.getName());
        }
        if (field.getType().equals(Double.class) || field.getType().equals(Double.TYPE)) {
            return jsonObject.getDouble(field.getName());
        }
        if (field.getType().equals(Date.class)) {
            try {
                return DateUtils.parseSqlDateTime(jsonObject.getString(field.getName()));
            }
            catch (ParseException ex) {
                throw new JSONException("JSONObject['" + field.getName() + "'] is not a Date.");
            }
        }
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            String stringBoolean = jsonObject.getString(field.getName());
            if (stringBoolean.equalsIgnoreCase(Boolean.TRUE.toString()) || stringBoolean.equals("1")) {
                return Boolean.TRUE;
            }
            if (stringBoolean.equalsIgnoreCase(Boolean.FALSE.toString()) || stringBoolean.equals("0")) {
                return Boolean.FALSE;
            }
            throw new JSONException("JSONObject['" + field.getName() + "'] is not a Boolean.");
        }
        return jsonObject.get(field.getName());
    }

    protected void primaryKeyToJson(JSONObject json) throws JSONException {
        try {
            Method getIdMethod = this.getClass().getMethod("getId", null);
            int id = (Integer)getIdMethod.invoke((Object)this, new Object[0]);
            json.put("id", id);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    protected void primaryKeyFromJson(JSONObject json) throws JSONException {
        if (json.has("id")) {
            try {
                Method getIdMethod = this.getClass().getMethod("setId", Integer.TYPE);
                getIdMethod.invoke((Object)this, json.getInt("id"));
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }
}

