/*
 * Decompiled with CFR 0.152.
 */
package com.jelastic.api.billing.response;

import com.jelastic.api.Response;
import com.jelastic.api.core.utils.DateUtils;
import com.jelastic.api.system.persistence.AccountStatus;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccountResponse
extends Response
implements Serializable {
    public static final String UID = "uid";
    public static final String BALANCE = "balance";
    public static final String CREDIT = "credit";
    public static final String DEBIT = "debit";
    public static final String STATUS = "status";
    public static final String GROUP = "group";
    public static final String BONUS = "bonus";
    public static final String EMAIL = "email";
    public static final String CREATED_ON = "createdOn";
    public static final String UPDATED_GROUP_ON = "updatedGroupOn";
    public static final String UPDATED_STATUS_ON = "updatedStatusOn";
    public static final String GROUP_WIN_DOMAIN = "groupWinDomain";
    public static final String IS_COMMERIAL = "isCommerial";
    public static final String IS_ENABLED = "isEnabled";
    public static final String GROUP_TYPE = "groupType";
    public static final String IS_REGISTERED = "isRegistered";
    public static final String HARD_NODE_GROUPS = "hardNodeGroups";
    public static final String DEFAULT_HN_GROUP = "defaultHardNodeGroup";
    private Integer uid;
    private BigDecimal balance;
    private BigDecimal credit;
    private BigDecimal debit;
    private AccountStatus status;
    private Date createdOn;
    private Date updatedGroupOn;
    private Date updatedStatusOn;
    private String group;
    private BigDecimal bonus;
    private String email;
    private Boolean isEnabled;
    private Boolean isCommerial;
    private String groupType;
    private Boolean isRegistered;
    private Integer groupWinDomain;
    private Set<String> hardNodeGroups = new HashSet<String>();
    private String defaultHardNodeGroup;

    public AccountResponse() {
        super(0);
    }

    public AccountResponse(Integer uid) {
        this();
        this.uid = uid;
    }

    public AccountResponse(int result, String error) {
        super(result, error);
    }

    public AccountResponse(int result, String error, int uid) {
        super(result, error);
        this.uid = uid;
    }

    public AccountResponse(Integer uid, BigDecimal balance, BigDecimal debit) {
        this();
        this.uid = uid;
        this.balance = balance;
        this.debit = debit;
    }

    public Boolean isCommerial() {
        return this.isCommerial;
    }

    public void setCommerial(Boolean commerial) {
        this.isCommerial = commerial;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getUpdatedGroupOn() {
        return this.updatedGroupOn;
    }

    public void setUpdatedGroupOn(Date updatedGroupOn) {
        this.updatedGroupOn = updatedGroupOn;
    }

    public BigDecimal getBalance() {
        return this.balance;
    }

    public void setBalance(BigDecimal balance) {
        this.balance = balance;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public Integer getUid() {
        return this.uid;
    }

    public void setUid(Integer uid) {
        this.uid = uid;
    }

    public BigDecimal getDebit() {
        return this.debit;
    }

    public void setDebit(BigDecimal debit) {
        this.debit = debit;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public BigDecimal getBonus() {
        return this.bonus;
    }

    public void setBonus(BigDecimal bonus) {
        this.bonus = bonus;
    }

    public BigDecimal getCredit() {
        return this.credit;
    }

    public void setCredit(BigDecimal credit) {
        this.credit = credit;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean getEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(Boolean enabled) {
        this.isEnabled = enabled;
    }

    public String getGroupType() {
        return this.groupType;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public Boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(Boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public Set<String> getHardNodeGroups() {
        return this.hardNodeGroups;
    }

    public void setHardNodeGroups(Set<String> hardNodeGroups) {
        this.hardNodeGroups = hardNodeGroups;
    }

    public Date getUpdatedStatusOn() {
        return this.updatedStatusOn;
    }

    public void setUpdatedStatusOn(Date updatedStatusOn) {
        this.updatedStatusOn = updatedStatusOn;
    }

    public String getDefaultHardNodeGroup() {
        return this.defaultHardNodeGroup;
    }

    public void setDefaultHardNodeGroup(String defaultHardNodeGroup) {
        this.defaultHardNodeGroup = defaultHardNodeGroup;
    }

    public Integer getGroupWinDomain() {
        return this.groupWinDomain;
    }

    public void setGroupWinDomain(Integer groupWinDomain) {
        this.groupWinDomain = groupWinDomain;
    }

    @Override
    public JSONObject _toJSON() throws JSONException {
        JSONObject json = super._toJSON();
        json.put(UID, (Object)this.uid);
        json.put(BALANCE, (Object)this.balance);
        json.put(CREDIT, (Object)this.credit);
        json.put(DEBIT, (Object)this.debit);
        json.put(IS_COMMERIAL, (Object)this.isCommerial);
        json.put(IS_REGISTERED, (Object)this.isRegistered);
        if (this.status != null) {
            json.put(STATUS, this.status.getValue());
        }
        if (this.createdOn != null) {
            json.put(CREATED_ON, (Object)DateUtils.formatSqlDateTime(this.createdOn));
        }
        if (this.updatedGroupOn != null) {
            json.put(UPDATED_GROUP_ON, (Object)DateUtils.formatSqlDateTime(this.updatedGroupOn));
        }
        if (this.updatedStatusOn != null) {
            json.put(UPDATED_STATUS_ON, (Object)DateUtils.formatSqlDateTime(this.updatedStatusOn));
        }
        json.put(GROUP, (Object)this.group);
        if (this.groupWinDomain != null) {
            json.put(GROUP_WIN_DOMAIN, (Object)this.groupWinDomain);
        }
        json.put(BONUS, (Object)this.bonus);
        json.put(EMAIL, (Object)this.email);
        if (this.isEnabled != null) {
            json.put(IS_ENABLED, this.isEnabled != false ? 1 : 0);
        }
        json.put(GROUP_TYPE, (Object)this.groupType);
        json.put(HARD_NODE_GROUPS, (Object)new JSONArray(this.hardNodeGroups));
        json.put(DEFAULT_HN_GROUP, (Object)this.defaultHardNodeGroup);
        return json;
    }

    @Override
    public AccountResponse _fromJSON(JSONObject json) throws JSONException {
        super._fromJSON(json);
        if (json.has(UID)) {
            this.uid = json.getInt(UID);
        }
        if (json.has(IS_COMMERIAL)) {
            this.isCommerial = json.getBoolean(IS_COMMERIAL);
        }
        if (json.has(IS_REGISTERED)) {
            this.isRegistered = json.getBoolean(IS_REGISTERED);
        }
        if (json.has(BALANCE)) {
            this.balance = BigDecimal.valueOf(json.getDouble(BALANCE));
        }
        if (json.has(CREDIT)) {
            this.credit = BigDecimal.valueOf(json.getDouble(CREDIT));
        }
        if (json.has(DEBIT)) {
            this.debit = BigDecimal.valueOf(json.getDouble(DEBIT));
        }
        if (json.has(STATUS)) {
            this.status = AccountStatus.parse(json.getInt(STATUS));
        }
        if (json.has(CREATED_ON)) {
            try {
                this.createdOn = DateUtils.parseSqlDateTime(json.getString(CREATED_ON));
            }
            catch (ParseException ex) {
                throw new JSONException((Throwable)ex);
            }
        }
        if (json.has(UPDATED_GROUP_ON)) {
            try {
                this.updatedGroupOn = DateUtils.parseSqlDateTime(json.getString(UPDATED_GROUP_ON));
            }
            catch (ParseException ex) {
                throw new JSONException((Throwable)ex);
            }
        }
        if (json.has(UPDATED_STATUS_ON)) {
            try {
                this.updatedStatusOn = DateUtils.parseSqlDateTime(json.getString(UPDATED_STATUS_ON));
            }
            catch (ParseException ex) {
                throw new JSONException((Throwable)ex);
            }
        }
        if (json.has(GROUP)) {
            this.group = json.getString(GROUP);
        }
        if (json.has(GROUP_WIN_DOMAIN)) {
            this.groupWinDomain = json.getInt(GROUP_WIN_DOMAIN);
        }
        if (json.has(BONUS)) {
            this.bonus = BigDecimal.valueOf(json.getDouble(BONUS));
        }
        if (json.has(EMAIL)) {
            this.email = json.getString(EMAIL);
        }
        if (json.has(IS_ENABLED)) {
            this.isEnabled = json.getInt(IS_ENABLED) == 1;
        }
        if (json.has(GROUP_TYPE)) {
            this.groupType = json.getString(GROUP_TYPE);
        }
        if (json.has(HARD_NODE_GROUPS)) {
            this.hardNodeGroups = new HashSet<String>();
            JSONArray jsonArray = json.getJSONArray(HARD_NODE_GROUPS);
            for (int i = 0; i < jsonArray.length(); ++i) {
                this.hardNodeGroups.add(jsonArray.getString(i));
            }
        }
        if (json.has(DEFAULT_HN_GROUP)) {
            this.defaultHardNodeGroup = json.getString(DEFAULT_HN_GROUP);
        }
        return this;
    }
}

