/*
 * Decompiled with CFR 0.152.
 */
package com.jeequan.jeepay.net;

import com.jeequan.jeepay.util.CaseInsensitiveMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class HttpHeaders {
    private CaseInsensitiveMap<List<String>> headerMap;

    private HttpHeaders(CaseInsensitiveMap<List<String>> headerMap) {
        this.headerMap = headerMap;
    }

    public static HttpHeaders of(Map<String, List<String>> headerMap) {
        Objects.requireNonNull(headerMap);
        return new HttpHeaders(CaseInsensitiveMap.of(headerMap));
    }

    public HttpHeaders withAdditionalHeader(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        return this.withAdditionalHeader(name, Arrays.asList(value));
    }

    public HttpHeaders withAdditionalHeader(String name, List<String> values) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(values);
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        headerMap.put(name, values);
        return this.withAdditionalHeaders(headerMap);
    }

    public HttpHeaders withAdditionalHeaders(Map<String, List<String>> headerMap) {
        Objects.requireNonNull(headerMap);
        HashMap<String, List<String>> newHeaderMap = new HashMap<String, List<String>>(this.map());
        newHeaderMap.putAll(headerMap);
        return HttpHeaders.of(newHeaderMap);
    }

    public List<String> allValues(String name) {
        List<String> values;
        if (this.headerMap.containsKey(name) && (values = this.headerMap.get(name)) != null && values.size() > 0) {
            return Collections.unmodifiableList(values);
        }
        return Collections.emptyList();
    }

    public Optional<String> firstValue(String name) {
        List<String> values;
        if (this.headerMap.containsKey(name) && (values = this.headerMap.get(name)) != null && values.size() > 0) {
            return Optional.of(values.get(0));
        }
        return Optional.empty();
    }

    public Map<String, List<String>> map() {
        return Collections.unmodifiableMap(this.headerMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(" { ");
        sb.append(this.map());
        sb.append(" }");
        return sb.toString();
    }
}

