/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.xml;

import com.jcabi.log.Logger;
import com.jcabi.xml.TextResource;
import com.jcabi.xml.XML;
import com.jcabi.xml.XMLDocument;
import com.jcabi.xml.XSD;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XSDDocument
implements XSD {
    private final transient String xsd;

    public XSDDocument(XML src) {
        this(src.toString());
    }

    public XSDDocument(String src) {
        this.xsd = src;
    }

    public XSDDocument(URL url) throws IOException {
        this(new TextResource(url).toString());
    }

    public XSDDocument(Path file) throws FileNotFoundException {
        this(file.toFile());
    }

    public XSDDocument(File file) throws FileNotFoundException {
        this(new TextResource(file).toString());
    }

    public XSDDocument(URI uri) throws IOException {
        this(new TextResource(uri).toString());
    }

    public XSDDocument(InputStream stream) {
        this(new TextResource(stream).toString());
    }

    public static XSD make(InputStream stream) {
        return new XSDDocument(stream);
    }

    public static XSD make(URL url) {
        try {
            return new XSDDocument(url);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        return new XMLDocument(this.xsd).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<SAXParseException> validate(Source xml) {
        Schema schema;
        try {
            Class<XSDDocument> clazz = XSDDocument.class;
            synchronized (XSDDocument.class) {
                schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(new StringReader(this.xsd)));
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        }
        catch (SAXException ex) {
            throw new IllegalStateException(String.format("failed to create XSD schema from %s", this.xsd), ex);
        }
        {
            CopyOnWriteArrayList<SAXParseException> errors = new CopyOnWriteArrayList<SAXParseException>();
            Validator validator = schema.newValidator();
            validator.setErrorHandler(new ValidationHandler(errors));
            try {
                Class<XSDDocument> clazz = XSDDocument.class;
                synchronized (XSDDocument.class) {
                    validator.validate(xml);
                    // ** MonitorExit[var5_7] (shouldn't be in output)
                }
            }
            catch (IOException | SAXException ex) {
                throw new IllegalStateException(ex);
            }
            {
                if (Logger.isDebugEnabled((Object)this)) {
                    Logger.debug((Object)this, (String)"%s detected %d error(s)", (Object[])new Object[]{schema.getClass().getName(), errors.size()});
                }
                return errors;
            }
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XSDDocument)) {
            return false;
        }
        XSDDocument other = (XSDDocument)o;
        String this$xsd = this.xsd;
        String other$xsd = other.xsd;
        return !(this$xsd == null ? other$xsd != null : !this$xsd.equals(other$xsd));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $xsd = this.xsd;
        result = result * 59 + ($xsd == null ? 43 : $xsd.hashCode());
        return result;
    }

    static final class ValidationHandler
    implements ErrorHandler {
        private final transient Collection<SAXParseException> errors;

        ValidationHandler(Collection<SAXParseException> errs) {
            this.errors = errs;
        }

        @Override
        public void warning(SAXParseException error) {
            this.errors.add(error);
        }

        @Override
        public void error(SAXParseException error) {
            this.errors.add(error);
        }

        @Override
        public void fatalError(SAXParseException error) {
            this.errors.add(error);
        }
    }
}

