/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.aspects.RetryOnFailure;
import com.jcabi.ssh.EasyRepo;
import com.jcabi.ssh.JschLogger;
import com.jcabi.ssh.Shell;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Validate;

public final class SSH
implements Shell {
    public static final int PORT = 22;
    private final transient String addr;
    private final transient int port;
    private final transient String login;
    private final transient String key;

    public SSH(String adr, String user, URL priv) throws IOException {
        this(adr, 22, user, priv);
    }

    public SSH(InetAddress adr, String user, URL priv) throws IOException {
        this(adr, 22, user, priv);
    }

    public SSH(String adr, String user, String priv) throws UnknownHostException {
        this(adr, 22, user, priv);
    }

    public SSH(InetAddress adr, String user, String priv) throws UnknownHostException {
        this(adr.getCanonicalHostName(), 22, user, priv);
    }

    public SSH(String adr, int prt, String user, URL priv) throws IOException {
        this(adr, prt, user, IOUtils.toString((URL)priv));
    }

    public SSH(InetAddress adr, int prt, String user, URL priv) throws IOException {
        this(adr.getCanonicalHostName(), prt, user, IOUtils.toString((URL)priv));
    }

    public SSH(String adr, int prt, String user, String priv) throws UnknownHostException {
        this.addr = InetAddress.getByName(adr).getHostAddress();
        Validate.matchesPattern((CharSequence)this.addr, (String)"\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}", (String)"Invalid IP address of the server `%s`", (Object[])new Object[]{this.addr});
        this.login = user;
        Validate.notEmpty((CharSequence)this.login, (String)"user name can't be empty", (Object[])new Object[0]);
        this.key = priv;
        this.port = prt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exec(String command, InputStream stdin, OutputStream stdout, OutputStream stderr) throws IOException {
        int n;
        Session session = this.session();
        try {
            ChannelExec channel = (ChannelExec)ChannelExec.class.cast(session.openChannel("exec"));
            channel.setErrStream(stderr, false);
            channel.setOutputStream(stdout, false);
            channel.setInputStream(stdin, false);
            channel.setCommand(command);
            channel.connect();
            com.jcabi.log.Logger.info((Object)this, (String)"$ %s", (Object[])new Object[]{command});
            n = this.exec(channel, session);
        }
        catch (Throwable throwable) {
            try {
                session.disconnect();
                throw throwable;
            }
            catch (JSchException ex) {
                throw new IOException(ex);
            }
        }
        session.disconnect();
        return n;
    }

    public static String escape(String arg) {
        return String.format("'%s'", arg.replace("'", "'\\''"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int exec(ChannelExec channel, Session session) throws IOException {
        try {
            int n = this.code(channel, session);
            return n;
        }
        finally {
            channel.disconnect();
        }
    }

    private int code(ChannelExec exec, Session session) throws IOException {
        while (!exec.isClosed()) {
            try {
                session.sendKeepAliveMsg();
            }
            catch (Exception ex) {
                throw new IOException(ex);
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IOException(ex);
            }
        }
        return exec.getExitStatus();
    }

    @RetryOnFailure(attempts=7, delay=1L, unit=TimeUnit.MINUTES, verbose=false, randomize=true, types={IOException.class})
    private Session session() throws IOException {
        try {
            JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
            JSch.setLogger((Logger)new JschLogger());
            JSch jsch = new JSch();
            File file = File.createTempFile("jcabi-ssh", ".key");
            FileUtils.forceDeleteOnExit((File)file);
            FileUtils.write((File)file, (CharSequence)this.key.replaceAll("\r", "").replaceAll("\n\\s+|\n{2,}", "\n").trim(), (String)"UTF-8");
            jsch.setHostKeyRepository((HostKeyRepository)new EasyRepo());
            jsch.addIdentity(file.getAbsolutePath());
            com.jcabi.log.Logger.debug((Object)this, (String)"Opening SSH session to %s@%s:%s (%d bytes in RSA key)...", (Object[])new Object[]{this.login, this.addr, this.port, file.length()});
            Session session = jsch.getSession(this.login, this.addr, this.port);
            session.setServerAliveInterval((int)TimeUnit.SECONDS.toMillis(10L));
            session.setServerAliveCountMax(1000000);
            session.connect();
            FileUtils.deleteQuietly((File)file);
            return session;
        }
        catch (JSchException ex) {
            throw new IOException(ex);
        }
    }

    public String toString() {
        return "SSH(addr=" + this.addr + ", port=" + this.port + ", login=" + this.login + ", key=" + this.key + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SSH)) {
            return false;
        }
        SSH other = (SSH)o;
        String this$addr = this.addr;
        String other$addr = other.addr;
        if (this$addr == null ? other$addr != null : !this$addr.equals(other$addr)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        String this$login = this.login;
        String other$login = other.login;
        if (this$login == null ? other$login != null : !this$login.equals(other$login)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $addr = this.addr;
        result = result * 59 + ($addr == null ? 0 : $addr.hashCode());
        result = result * 59 + this.port;
        String $login = this.login;
        result = result * 59 + ($login == null ? 0 : $login.hashCode());
        String $key = this.key;
        result = result * 59 + ($key == null ? 0 : $key.hashCode());
        return result;
    }
}

