/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.log.VerboseProcess;
import com.jcabi.ssh.SSH;
import com.jcabi.ssh.Shell;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;

public final class SSHD
implements Closeable {
    private final transient File dir;
    private final transient Process process;
    private final transient int prt;

    public SSHD(File path) throws IOException {
        this.dir = path;
        File rsa = new File(this.dir, "host_rsa_key");
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("ssh_host_rsa_key"), (OutputStream)new FileOutputStream(rsa));
        File keys = new File(this.dir, "authorized");
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("authorized_keys"), (OutputStream)new FileOutputStream(keys));
        new VerboseProcess(new ProcessBuilder(new String[0]).command("chmod", "600", keys.getAbsolutePath(), rsa.getAbsolutePath())).stdout();
        this.prt = SSHD.reserve();
        this.process = new ProcessBuilder(new String[0]).command("/usr/sbin/sshd", "-p", Integer.toString(this.prt), "-h", rsa.getAbsolutePath(), "-D", "-e", "-o", String.format("PidFile=%s", new File(this.dir, "pid")), "-o", "UsePAM=no", "-o", String.format("AuthorizedKeysFile=%s", keys), "-o", "StrictModes=no").start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                new VerboseProcess(SSHD.this.process).stdout();
            }
        }).start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                SSHD.this.close();
            }
        }));
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void close() {
        this.process.destroy();
    }

    public File home() {
        return this.dir;
    }

    public String login() {
        return new VerboseProcess(new ProcessBuilder(new String[0]).command("id", "-n", "-u")).stdout().trim();
    }

    public String host() {
        return new VerboseProcess(new ProcessBuilder(new String[0]).command("hostname")).stdout().trim();
    }

    public int port() {
        return this.prt;
    }

    public String key() throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream("id_rsa"), (String)"UTF-8");
    }

    public Shell connect() throws IOException {
        return new SSH(this.host(), this.port(), this.login(), this.key());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int reserve() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        try {
            int n = socket.getLocalPort();
            return n;
        }
        finally {
            socket.close();
        }
    }
}

