/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.ssh;

import com.jcabi.log.VerboseProcess;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import org.apache.commons.io.IOUtils;

public final class SSHD {
    private final transient File dir;

    public SSHD(File path) {
        this.dir = path;
    }

    public File home() {
        return this.dir;
    }

    public String login() {
        return new VerboseProcess(new ProcessBuilder(new String[0]).command("id", "-n", "-u")).stdout().trim();
    }

    public String key() throws IOException {
        return IOUtils.toString((InputStream)this.getClass().getResourceAsStream("id_rsa"), (String)"UTF-8");
    }

    public int start() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        File rsa = new File(this.dir, "host_rsa_key");
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("ssh_host_rsa_key"), (OutputStream)new FileOutputStream(rsa));
        File keys = new File(this.dir, "authorized");
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream("authorized_keys"), (OutputStream)new FileOutputStream(keys));
        new VerboseProcess(new ProcessBuilder(new String[0]).command("chmod", "600", keys.getAbsolutePath(), rsa.getAbsolutePath())).stdout();
        final Process proc = new ProcessBuilder(new String[0]).command("/usr/sbin/sshd", "-p", Integer.toString(port), "-h", rsa.getAbsolutePath(), "-D", "-e", "-o", String.format("PidFile=%s", new File(this.dir, "pid")), "-o", "UsePAM=no", "-o", String.format("AuthorizedKeysFile=%s", keys), "-o", "StrictModes=no").start();
        new Thread(new Runnable(){

            @Override
            public void run() {
                new VerboseProcess(proc).stdout();
            }
        }).start();
        return port;
    }
}

