/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.immutable;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

@Immutable
@Loggable(value=1)
public final class ArraySet<T>
implements Set<T> {
    private final transient T[] values;

    public ArraySet() {
        this.values = new Object[0];
    }

    public ArraySet(Iterable<T> set) {
        if (set == null) {
            throw new IllegalArgumentException("argument of ArraySet ctor can't be NULL");
        }
        if (set instanceof ArraySet) {
            this.values = ((ArraySet)set).values;
        } else if (set instanceof Collection) {
            HashSet hset = new HashSet((Collection)Collection.class.cast(set));
            this.values = hset.toArray(new Object[hset.size()]);
        } else {
            HashSet<T> hset = new HashSet<T>(0);
            for (T item : set) {
                hset.add(item);
            }
            this.values = hset.toArray(new Object[hset.size()]);
        }
    }

    public ArraySet<T> with(T value) {
        if (value == null) {
            throw new IllegalArgumentException("argument of ArraySet#with() can't be NULL");
        }
        HashSet<T> list = new HashSet<T>(this.size() + 1);
        list.addAll(this);
        list.remove(value);
        list.add(value);
        return new ArraySet(list);
    }

    public ArraySet<T> with(Collection<T> vals) {
        if (vals == null) {
            throw new IllegalArgumentException("arguments of ArraySet#with() can't be NULL");
        }
        HashSet<T> list = new HashSet<T>(this.size());
        list.addAll(this);
        list.removeAll(vals);
        list.addAll(vals);
        return new ArraySet(list);
    }

    public ArraySet<T> without(T value) {
        if (value == null) {
            throw new IllegalArgumentException("argument of ArraySet#without() can't be NULL");
        }
        LinkedList list = new LinkedList();
        list.addAll(this);
        list.remove(value);
        return new ArraySet(list);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public boolean equals(Object object) {
        boolean equals = object instanceof ArraySet ? Arrays.deepEquals(this.values, ((ArraySet)ArraySet.class.cast((Object)object)).values) : false;
        return equals;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        for (T item : this.values) {
            if (text.length() > 0) {
                text.append(", ");
            }
            text.append(item);
        }
        return text.toString();
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public boolean contains(Object key) {
        return Arrays.asList(this.values).contains(key);
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.values).iterator();
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.values.length];
        System.arraycopy(this.values, 0, array, 0, this.values.length);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Object[] dest = array.length == this.values.length ? array : new Object[this.values.length];
        System.arraycopy(this.values, 0, dest, 0, this.values.length);
        return dest;
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> col) {
        return Arrays.asList(this.values).containsAll(col);
    }

    @Override
    public boolean addAll(Collection<? extends T> col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> col) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

