/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Existence;
import com.jcabi.github.Github;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Notifications;
import com.jcabi.github.PublicKeys;
import com.jcabi.github.SmartJson;
import com.jcabi.github.UserEmails;
import com.jcabi.github.UserOrganizations;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import javax.json.JsonObject;

@Immutable
public interface User
extends JsonReadable,
JsonPatchable {
    public Github github();

    public String login() throws IOException;

    public UserOrganizations organizations();

    public PublicKeys keys();

    public UserEmails emails();

    public Notifications notifications() throws IOException;

    public void markAsRead(Date var1) throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements User {
        private final transient User user;
        private final transient SmartJson jsn;

        public Smart(User usr) {
            this.user = usr;
            this.jsn = new SmartJson(usr);
        }

        public boolean exists() throws IOException {
            return new Existence(this.user).check();
        }

        public int id() throws IOException {
            return this.user.json().getJsonNumber("id").intValue();
        }

        public URL avatarUrl() throws IOException {
            try {
                return new URI(this.jsn.text("avatar_url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public URL url() throws IOException {
            try {
                return new URI(this.jsn.text("url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public String name() throws IOException {
            JsonObject json = this.json();
            if (!json.containsKey((Object)"name")) {
                throw new IllegalStateException(String.format("User %s doesn't have a name specified in his/her Github account; use #hasName() first.", this.login()));
            }
            return json.getString("name");
        }

        public boolean hasName() throws IOException {
            return this.json().containsKey((Object)"name");
        }

        public String company() throws IOException {
            return this.jsn.text("company");
        }

        public String location() throws IOException {
            return this.jsn.text("location");
        }

        public String email() throws IOException {
            return this.jsn.text("email");
        }

        @Override
        public Github github() {
            return this.user.github();
        }

        @Override
        public String login() throws IOException {
            return this.user.login();
        }

        @Override
        public UserOrganizations organizations() {
            return this.user.organizations();
        }

        @Override
        public PublicKeys keys() {
            return this.user.keys();
        }

        @Override
        public UserEmails emails() {
            return this.user.emails();
        }

        @Override
        public Notifications notifications() throws IOException {
            return this.user.notifications();
        }

        @Override
        public void markAsRead(Date lastread) throws IOException {
            this.user.markAsRead(lastread);
        }

        @Override
        public JsonObject json() throws IOException {
            return this.user.json();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.user.patch(json);
        }

        public String htmlUrl() throws IOException {
            return this.jsn.text("html_url");
        }

        public String followersUrl() throws IOException {
            return this.jsn.text("followers_url");
        }

        public String followingUrl() throws IOException {
            return this.jsn.text("following_url");
        }

        public String gistsUrl() throws IOException {
            return this.jsn.text("gists_url");
        }

        public String starredUrl() throws IOException {
            return this.jsn.text("starred_url");
        }

        public String subscriptionsUrl() throws IOException {
            return this.jsn.text("subscriptions_url");
        }

        public String organizationsUrl() throws IOException {
            return this.jsn.text("organizations_url");
        }

        public String reposUrl() throws IOException {
            return this.jsn.text("repos_url");
        }

        public String eventsUrl() throws IOException {
            return this.jsn.text("events_url");
        }

        public String receivedEventsUrl() throws IOException {
            return this.jsn.text("received_events_url");
        }

        public String type() throws IOException {
            return this.jsn.text("type");
        }

        public boolean siteAdmin() throws IOException {
            return "true".equals(this.jsn.text("site_admin"));
        }

        public String blog() throws IOException {
            return this.jsn.text("blog");
        }

        public boolean hireable() throws IOException {
            return "true".equals(this.jsn.text("hireable"));
        }

        public String bio() throws IOException {
            return this.jsn.text("bio");
        }

        public int publicRepos() throws IOException {
            return Integer.parseInt(this.jsn.text("public_repos"));
        }

        public int publicGists() throws IOException {
            return Integer.parseInt(this.jsn.text("public_gists"));
        }

        public int followersCount() throws IOException {
            return Integer.parseInt(this.jsn.text("followers"));
        }

        public int followingCount() throws IOException {
            return Integer.parseInt(this.jsn.text("following"));
        }

        public Github.Time created() throws IOException {
            try {
                return new Github.Time(this.jsn.text("created_at"));
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Cannot parse value of 'created_at' property", ex);
            }
        }

        public Github.Time updated() throws IOException {
            try {
                return new Github.Time(this.jsn.text("updated_at"));
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Cannot parse value of 'updated_at' property", ex);
            }
        }

        public String toString() {
            return "User.Smart(user=" + this.user + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            User this$user = this.user;
            User other$user = other.user;
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            User $user = this.user;
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

