/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Branch;
import com.jcabi.github.Branches;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.RtBranch;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtValuePagination;
import com.jcabi.http.Request;
import java.util.stream.StreamSupport;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtBranches
implements Branches {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    RtBranches(Request req, Repo repo) {
        this.entry = req;
        this.owner = repo;
        Coordinates coords = repo.coordinates();
        this.request = this.entry.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/branches").back();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Iterable<Branch> iterate() {
        return new RtPagination<Branch>(this.request, new RtValuePagination.Mapping<Branch, JsonObject>(){

            @Override
            public Branch map(JsonObject object) {
                return new RtBranch(RtBranches.this.entry, RtBranches.this.owner, object.getString("name"), object.getJsonObject("commit").getString("sha"));
            }
        });
    }

    @Override
    public Branch find(String name) {
        return StreamSupport.stream(this.iterate().spliterator(), false).filter(item -> item.name().equals(name)).findFirst().orElse(null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtBranches)) {
            return false;
        }
        RtBranches other = (RtBranches)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

