/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.PublicKey;
import com.jcabi.github.User;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import com.jcabi.xml.XML;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class MkPublicKey
implements PublicKey {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient int num;

    MkPublicKey(MkStorage stg, String login, int number) {
        this.storage = stg;
        this.self = login;
        this.num = number;
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public User user() {
        return new MkUser(this.storage, this.self);
    }

    @Override
    public int number() {
        return this.num;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            MkPublicKey other = (MkPublicKey)obj;
            result = this.num == other.num && this.storage.equals(other.storage) && this.self.equals(other.self);
        }
        return result;
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + this.self.hashCode();
        result = 31 * result + this.num;
        return result;
    }

    private String xpath() {
        return String.format("/github/users/user[login='%s']/keys/key[id='%d']", this.self, this.num);
    }

    @Generated
    public String toString() {
        return "MkPublicKey(storage=" + this.storage + ", self=" + this.self + ", num=" + this.num + ")";
    }
}

