/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Content;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import jakarta.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.apache.commons.lang3.builder.CompareToBuilder;

@Immutable
@Loggable(value=1)
final class MkContent
implements Content {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient String location;
    private final transient String branch;

    MkContent(MkStorage stg, String login, Coordinates rep, String path, String ref) {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.location = path;
        this.branch = ref;
    }

    @Override
    public int compareTo(Content cont) {
        return new CompareToBuilder().append((Object)this.path(), (Object)cont.path()).append((Object)this.repo().coordinates(), (Object)cont.repo().coordinates()).build();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public String path() {
        return this.location;
    }

    @Override
    public InputStream raw() throws IOException {
        return new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)((String)this.storage.xml().xpath(this.xpath().concat("/content/text()")).get(0))));
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            MkContent other = (MkContent)obj;
            result = this.storage.equals(other.storage) && this.self.equals(other.self) && this.coords.equals(other.coords) && this.location.equals(other.location) && this.branch.equals(other.branch);
        }
        return result;
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + this.self.hashCode();
        result = 31 * result + this.coords.hashCode();
        result = 31 * result + this.location.hashCode();
        result = 31 * result + this.branch.hashCode();
        return result;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/contents/content[path='%s' and @ref='%s']", this.coords, this.location, this.branch);
    }

    @Generated
    public String toString() {
        return "MkContent(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ", location=" + this.location + ", branch=" + this.branch + ")";
    }
}

