/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Check;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Pull;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
public final class MkCheck
implements Check {
    private final transient MkStorage storage;
    private final transient Coordinates coordinates;
    private final transient Pull pull;
    private final transient int identifier;

    public MkCheck(MkStorage stg, Coordinates coord, Pull pll, int number) {
        this.storage = stg;
        this.coordinates = coord;
        this.pull = pll;
        this.identifier = number;
    }

    @Override
    public boolean successful() throws IOException {
        XML node = (XML)this.storage.xml().nodes(this.xpath()).get(0);
        Check.Status status = Check.Status.fromString((String)node.xpath("@status").get(0));
        Check.Conclusion conclusion = Check.Conclusion.fromString((String)node.xpath("@conclusion").get(0));
        return status == Check.Status.COMPLETED && conclusion == Check.Conclusion.SUCCESS;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            MkCheck other = (MkCheck)obj;
            result = this.identifier == other.identifier && this.storage.equals(other.storage) && this.coordinates.equals(other.coordinates) && this.pull.equals(other.pull);
        }
        return result;
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + this.coordinates.hashCode();
        result = 31 * result + this.pull.hashCode();
        result = 31 * result + this.identifier;
        return result;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/pulls/pull[number='%d']/checks/check[@id='%d']", this.coordinates, this.pull.number(), this.identifier);
    }

    @Generated
    public String toString() {
        return "MkCheck(storage=" + this.storage + ", coordinates=" + this.coordinates + ", pull=" + this.pull + ", identifier=" + this.identifier + ")";
    }
}

