/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Content;
import com.jcabi.github.Coordinates;
import com.jcabi.github.GitHub;
import com.jcabi.github.Issue;
import com.jcabi.github.Repo;
import com.jcabi.github.RtSearchPagination;
import com.jcabi.github.Search;
import com.jcabi.github.User;
import com.jcabi.http.Request;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtSearch
implements Search {
    private static final Pattern SLASH = Pattern.compile("/");
    private static final Pattern QUERY = Pattern.compile("=");
    private final transient GitHub ghub;
    private final transient Request request;

    RtSearch(GitHub github, Request req) {
        this.ghub = github;
        this.request = req.uri().path("/search").back();
    }

    @Override
    public GitHub github() {
        return this.ghub;
    }

    @Override
    public Iterable<Repo> repos(String keywords, String sort, Search.Order order) {
        return new RtSearchPagination<Repo>(this.request, "repositories", keywords, sort, order.identifier(), object -> this.github().repos().get(new Coordinates.Simple(object.getString("full_name"))));
    }

    @Override
    public Iterable<Issue> issues(String keywords, String sort, Search.Order order, EnumMap<Search.Qualifier, String> qualifiers) {
        StringBuilder keyword = new StringBuilder(keywords);
        for (Map.Entry<Search.Qualifier, String> entry : qualifiers.entrySet()) {
            keyword.append('+').append(entry.getKey().identifier()).append(':').append(entry.getValue());
        }
        return new RtSearchPagination<Issue>(this.request, "issues", keyword.toString(), sort, order.identifier(), object -> {
            try {
                String[] parts = SLASH.split(new URI(object.getString("url")).getPath());
                return this.ghub.repos().get(new Coordinates.Simple(parts[2], parts[3])).issues().get(object.getInt("number"));
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException(ex);
            }
        });
    }

    @Override
    public Iterable<User> users(String keywords, String sort, Search.Order order) {
        return new RtSearchPagination<User>(this.request, "users", keywords, sort, order.identifier(), object -> this.ghub.users().get(object.getString("login")));
    }

    @Override
    public Iterable<Content> codes(String keywords, String sort, Search.Order order) {
        return new RtSearchPagination<Content>(this.request, "code", keywords, sort, order.identifier(), object -> {
            try {
                URI uri = new URI(object.getString("url"));
                String[] parts = SLASH.split(uri.getPath());
                String ref = QUERY.split(uri.getQuery())[1];
                return this.ghub.repos().get(new Coordinates.Simple(parts[2], parts[3])).contents().get(object.getString("path"), ref);
            }
            catch (IOException | URISyntaxException ex) {
                throw new IllegalStateException(ex);
            }
        });
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtSearch)) {
            return false;
        }
        RtSearch other = (RtSearch)o;
        GitHub this$ghub = this.ghub;
        GitHub other$ghub = other.ghub;
        return !(this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GitHub $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        return result;
    }
}

