/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Milestone;
import com.jcabi.github.Repo;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtMilestone
implements Milestone {
    private final transient Request request;
    private final transient Repo owner;
    private final transient int num;

    RtMilestone(Request req, Repo repo, int number) {
        Coordinates coords = repo.coordinates();
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/milestones").path(Integer.toString(number)).back();
        this.owner = repo;
        this.num = number;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public int compareTo(Milestone milestone) {
        return Integer.compare(this.number(), milestone.number());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtMilestone)) {
            return false;
        }
        RtMilestone other = (RtMilestone)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

