/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.FromProperties;
import com.jcabi.github.Gists;
import com.jcabi.github.GitHub;
import com.jcabi.github.Gitignores;
import com.jcabi.github.Limits;
import com.jcabi.github.Markdown;
import com.jcabi.github.Organizations;
import com.jcabi.github.Repos;
import com.jcabi.github.RtGists;
import com.jcabi.github.RtGitignores;
import com.jcabi.github.RtLimits;
import com.jcabi.github.RtMarkdown;
import com.jcabi.github.RtOrganizations;
import com.jcabi.github.RtRepos;
import com.jcabi.github.RtSearch;
import com.jcabi.github.RtUsers;
import com.jcabi.github.Search;
import com.jcabi.github.Users;
import com.jcabi.http.Request;
import com.jcabi.http.request.ApacheRequest;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.wire.AutoRedirectingWire;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;

@Immutable
@Loggable(value=1)
public final class RtGitHub
implements GitHub {
    private static final Request REQUEST = new ApacheRequest("https://api.github.com").header("User-Agent", (Object)new FromProperties("jcabigithub.properties").format()).header("Accept", (Object)"application/json").header("Content-Type", (Object)"application/json").through(AutoRedirectingWire.class, new Object[0]);
    private final transient Request request;

    public RtGitHub() {
        this(REQUEST);
    }

    public RtGitHub(URI domain) {
        this(REQUEST.uri().set(domain).back());
    }

    public RtGitHub(String user, String pwd) {
        this(REQUEST.header("Authorization", (Object)String.format("Basic %s", DatatypeConverter.printBase64Binary((byte[])String.format("%s:%s", user, pwd).getBytes(StandardCharsets.UTF_8)))));
    }

    public RtGitHub(String user, String pwd, URI domain) {
        this(REQUEST.uri().set(domain).back().header("Authorization", (Object)String.format("Basic %s", DatatypeConverter.printBase64Binary((byte[])String.format("%s:%s", user, pwd).getBytes(StandardCharsets.UTF_8)))));
    }

    public RtGitHub(String token, URI domain) {
        this(REQUEST.uri().set(domain).back().header("Authorization", (Object)String.format("token %s", token)));
    }

    public RtGitHub(String token) {
        this(REQUEST.header("Authorization", (Object)String.format("token %s", token)));
    }

    public RtGitHub(Request req) {
        this.request = req;
    }

    @Override
    public Request entry() {
        return this.request;
    }

    @Override
    public Repos repos() {
        return new RtRepos(this, this.request);
    }

    @Override
    public Gists gists() {
        return new RtGists(this, this.request);
    }

    @Override
    public Users users() {
        return new RtUsers(this, this.request);
    }

    @Override
    public Organizations organizations() {
        return new RtOrganizations(this, this.request);
    }

    @Override
    public Limits limits() {
        return new RtLimits(this, this.request);
    }

    @Override
    public Search search() {
        return new RtSearch(this, this.request);
    }

    @Override
    public JsonObject meta() throws IOException {
        return ((JsonResponse)this.request.uri().path("meta").back().fetch().as(JsonResponse.class)).json().readObject();
    }

    @Override
    public JsonObject emojis() throws IOException {
        return ((JsonResponse)this.request.uri().path("emojis").back().fetch().as(JsonResponse.class)).json().readObject();
    }

    @Override
    public Gitignores gitignores() {
        return new RtGitignores(this);
    }

    @Override
    public Markdown markdown() {
        return new RtMarkdown(this, this.request);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            RtGitHub other = (RtGitHub)obj;
            result = this.request.equals(other.request);
        }
        return result;
    }

    public int hashCode() {
        return this.request.hashCode();
    }

    @Generated
    public String toString() {
        return "RtGitHub(request=" + this.request + ")";
    }
}

