/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Fork;
import com.jcabi.github.Repo;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtFork
implements Fork {
    private final transient Request request;
    private final transient int num;

    RtFork(Request req, Repo repo, int number) {
        Coordinates coords = repo.coordinates();
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/forks").path(Integer.toString(number)).back();
        this.num = number;
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtFork)) {
            return false;
        }
        RtFork other = (RtFork)o;
        if (this.num != other.num) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.num;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

