/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.Limit;
import lombok.Generated;

@Immutable
public interface Limits {
    public static final String CORE = "core";
    public static final String SEARCH = "search";

    public GitHub github();

    public Limit get(String var1);

    @Immutable
    @Loggable(value=1)
    public static final class Throttled
    implements Limits {
        private final transient Limits origin;
        private final transient int max;

        public Throttled(Limits limits, int allowed) {
            this.origin = limits;
            this.max = allowed;
        }

        @Override
        public GitHub github() {
            return this.origin.github();
        }

        @Override
        public Limit get(String resource) {
            return new Limit.Throttled(this.origin.get(resource), this.max);
        }

        @Generated
        public String toString() {
            return "Limits.Throttled(origin=" + this.origin + ", max=" + this.max + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Throttled)) {
                return false;
            }
            Throttled other = (Throttled)o;
            Limits this$origin = this.origin;
            Limits other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Limits $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }
}

