/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import org.apache.commons.lang3.builder.CompareToBuilder;

@Immutable
public interface Coordinates
extends Comparable<Coordinates> {
    public static final String SEPARATOR = "/";

    public String user();

    public String repo();

    @Immutable
    public static final class Https
    implements Coordinates {
        private static final String DOMAIN = "https://github.com/";
        private final String url;

        public Https(String https) {
            this.url = https;
        }

        @Override
        public String user() {
            return this.split()[0];
        }

        @Override
        public String repo() {
            String repo = this.split()[1];
            String suffix = ".git";
            String result = repo.endsWith(".git") ? repo.substring(0, repo.length() - ".git".length()) : repo;
            return result;
        }

        @Override
        public int compareTo(Coordinates other) {
            return new CompareToBuilder().append((Object)this.user(), (Object)other.user()).append((Object)this.repo(), (Object)other.repo()).build();
        }

        public boolean equals(Object obj) {
            boolean result;
            if (this == obj) {
                result = true;
            } else if (obj == null || this.getClass() != obj.getClass()) {
                result = false;
            } else {
                Https other = (Https)obj;
                result = this.url.equals(other.url);
            }
            return result;
        }

        public int hashCode() {
            return this.url.hashCode();
        }

        private String[] split() {
            if (!this.url.startsWith(DOMAIN)) {
                throw new IllegalArgumentException(String.format("Invalid URL, the '%s' should start with '%s'", this.url, DOMAIN));
            }
            return this.url.substring(DOMAIN.length()).split(Coordinates.SEPARATOR, 2);
        }
    }

    @Immutable
    public static final class Simple
    implements Coordinates {
        private final transient String usr;
        private final transient String rpo;

        public Simple(String user, String repo) {
            this.usr = user;
            this.rpo = repo;
        }

        public Simple(String mnemo) {
            this(Simple.parse(mnemo)[0], Simple.parse(mnemo)[1]);
        }

        public String toString() {
            return String.format("%s/%s", this.usr, this.rpo);
        }

        @Override
        public String user() {
            return this.usr;
        }

        @Override
        public String repo() {
            return this.rpo;
        }

        @Override
        public int compareTo(Coordinates other) {
            return new CompareToBuilder().append((Object)this.usr, (Object)other.user()).append((Object)this.rpo, (Object)other.repo()).build();
        }

        public boolean equals(Object obj) {
            boolean result;
            if (this == obj) {
                result = true;
            } else if (obj == null || this.getClass() != obj.getClass()) {
                result = false;
            } else {
                Simple other = (Simple)obj;
                result = this.usr.equals(other.usr) && this.rpo.equals(other.rpo);
            }
            return result;
        }

        public int hashCode() {
            int result = this.usr.hashCode();
            result = 31 * result + this.rpo.hashCode();
            return result;
        }

        private static String[] parse(String mnemo) {
            String[] parts = mnemo.split(Coordinates.SEPARATOR, 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException(String.format("invalid coordinates '%s'", mnemo));
            }
            return parts;
        }
    }
}

