/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Milestone;
import com.jcabi.github.Milestones;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkMilestone;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Map;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
final class MkMilestones
implements Milestones {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkMilestones(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf((Object)"milestones"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Milestone create(String title) throws IOException {
        int number = 1 + this.storage.xml().xpath(String.format("%s/milestone/number/text()", this.xpath())).size();
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"milestone").add((Object)"number").set((Object)Integer.toString(number)).up().add((Object)"title").set((Object)title).up().add((Object)"state").set((Object)"open").up().add((Object)"description").set((Object)"mock milestone").up());
        return this.get(number);
    }

    @Override
    public Milestone get(int number) {
        return new MkMilestone(this.storage, this.self, this.coords, number);
    }

    @Override
    public Iterable<Milestone> iterate(Map<String, String> params) {
        return new MkIterable<Milestone>(this.storage, String.format("%s/milestone", this.xpath()), new MkIterable.Mapping<Milestone>(){

            @Override
            public Milestone map(XML xml) {
                return MkMilestones.this.get(Integer.parseInt((String)xml.xpath("number/text()").get(0)));
            }
        });
    }

    @Override
    public void remove(int number) throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("%s/milestone[number='%d']", this.xpath(), number)).remove());
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/milestones", this.coords);
    }
}

