/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.Assignees;
import com.jcabi.github.Coordinates;
import com.jcabi.github.User;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@Immutable
final class MkAssignees
implements Assignees {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkAssignees(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
    }

    @Override
    public Iterable<User> iterate() {
        try {
            HashSet<User> assignees = new HashSet<User>();
            assignees.add(new MkUser(this.storage, this.self));
            MkIterable<User> collaborators = new MkIterable<User>(this.storage, String.format("%s/user", this.xpath()), new MkIterable.Mapping<User>(){

                @Override
                public User map(XML xml) {
                    try {
                        return new MkUser(MkAssignees.this.storage, (String)xml.xpath("login/text()").get(0));
                    }
                    catch (IOException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
            });
            for (User collab : collaborators) {
                assignees.add(collab);
            }
            return assignees;
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public boolean check(String login) {
        try {
            List xpath = this.storage.xml().xpath(String.format("%s/user/login/text()", this.xpath()));
            return this.self.equalsIgnoreCase(login) || !xpath.isEmpty() && StringUtils.equalsIgnoreCase((CharSequence)login, (CharSequence)((CharSequence)xpath.get(0)));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/collaborators", this.coords);
    }
}

