/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Gist;
import com.jcabi.github.GistComments;
import com.jcabi.github.Github;
import com.jcabi.github.RtGistComments;
import com.jcabi.github.RtJson;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.net.URI;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.hamcrest.Matchers;

@Immutable
@Loggable(value=1)
final class RtGist
implements Gist {
    private final transient Request request;
    private final transient Github ghub;
    private final transient Request entry;
    private final transient String gist;

    RtGist(Github github, Request req, String name) {
        this.ghub = github;
        this.entry = req;
        this.gist = name;
        this.request = req.uri().path("/gists").path(name).back();
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Github github() {
        return this.ghub;
    }

    @Override
    public String identifier() {
        return this.gist;
    }

    @Override
    public String read(String file) throws IOException {
        Response response = this.request.fetch();
        String url = ((JsonResponse)((RestResponse)response.as(RestResponse.class)).assertStatus(200).as(JsonResponse.class)).json().readObject().getJsonObject("files").getJsonObject(file).getString("raw_url");
        return ((RestResponse)((RestResponse)response.as(RestResponse.class)).jump(URI.create(url)).fetch().as(RestResponse.class)).assertStatus(200).body();
    }

    @Override
    public void write(String file, String content) throws IOException {
        JsonObjectBuilder builder = Json.createObjectBuilder().add("content", content);
        JsonObject json = Json.createObjectBuilder().add("files", Json.createObjectBuilder().add(file, builder)).build();
        this.patch(json);
    }

    @Override
    public void star() throws IOException {
        ((RestResponse)this.request.uri().path("star").back().method("PUT").fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public void unstar() throws IOException {
        ((RestResponse)this.request.uri().path("star").back().method("DELETE").fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public boolean starred() throws IOException {
        return ((RestResponse)this.request.uri().path("star").back().method("GET").fetch().as(RestResponse.class)).assertStatus(Matchers.isOneOf((Object[])new Integer[]{204, 404})).status() == 204;
    }

    @Override
    public Gist fork() throws IOException {
        return new RtGist(this.ghub, this.entry, ((JsonResponse)((RestResponse)this.request.uri().path("/forks").back().method("POST").fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getString("id"));
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public GistComments comments() throws IOException {
        return new RtGistComments(this.entry, this);
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtGist)) {
            return false;
        }
        RtGist other = (RtGist)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Github this$ghub = this.ghub;
        Github other$ghub = other.ghub;
        return !(this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Github $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        return result;
    }
}

