/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.dynamo;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.dynamo.Attributes;
import com.jcabi.dynamo.AwsFrame;
import com.jcabi.dynamo.AwsItem;
import com.jcabi.dynamo.AwsIterator$AjcClosure1;
import com.jcabi.dynamo.AwsIterator$AjcClosure3;
import com.jcabi.dynamo.AwsIterator$AjcClosure5;
import com.jcabi.dynamo.AwsTable;
import com.jcabi.dynamo.Conditions;
import com.jcabi.dynamo.Credentials;
import com.jcabi.dynamo.Dosage;
import com.jcabi.dynamo.Item;
import com.jcabi.dynamo.Valve;
import com.jcabi.immutable.Array;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@Loggable(value=1)
final class AwsIterator
implements Iterator<Item> {
    private final transient Credentials credentials;
    private final transient Conditions conditions;
    private final transient AwsFrame frame;
    private final transient String name;
    private final transient Collection<String> keys;
    private final transient Valve valve;
    private final transient AtomicReference<Dosage> dosage;
    private transient int position;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    AwsIterator(Credentials creds, AwsFrame frm, String label, Conditions conds, Collection<String> primary, Valve vlv) {
        this.credentials = creds;
        this.frame = frm;
        this.name = label;
        this.conditions = conds;
        this.keys = primary;
        this.valve = vlv;
        this.dosage = new AtomicReference();
        this.position = -1;
    }

    @Override
    public boolean hasNext() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodLogger.aspectOf().wrapClass(new AwsIterator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return AwsIterator.hasNext_aroundBody0(this, joinPoint);
    }

    @Override
    public Item next() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Item)MethodLogger.aspectOf().wrapClass(new AwsIterator$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return AwsIterator.next_aroundBody2(this, joinPoint);
    }

    @Override
    public void remove() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodLogger.aspectOf().wrapClass(new AwsIterator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        AwsIterator.remove_aroundBody4(this, joinPoint);
    }

    public String toString() {
        return "AwsIterator(credentials=" + this.credentials + ", conditions=" + this.conditions + ", frame=" + this.frame + ", name=" + this.name + ", keys=" + this.keys + ", valve=" + this.valve + ", dosage=" + this.dosage + ", position=" + this.position + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AwsIterator)) {
            return false;
        }
        AwsIterator other = (AwsIterator)o;
        Credentials this$credentials = this.credentials;
        Credentials other$credentials = other.credentials;
        if (this$credentials == null ? other$credentials != null : !this$credentials.equals(other$credentials)) {
            return false;
        }
        Conditions this$conditions = this.conditions;
        Conditions other$conditions = other.conditions;
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        AwsFrame this$frame = this.frame;
        AwsFrame other$frame = other.frame;
        if (this$frame == null ? other$frame != null : !((Object)this$frame).equals(other$frame)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Collection<String> this$keys = this.keys;
        Collection<String> other$keys = other.keys;
        if (this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys)) {
            return false;
        }
        Valve this$valve = this.valve;
        Valve other$valve = other.valve;
        return !(this$valve == null ? other$valve != null : !this$valve.equals(other$valve));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Credentials $credentials = this.credentials;
        result = result * 59 + ($credentials == null ? 43 : $credentials.hashCode());
        Conditions $conditions = this.conditions;
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        AwsFrame $frame = this.frame;
        result = result * 59 + ($frame == null ? 43 : ((Object)$frame).hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Collection<String> $keys = this.keys;
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        Valve $valve = this.valve;
        result = result * 59 + ($valve == null ? 43 : $valve.hashCode());
        return result;
    }

    static {
        AwsIterator.ajc$preClinit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ boolean hasNext_aroundBody0(AwsIterator ajc$this, JoinPoint joinPoint) {
        AtomicReference<Dosage> atomicReference = ajc$this.dosage;
        synchronized (atomicReference) {
            if (ajc$this.dosage.get() == null) {
                try {
                    ajc$this.dosage.set(ajc$this.valve.fetch(ajc$this.credentials, ajc$this.name, ajc$this.conditions, ajc$this.keys));
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
                ajc$this.position = -1;
            }
            if (ajc$this.dosage.get().hasNext() && ajc$this.position + 1 >= ajc$this.dosage.get().items().size()) {
                ajc$this.dosage.set(ajc$this.dosage.get().next());
                ajc$this.position = -1;
            }
            return ajc$this.dosage.get().items().size() - ajc$this.position > 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ Item next_aroundBody2(AwsIterator ajc$this, JoinPoint joinPoint) {
        AtomicReference<Dosage> atomicReference = ajc$this.dosage;
        synchronized (atomicReference) {
            if (!ajc$this.hasNext()) {
                throw new NoSuchElementException(String.format("no more items in the frame, position=%d", ajc$this.position));
            }
            ++ajc$this.position;
            return new AwsItem(ajc$this.credentials, ajc$this.frame, ajc$this.name, new Attributes(ajc$this.dosage.get().items().get(ajc$this.position)), (Array<String>)new Array(ajc$this.keys));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* synthetic */ void remove_aroundBody4(AwsIterator ajc$this, JoinPoint joinPoint) {
        AtomicReference<Dosage> atomicReference = ajc$this.dosage;
        synchronized (atomicReference) {
            AmazonDynamoDB aws = ajc$this.credentials.aws();
            try {
                Dosage prev = ajc$this.dosage.get();
                ArrayList<Map<String, AttributeValue>> items = new ArrayList<Map<String, AttributeValue>>(prev.items());
                Map item = (Map)items.remove(ajc$this.position);
                long start = System.currentTimeMillis();
                DeleteItemResult res = aws.deleteItem(new DeleteItemRequest().withTableName(ajc$this.name).withKey((Map)new Attributes(item).only(ajc$this.keys)).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL).withExpected(new Attributes(item).only(ajc$this.keys).asKeys()));
                ajc$this.dosage.set(new Fixed(prev, items));
                --ajc$this.position;
                Logger.info((Object)ajc$this, (String)"#remove(): item #%d removed from DynamoDB, %s, in %[ms]s", (Object[])new Object[]{ajc$this.position, AwsTable.print(res.getConsumedCapacity()), System.currentTimeMillis() - start});
            }
            finally {
                aws.shutdown();
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AwsIterator.java", AwsIterator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hasNext", "com.jcabi.dynamo.AwsIterator", "", "", "", "boolean"), 136);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "next", "com.jcabi.dynamo.AwsIterator", "", "", "", "com.jcabi.dynamo.Item"), 163);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "com.jcabi.dynamo.AwsIterator", "", "", "", "void"), 186);
    }

    @Immutable
    private static final class Fixed
    implements Dosage {
        private final transient Array<Map<String, AttributeValue>> list;
        private final transient Dosage prev;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        Fixed(Dosage dsg, List<Map<String, AttributeValue>> items) {
            Dosage dosage = dsg;
            List<Map<String, AttributeValue>> list = items;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)dosage, list);
            try {
                JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                try {
                }
                finally {
                    ImmutabilityChecker.aspectOf().after(joinPoint2);
                }
                this.prev = dsg;
                this.list = new Array(items);
            }
            finally {
                ImmutabilityChecker.aspectOf().after(joinPoint);
            }
        }

        @Override
        public List<Map<String, AttributeValue>> items() {
            return Collections.unmodifiableList(this.list);
        }

        @Override
        public Dosage next() {
            return this.prev.next();
        }

        @Override
        public boolean hasNext() {
            return this.prev.hasNext();
        }

        static {
            Fixed.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("AwsIterator.java", Fixed.class);
            ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "com.jcabi.dynamo.Dosage", "", "", ""), 238);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "com.jcabi.dynamo.AwsIterator$Fixed", "com.jcabi.dynamo.Dosage:java.util.List", "dsg:items", ""), 238);
        }
    }
}

