/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.mockmvc.internal;

import com.jayway.restassured.authentication.AuthenticationScheme;
import com.jayway.restassured.authentication.NoAuthScheme;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.filter.log.RequestLoggingFilter;
import com.jayway.restassured.internal.LogSpecificationImpl;
import com.jayway.restassured.internal.RequestSpecificationImpl;
import com.jayway.restassured.module.mockmvc.internal.MockMvcRequestSpecificationImpl;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestLogSpecification;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestSpecification;
import com.jayway.restassured.specification.RequestSpecification;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Collections;

public class MockMvcRequestLogSpecificationImpl
extends LogSpecificationImpl
implements MockMvcRequestLogSpecification {
    private MockMvcRequestSpecificationImpl requestSpecification;

    public MockMvcRequestLogSpecificationImpl(MockMvcRequestSpecificationImpl requestSpecification) {
        this.requestSpecification = requestSpecification;
    }

    public MockMvcRequestSpecification params() {
        return this.logWith(LogDetail.PARAMS);
    }

    public MockMvcRequestSpecification parameters() {
        return this.logWith(LogDetail.PARAMS);
    }

    public MockMvcRequestSpecification body() {
        return this.body(this.shouldPrettyPrint((RequestSpecification)this.toRequestSpecification()));
    }

    public MockMvcRequestSpecification body(boolean shouldPrettyPrint) {
        return this.logWith(LogDetail.BODY, shouldPrettyPrint);
    }

    public MockMvcRequestSpecification all(boolean shouldPrettyPrint) {
        return this.logWith(LogDetail.ALL, shouldPrettyPrint);
    }

    public MockMvcRequestSpecification everything(boolean shouldPrettyPrint) {
        return this.all(shouldPrettyPrint);
    }

    public MockMvcRequestSpecification all() {
        return this.all(this.shouldPrettyPrint((RequestSpecification)this.toRequestSpecification()));
    }

    public MockMvcRequestSpecification everything() {
        return this.all();
    }

    public MockMvcRequestSpecification headers() {
        return this.logWith(LogDetail.HEADERS);
    }

    public MockMvcRequestSpecification cookies() {
        return this.logWith(LogDetail.COOKIES);
    }

    public MockMvcRequestSpecification ifValidationFails() {
        return this.ifValidationFails(LogDetail.ALL);
    }

    public MockMvcRequestSpecification ifValidationFails(LogDetail logDetail) {
        return this.ifValidationFails(logDetail, this.shouldPrettyPrint((RequestSpecification)this.toRequestSpecification()));
    }

    public MockMvcRequestSpecification ifValidationFails(LogDetail logDetail, boolean shouldPrettyPrint) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        this.requestSpecification.getLogRepository().registerRequestLog(baos);
        return this.logWith(logDetail, shouldPrettyPrint, ps);
    }

    private MockMvcRequestSpecification logWith(LogDetail logDetail) {
        RequestSpecificationImpl reqSpec = this.toRequestSpecification();
        return this.logWith(logDetail, this.shouldPrettyPrint((RequestSpecification)reqSpec));
    }

    private MockMvcRequestSpecification logWith(LogDetail logDetail, boolean prettyPrintingEnabled) {
        return this.logWith(logDetail, prettyPrintingEnabled, this.getPrintStream((RequestSpecification)this.toRequestSpecification()));
    }

    private MockMvcRequestSpecification logWith(LogDetail logDetail, boolean prettyPrintingEnabled, PrintStream printStream) {
        this.requestSpecification.setRequestLoggingFilter(new RequestLoggingFilter(logDetail, prettyPrintingEnabled, printStream));
        return this.requestSpecification;
    }

    private RequestSpecificationImpl toRequestSpecification() {
        return new RequestSpecificationImpl("", 8080, "", (AuthenticationScheme)new NoAuthScheme(), Collections.emptyList(), null, true, this.requestSpecification.getRestAssuredConfig(), this.requestSpecification.getLogRepository(), null);
    }
}

