/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.module.mockmvc;

import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.module.mockmvc.config.RestAssuredMockMvcConfig;
import com.jayway.restassured.module.mockmvc.internal.MockMvcRequestSpecificationImpl;
import com.jayway.restassured.module.mockmvc.response.MockMvcResponse;
import com.jayway.restassured.module.mockmvc.specification.MockMvcAuthenticationScheme;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestSender;
import com.jayway.restassured.module.mockmvc.specification.MockMvcRequestSpecification;
import com.jayway.restassured.specification.ResponseSpecification;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestAssuredMockMvc {
    public static MockMvc mockMvc = null;
    public static RestAssuredMockMvcConfig config;
    public static MockMvcRequestSpecification requestSpecification;
    public static ResponseSpecification responseSpecification;
    private static List<ResultHandler> resultHandlers;
    public static String basePath;
    public static MockMvcAuthenticationScheme authentication;

    public static MockMvcRequestSpecification given() {
        return new MockMvcRequestSpecificationImpl(mockMvc, config, resultHandlers, basePath, requestSpecification, responseSpecification, authentication);
    }

    public static MockMvcRequestSender when() {
        return RestAssuredMockMvc.given().when();
    }

    public static void standaloneSetup(Object ... controllers) {
        mockMvc = MockMvcBuilders.standaloneSetup((Object[])controllers).build();
    }

    public static void webAppContextSetup(WebApplicationContext context) {
        DefaultMockMvcBuilder builder = MockMvcBuilders.webAppContextSetup((WebApplicationContext)context);
        mockMvc = builder.build();
    }

    public static void resultHandlers(ResultHandler resultHandler, ResultHandler ... resultHandlers) {
        AssertParameter.notNull((Object)resultHandler, ResultHandler.class);
        RestAssuredMockMvc.resultHandlers.add(resultHandler);
        if (resultHandlers != null && resultHandlers.length >= 1) {
            Collections.addAll(RestAssuredMockMvc.resultHandlers, resultHandlers);
        }
    }

    public static List<ResultHandler> resultHandlers() {
        return Collections.unmodifiableList(resultHandlers);
    }

    public static void reset() {
        mockMvc = null;
        config = null;
        basePath = "/";
        resultHandlers.clear();
        responseSpecification = null;
        requestSpecification = null;
        authentication = null;
    }

    public static MockMvcResponse get(String path, Object ... pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().get(path, pathParams);
    }

    public static MockMvcResponse get(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().get(path, pathParams);
    }

    public static MockMvcResponse post(String path, Object ... pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().post(path, pathParams);
    }

    public static MockMvcResponse post(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().post(path, pathParams);
    }

    public static MockMvcResponse put(String path, Object ... pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().put(path, pathParams);
    }

    public static MockMvcResponse delete(String path, Object ... pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().delete(path, pathParams);
    }

    public static MockMvcResponse delete(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().delete(path, pathParams);
    }

    public static MockMvcResponse head(String path, Object ... pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().head(path, pathParams);
    }

    public static MockMvcResponse head(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().head(path, pathParams);
    }

    public static MockMvcResponse patch(String path, Object ... pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().patch(path, pathParams);
    }

    public static MockMvcResponse patch(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().patch(path, pathParams);
    }

    public static MockMvcResponse options(String path, Object ... pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().options(path, pathParams);
    }

    public static MockMvcResponse options(String path, Map<String, ?> pathParams) {
        return (MockMvcResponse)RestAssuredMockMvc.given().options(path, pathParams);
    }

    public static MockMvcResponse get(URI uri) {
        return (MockMvcResponse)RestAssuredMockMvc.given().get(uri);
    }

    public static MockMvcResponse post(URI uri) {
        return (MockMvcResponse)RestAssuredMockMvc.given().post(uri);
    }

    public static MockMvcResponse put(URI uri) {
        return (MockMvcResponse)RestAssuredMockMvc.given().put(uri);
    }

    public static MockMvcResponse delete(URI uri) {
        return (MockMvcResponse)RestAssuredMockMvc.given().delete(uri);
    }

    public static MockMvcResponse head(URI uri) {
        return (MockMvcResponse)RestAssuredMockMvc.given().head(uri);
    }

    public static MockMvcResponse patch(URI uri) {
        return (MockMvcResponse)RestAssuredMockMvc.given().patch(uri);
    }

    public static MockMvcResponse options(URI uri) {
        return (MockMvcResponse)RestAssuredMockMvc.given().options(uri);
    }

    public static MockMvcResponse get(URL url) {
        return (MockMvcResponse)RestAssuredMockMvc.given().get(url);
    }

    public static MockMvcResponse post(URL url) {
        return (MockMvcResponse)RestAssuredMockMvc.given().post(url);
    }

    public static MockMvcResponse put(URL url) {
        return (MockMvcResponse)RestAssuredMockMvc.given().put(url);
    }

    public static MockMvcResponse delete(URL url) {
        return (MockMvcResponse)RestAssuredMockMvc.given().delete(url);
    }

    public static MockMvcResponse head(URL url) {
        return (MockMvcResponse)RestAssuredMockMvc.given().head(url);
    }

    public static MockMvcResponse patch(URL url) {
        return (MockMvcResponse)RestAssuredMockMvc.given().patch(url);
    }

    public static MockMvcResponse options(URL url) {
        return (MockMvcResponse)RestAssuredMockMvc.given().options(url);
    }

    public static MockMvcResponse get() {
        return (MockMvcResponse)RestAssuredMockMvc.given().get();
    }

    public static MockMvcResponse post() {
        return (MockMvcResponse)RestAssuredMockMvc.given().post();
    }

    public static MockMvcResponse put() {
        return (MockMvcResponse)RestAssuredMockMvc.given().put();
    }

    public static MockMvcResponse delete() {
        return (MockMvcResponse)RestAssuredMockMvc.given().delete();
    }

    public static MockMvcResponse head() {
        return (MockMvcResponse)RestAssuredMockMvc.given().head();
    }

    public static MockMvcResponse patch() {
        return (MockMvcResponse)RestAssuredMockMvc.given().patch();
    }

    public static MockMvcResponse options() {
        return (MockMvcResponse)RestAssuredMockMvc.given().options();
    }

    public static MockMvcAuthenticationScheme principal(final Principal principal) {
        return new MockMvcAuthenticationScheme(){

            public void authenticate(MockMvcRequestSpecification mockMvcRequestSpecification) {
                mockMvcRequestSpecification.auth().principal(principal);
            }
        };
    }

    public static MockMvcAuthenticationScheme principal(final Object principal) {
        return new MockMvcAuthenticationScheme(){

            public void authenticate(MockMvcRequestSpecification mockMvcRequestSpecification) {
                mockMvcRequestSpecification.auth().principal(principal);
            }
        };
    }

    public static MockMvcAuthenticationScheme principalWithCredentials(final Object principal, final Object credentials, final String ... authorities) {
        return new MockMvcAuthenticationScheme(){

            public void authenticate(MockMvcRequestSpecification mockMvcRequestSpecification) {
                mockMvcRequestSpecification.auth().principalWithCredentials(principal, credentials, authorities);
            }
        };
    }

    public static MockMvcAuthenticationScheme authentication(final Object authentication) {
        return new MockMvcAuthenticationScheme(){

            public void authenticate(MockMvcRequestSpecification mockMvcRequestSpecification) {
                mockMvcRequestSpecification.auth().authentication(authentication);
            }
        };
    }

    static {
        responseSpecification = null;
        resultHandlers = new ArrayList<ResultHandler>();
        basePath = "/";
    }
}

