/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.authentication;

import com.jayway.restassured.internal.assertion.AssertParameter;

public class FormAuthConfig {
    private final String formAction;
    private final String userInputTagName;
    private final String passwordInputTagName;

    public FormAuthConfig(String formAction, String userNameInputTagName, String passwordInputTagName) {
        AssertParameter.notNull((Object)formAction, (String)"Form action");
        AssertParameter.notNull((Object)userNameInputTagName, (String)"User input tag name");
        AssertParameter.notNull((Object)passwordInputTagName, (String)"Password input tag name");
        this.formAction = formAction;
        this.userInputTagName = userNameInputTagName;
        this.passwordInputTagName = passwordInputTagName;
    }

    public static FormAuthConfig springSecurity() {
        return new FormAuthConfig("/j_spring_security_check", "j_username", "j_password");
    }

    public String getFormAction() {
        return this.formAction;
    }

    public String getUserInputTagName() {
        return this.userInputTagName;
    }

    public String getPasswordInputTagName() {
        return this.passwordInputTagName;
    }
}

