/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.authentication;

import com.jayway.restassured.internal.assertion.AssertParameter;
import java.security.KeyStore;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class CertificateAuthSettings {
    private static final int UNDEFINED_PORT = -1;
    private final String keystoreType;
    private final int port;
    private final KeyStore trustStore;
    private final X509HostnameVerifier x509HostnameVerifier;

    public CertificateAuthSettings() {
        this(KeyStore.getDefaultType(), -1, null, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
    }

    private CertificateAuthSettings(String keystoreType, int port, KeyStore trustStore, X509HostnameVerifier x509HostnameVerifier) {
        AssertParameter.notNull((Object)keystoreType, (String)"Certificate type");
        this.keystoreType = keystoreType;
        this.port = port;
        this.trustStore = trustStore;
        this.x509HostnameVerifier = x509HostnameVerifier;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public int getPort() {
        return this.port;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public CertificateAuthSettings strictHostnames() {
        return new CertificateAuthSettings(this.keystoreType, this.port, this.trustStore, SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
    }

    public CertificateAuthSettings allowAllHostnames() {
        return new CertificateAuthSettings(this.keystoreType, this.port, this.trustStore, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }

    public CertificateAuthSettings x509HostnameVerifier(X509HostnameVerifier x509HostnameVerifier) {
        return new CertificateAuthSettings(this.keystoreType, this.port, this.trustStore, x509HostnameVerifier);
    }

    public X509HostnameVerifier getX509HostnameVerifier() {
        return this.x509HostnameVerifier;
    }

    public CertificateAuthSettings keystoreType(String keystoreType) {
        return new CertificateAuthSettings(keystoreType, this.port, this.trustStore, this.x509HostnameVerifier);
    }

    public CertificateAuthSettings port(int port) {
        return new CertificateAuthSettings(this.keystoreType, port, this.trustStore, this.x509HostnameVerifier);
    }

    public CertificateAuthSettings trustStore(KeyStore trustStore) {
        return new CertificateAuthSettings(this.keystoreType, this.port, trustStore, this.x509HostnameVerifier);
    }

    public CertificateAuthSettings and() {
        return this;
    }

    public CertificateAuthSettings with() {
        return this;
    }

    public CertificateAuthSettings using() {
        return this;
    }

    public static CertificateAuthSettings certAuthSettings() {
        return new CertificateAuthSettings();
    }
}

