/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.filter.log;

import com.jayway.restassured.filter.Filter;
import com.jayway.restassured.filter.FilterContext;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.FilterableRequestSpecification;
import com.jayway.restassured.specification.FilterableResponseSpecification;
import java.io.PrintStream;
import org.apache.commons.lang.Validate;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StatusCodeBasedLoggingFilter
implements Filter {
    private final PrintStream stream;
    private Matcher<?> matcher;

    public StatusCodeBasedLoggingFilter(Matcher<Integer> matcher) {
        this(System.out, matcher);
    }

    public StatusCodeBasedLoggingFilter(PrintStream stream, Matcher<Integer> matcher) {
        this.matcher = matcher;
        Validate.notNull((Object)stream, (String)"Print stream cannot be null");
        Validate.notNull(matcher, (String)"Matcher cannot be null");
        this.stream = stream;
    }

    @Override
    public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
        Response response = ctx.next(requestSpec, responseSpec);
        int statusCode = response.statusCode();
        if (this.matcher.matches((Object)statusCode)) {
            this.stream.println(response.asString());
        }
        return response;
    }
}

