/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.builder;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.ResponseSpecificationImpl;
import com.jayway.restassured.internal.SpecificationMerger;
import com.jayway.restassured.specification.ResponseSpecification;
import groovyx.net.http.ContentType;
import java.util.Map;
import org.hamcrest.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseSpecBuilder {
    private final ResponseSpecification spec = new ResponseSpecificationImpl(RestAssured.rootPath, RestAssured.responseContentType(), RestAssured.responseSpecification);

    public ResponseSpecBuilder expectContent(Matcher<?> matcher) {
        this.spec.content(matcher, new Matcher[0]);
        return this;
    }

    public ResponseSpecBuilder expectContent(String key, Matcher<?> matcher) {
        this.spec.content(key, matcher, new Object[0]);
        return this;
    }

    public ResponseSpecBuilder expectStatusCode(Matcher<Integer> expectedStatusCode) {
        this.spec.statusCode(expectedStatusCode);
        return this;
    }

    public ResponseSpecBuilder expectStatusCode(int expectedStatusCode) {
        this.spec.statusCode(expectedStatusCode);
        return this;
    }

    public ResponseSpecBuilder expectStatusLine(Matcher<String> expectedStatusLine) {
        this.spec.statusLine(expectedStatusLine);
        return this;
    }

    public ResponseSpecBuilder expectStatusLine(String expectedStatusLine) {
        this.spec.statusLine(expectedStatusLine);
        return this;
    }

    public ResponseSpecBuilder expectHeaders(Map<String, Object> expectedHeaders) {
        this.spec.headers(expectedHeaders);
        return this;
    }

    public ResponseSpecBuilder expectHeader(String headerName, Matcher<String> expectedValueMatcher) {
        this.spec.header(headerName, expectedValueMatcher);
        return this;
    }

    public ResponseSpecBuilder expectHeader(String headerName, String expectedValue) {
        this.spec.header(headerName, expectedValue);
        return this;
    }

    public ResponseSpecBuilder expectCookies(Map<String, Object> expectedCookies) {
        this.spec.cookies(expectedCookies);
        return this;
    }

    public ResponseSpecBuilder expectCookie(String cookieName, Matcher<String> expectedValueMatcher) {
        this.spec.cookie(cookieName, expectedValueMatcher);
        return this;
    }

    public ResponseSpecBuilder expectCookie(String cookieName, String expectedValue) {
        this.spec.cookie(cookieName, expectedValue);
        return this;
    }

    public ResponseSpecBuilder expectCookie(String cookieName) {
        this.spec.cookie(cookieName);
        return this;
    }

    public ResponseSpecBuilder rootPath(String rootPath) {
        this.spec.rootPath(rootPath);
        return this;
    }

    public ResponseSpecBuilder expectContentType(ContentType contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public ResponseSpecBuilder expectContentType(String contentType) {
        this.spec.contentType(contentType);
        return this;
    }

    public ResponseSpecBuilder expectBody(Matcher<?> matcher) {
        this.spec.body(matcher, new Matcher[0]);
        return this;
    }

    public ResponseSpecBuilder expectBody(String key, Matcher<?> matcher) {
        this.spec.body(key, matcher, new Object[0]);
        return this;
    }

    public ResponseSpecBuilder addResponseSpecification(ResponseSpecification specification) {
        if (!(specification instanceof ResponseSpecificationImpl)) {
            throw new IllegalArgumentException("specification must be of type " + ResponseSpecificationImpl.class.getClass() + ".");
        }
        ResponseSpecificationImpl rs = (ResponseSpecificationImpl)specification;
        SpecificationMerger.merge((ResponseSpecificationImpl)this.spec, rs);
        return this;
    }

    public ResponseSpecification build() {
        return this.spec;
    }
}

