/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.path.json;

import com.jayway.restassured.internal.assertion.AssertParameter;
import com.jayway.restassured.internal.path.ObjectConverter;
import com.jayway.restassured.internal.path.json.ConfigurableJsonSlurper;
import com.jayway.restassured.internal.path.json.JSONAssertion;
import com.jayway.restassured.internal.path.json.JsonPrettifier;
import com.jayway.restassured.internal.path.json.mapping.JsonObjectDeserializer;
import com.jayway.restassured.mapper.factory.GsonObjectMapperFactory;
import com.jayway.restassured.mapper.factory.Jackson1ObjectMapperFactory;
import com.jayway.restassured.mapper.factory.Jackson2ObjectMapperFactory;
import com.jayway.restassured.path.json.config.JsonParserType;
import com.jayway.restassured.path.json.config.JsonPathConfig;
import com.jayway.restassured.path.json.exception.JsonPathException;
import groovy.json.JsonBuilder;
import groovy.json.JsonOutput;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonPath {
    public static JsonPathConfig config = null;
    private final JsonParser jsonParser;
    private JsonPathConfig jsonPathConfig = null;
    private String rootPath = "";

    public JsonPath(String text) {
        this.jsonParser = this.parseText(text);
    }

    public JsonPath(URL url) {
        this.jsonParser = this.parseURL(url);
    }

    public JsonPath(InputStream stream) {
        this.jsonParser = this.parseInputStream(stream);
    }

    public JsonPath(File file) {
        this.jsonParser = this.parseFile(file);
    }

    public JsonPath(Reader reader) {
        this.jsonParser = this.parseReader(reader);
    }

    private JsonPath(JsonPath jsonPath, JsonPathConfig jsonPathConfig) {
        this.jsonPathConfig = jsonPathConfig;
        this.jsonParser = jsonPath.jsonParser;
        this.rootPath = jsonPath.rootPath;
    }

    public <T> T get() {
        return this.get("");
    }

    public <T> T get(String path) {
        JSONAssertion jsonAssertion = this.createJsonAssertion(path);
        Object json = this.jsonParser.parseWith(this.createConfigurableJsonSlurper());
        return (T)jsonAssertion.getResult(json);
    }

    public boolean getBoolean(String path) {
        return (Boolean)ObjectConverter.convertObjectTo(this.get(path), Boolean.class);
    }

    public char getChar(String path) {
        return ((Character)ObjectConverter.convertObjectTo(this.get(path), Character.class)).charValue();
    }

    public int getInt(String path) {
        Object value = this.get(path);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return (Integer)ObjectConverter.convertObjectTo(value, Integer.class);
    }

    public byte getByte(String path) {
        Object value = this.get(path);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Long) {
            return ((Long)value).byteValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).byteValue();
        }
        return (Byte)ObjectConverter.convertObjectTo(value, Byte.class);
    }

    public short getShort(String path) {
        Object value = this.get(path);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Long) {
            return ((Long)value).shortValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).shortValue();
        }
        return (Short)ObjectConverter.convertObjectTo(value, Short.class);
    }

    public float getFloat(String path) {
        Object value = this.get(path);
        if (value instanceof Double) {
            return ((Double)value).floatValue();
        }
        return ((Float)ObjectConverter.convertObjectTo(value, Float.class)).floatValue();
    }

    public double getDouble(String path) {
        Object value = this.get(path);
        if (value instanceof Double) {
            return (Double)value;
        }
        return (Double)ObjectConverter.convertObjectTo(value, Double.class);
    }

    public long getLong(String path) {
        Object value = this.get(path);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Short) {
            return ((Short)value).longValue();
        }
        if (value instanceof Integer) {
            return ((Integer)value).longValue();
        }
        return (Long)ObjectConverter.convertObjectTo(value, Long.class);
    }

    public String getString(String path) {
        return (String)ObjectConverter.convertObjectTo(this.get(path), String.class);
    }

    public <T> List<T> getList(String path) {
        return (List)this.get(path);
    }

    public <T> List<T> getList(String path, Class<T> genericType) {
        List original = (List)this.get(path);
        LinkedList<Object> newList = new LinkedList<Object>();
        for (Object t : original) {
            newList.add(ObjectConverter.convertObjectTo(t, genericType));
        }
        return Collections.unmodifiableList(newList);
    }

    public <K, V> Map<K, V> getMap(String path) {
        return (Map)this.get(path);
    }

    public <K, V> Map<K, V> getMap(String path, Class<K> keyType, Class<V> valueType) {
        Map originalMap = (Map)this.get(path);
        HashMap<Object, Object> newMap = new HashMap<Object, Object>();
        for (Map.Entry entry : originalMap.entrySet()) {
            Object key = entry.getKey() == null ? null : ObjectConverter.convertObjectTo(entry.getKey(), keyType);
            Object value = entry.getValue() == null ? null : ObjectConverter.convertObjectTo(entry.getValue(), valueType);
            newMap.put(key, value);
        }
        return Collections.unmodifiableMap(newMap);
    }

    public <T> T getObject(String path, Class<T> objectType) {
        Object object = this.getJsonObject(path);
        if (object == null) {
            return null;
        }
        if (!(object instanceof List) && !(object instanceof Map)) {
            return (T)ObjectConverter.convertObjectTo(object, objectType);
        }
        object = new JsonBuilder(object).toString();
        JsonPathConfig cfg = new JsonPathConfig(this.getJsonPathConfig());
        if (cfg.hasCustomJackson10ObjectMapperFactory()) {
            cfg = cfg.defaultParserType(JsonParserType.JACKSON_1);
        } else if (cfg.hasCustomGsonObjectMapperFactory()) {
            cfg = cfg.defaultParserType(JsonParserType.GSON);
        } else if (cfg.hasCustomJackson20ObjectMapperFactory()) {
            cfg = cfg.defaultParserType(JsonParserType.JACKSON_2);
        }
        if (!(object instanceof String)) {
            throw new IllegalStateException("Internal error: Json object was not an instance of String, please report to the REST Assured mailing-list.");
        }
        return JsonObjectDeserializer.deserialize((String)object, objectType, cfg);
    }

    public String prettify() {
        Object json = this.jsonParser.parseWith(this.createConfigurableJsonSlurper());
        return JsonPrettifier.prettifyJson(JsonOutput.toJson((Object)json));
    }

    public String prettyPrint() {
        String pretty = this.prettify();
        System.out.println(pretty);
        return pretty;
    }

    public JsonPath using(GsonObjectMapperFactory factory) {
        return new JsonPath(this, this.jsonPathConfig.gsonObjectMapperFactory(factory));
    }

    public JsonPath using(Jackson1ObjectMapperFactory factory) {
        return new JsonPath(this, this.getJsonPathConfig().jackson1ObjectMapperFactory(factory));
    }

    public JsonPath using(Jackson2ObjectMapperFactory factory) {
        return new JsonPath(this, this.getJsonPathConfig().jackson2ObjectMapperFactory(factory));
    }

    public JsonPath using(JsonPathConfig config) {
        return new JsonPath(this, config);
    }

    public JsonPath and() {
        return this;
    }

    public static JsonPath given(String text) {
        return new JsonPath(text);
    }

    public static JsonPath given(InputStream stream) {
        return new JsonPath(stream);
    }

    public static JsonPath given(File file) {
        return new JsonPath(file);
    }

    public static JsonPath given(Reader reader) {
        return new JsonPath(reader);
    }

    public static JsonPath given(URL url) {
        return new JsonPath(url);
    }

    public static JsonPath with(InputStream stream) {
        return new JsonPath(stream);
    }

    public static JsonPath with(String text) {
        return new JsonPath(text);
    }

    public static JsonPath with(File file) {
        return new JsonPath(file);
    }

    public static JsonPath with(Reader reader) {
        return new JsonPath(reader);
    }

    public static JsonPath with(URL url) {
        return new JsonPath(url);
    }

    public static JsonPath from(InputStream stream) {
        return new JsonPath(stream);
    }

    public static JsonPath from(String text) {
        return new JsonPath(text);
    }

    public static JsonPath from(File file) {
        return new JsonPath(file);
    }

    public static JsonPath from(Reader reader) {
        return new JsonPath(reader);
    }

    public static JsonPath from(URL url) {
        return new JsonPath(url);
    }

    public JsonPath setRoot(String rootPath) {
        AssertParameter.notNull((Object)rootPath, (String)"Root path");
        this.rootPath = rootPath;
        return this;
    }

    private JsonParser parseInputStream(final InputStream stream) {
        return new JsonParser(){

            public Object doParseWith(final ConfigurableJsonSlurper slurper) {
                return new ExceptionCatcher(){

                    protected Object method() throws Exception {
                        return slurper.parse(JsonPath.this.toReader(stream));
                    }
                }.invoke();
            }
        };
    }

    private JsonParser parseReader(final Reader reader) {
        return new JsonParser(){

            public Object doParseWith(final ConfigurableJsonSlurper slurper) {
                return new ExceptionCatcher(){

                    protected Object method() throws Exception {
                        return slurper.parse(reader);
                    }
                }.invoke();
            }
        };
    }

    private JsonParser parseFile(final File file) {
        return new JsonParser(){

            public Object doParseWith(final ConfigurableJsonSlurper slurper) {
                return new ExceptionCatcher(){

                    protected Object method() throws Exception {
                        return slurper.parse(new FileReader(file));
                    }
                }.invoke();
            }
        };
    }

    private JsonParser parseText(final String text) {
        return new JsonParser(){

            public Object doParseWith(final ConfigurableJsonSlurper slurper) {
                return new ExceptionCatcher(){

                    protected Object method() throws Exception {
                        return slurper.parseText(text);
                    }
                }.invoke();
            }
        };
    }

    private JsonParser parseURL(final URL url) {
        return new JsonParser(){

            public Object doParseWith(final ConfigurableJsonSlurper slurper) {
                return new ExceptionCatcher(){

                    protected Object method() throws Exception {
                        return slurper.parse(JsonPath.this.toReader(url.openStream()));
                    }
                }.invoke();
            }
        };
    }

    private BufferedReader toReader(InputStream in) {
        JsonPathConfig cfg = this.getJsonPathConfig();
        try {
            return new BufferedReader(new InputStreamReader(in, cfg.charset()));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Charset is invalid", e);
        }
    }

    public <T> T getJsonObject(String path) {
        JSONAssertion jsonAssertion = this.createJsonAssertion(path);
        Object json = this.jsonParser.parseWith(this.createConfigurableJsonSlurper());
        return (T)jsonAssertion.getAsJsonObject(json);
    }

    private JSONAssertion createJsonAssertion(String path) {
        AssertParameter.notNull((Object)path, (String)"path");
        JSONAssertion jsonAssertion = new JSONAssertion();
        String root = this.rootPath.equals("") ? this.rootPath : (this.rootPath.endsWith(".") ? this.rootPath : this.rootPath + ".");
        jsonAssertion.setKey(root + path);
        return jsonAssertion;
    }

    private ConfigurableJsonSlurper createConfigurableJsonSlurper() {
        JsonPathConfig cfg = this.getJsonPathConfig();
        return new ConfigurableJsonSlurper(cfg.shouldRepresentJsonNumbersAsBigDecimal());
    }

    private JsonPathConfig getJsonPathConfig() {
        JsonPathConfig cfg = config == null && this.jsonPathConfig == null ? new JsonPathConfig() : (this.jsonPathConfig != null ? this.jsonPathConfig : config);
        return cfg;
    }

    public static void reset() {
        config = null;
    }

    private abstract class JsonParser {
        private Object json;

        private JsonParser() {
        }

        public final Object parseWith(ConfigurableJsonSlurper slurper) {
            if (this.json == null) {
                this.json = this.doParseWith(slurper);
            }
            return this.json;
        }

        abstract Object doParseWith(ConfigurableJsonSlurper var1);
    }

    private abstract class ExceptionCatcher {
        private ExceptionCatcher() {
        }

        protected abstract Object method() throws Exception;

        public Object invoke() {
            try {
                return this.method();
            }
            catch (Exception e) {
                throw new JsonPathException("Failed to parse the JSON document", e);
            }
        }
    }
}

