/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng;

import com.javadocmd.simplelatlng.LatLng;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

public class Geohasher {
    public static final int PRECISION = 12;
    private static final int BITS = 30;
    private static final double MAX_LAT = 90.0;
    private static final double MAX_LNG = 180.0;
    private static final char[] HASH_CHARS_ARRAY;
    private static final Map<Character, Integer> HASH_CHARS_MAP;
    private static final double[] LAT_BIT_VALUES;
    private static final double[] LNG_BIT_VALUES;

    public static LatLng decode(String hash) {
        BitSet[] b = Geohasher.deInterleave(Geohasher.hashToBits(hash));
        double lat = Geohasher.bitsToDouble(b[1], LAT_BIT_VALUES);
        double lng = Geohasher.bitsToDouble(b[0], LNG_BIT_VALUES);
        return new LatLng(lat, lng);
    }

    private static BitSet hashToBits(String hash) {
        try {
            BitStore bits = new BitStore();
            char[] chars = hash.toLowerCase().toCharArray();
            int offset = (chars.length - 1) * 5;
            for (int i = 0; i < chars.length; ++i) {
                int value = HASH_CHARS_MAP.get(Character.valueOf(chars[i]));
                for (int x = 0; x < 5; ++x) {
                    ((BitSet)bits).set(offset + x, (value & 1) == 1);
                    value >>= 1;
                }
                offset -= 5;
            }
            return bits;
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Geohash string contains invalid characters.");
        }
    }

    private static BitSet[] deInterleave(BitSet bits) {
        BitSet[] sets = new BitSet[]{new BitStore(), new BitStore()};
        int n = bits.size();
        for (int i = 0; i < n; ++i) {
            sets[i % 2].set(i / 2, bits.get(i));
        }
        return sets;
    }

    private static double bitsToDouble(BitSet bits, double[] bitValues) {
        double value = 0.0;
        int n = bits.size();
        for (int i = 0; i < n; ++i) {
            if (bits.get(n - i - 1)) {
                value += bitValues[i];
                continue;
            }
            value -= bitValues[i];
        }
        return value;
    }

    public static String hash(LatLng point) {
        return Geohasher.bitsToHash(Geohasher.interleave(Geohasher.doubleToBits(point.getLongitude(), 180.0), Geohasher.doubleToBits(point.getLatitude(), 90.0)));
    }

    private static String bitsToHash(BitSet bits) {
        StringBuilder hash = new StringBuilder();
        for (int i = 0; i < bits.size(); i += 5) {
            int value = 0;
            for (int j = 0; j < 5; ++j) {
                if (!bits.get(i + j)) continue;
                value |= 1 << j;
            }
            hash.insert(0, HASH_CHARS_ARRAY[value]);
        }
        return hash.toString();
    }

    private static BitSet interleave(BitSet evenBits, BitSet oddBits) {
        BitStore bits = new BitStore();
        for (int i = 0; i < evenBits.size() + oddBits.size(); ++i) {
            if (i % 2 == 0) {
                ((BitSet)bits).set(i, evenBits.get(i / 2));
                continue;
            }
            ((BitSet)bits).set(i, oddBits.get(i / 2));
        }
        return bits;
    }

    private static BitSet doubleToBits(double value, double maxRange) {
        BitStore bits = new BitStore();
        double maxValue = maxRange;
        double minValue = -maxRange;
        for (int i = 0; i < 30; ++i) {
            double midValue = (maxValue + minValue) / 2.0;
            if (value >= midValue) {
                ((BitSet)bits).set(30 - i - 1);
                minValue = midValue;
                continue;
            }
            ((BitSet)bits).set(30 - i - 1, false);
            maxValue = midValue;
        }
        return bits;
    }

    static {
        int i;
        HASH_CHARS_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        double latValue = 90.0;
        double lngValue = 180.0;
        LAT_BIT_VALUES = new double[30];
        LNG_BIT_VALUES = new double[30];
        for (i = 0; i < 30; ++i) {
            Geohasher.LAT_BIT_VALUES[i] = latValue /= 2.0;
            Geohasher.LNG_BIT_VALUES[i] = lngValue /= 2.0;
        }
        HASH_CHARS_MAP = new HashMap<Character, Integer>(HASH_CHARS_ARRAY.length);
        for (i = 0; i < HASH_CHARS_ARRAY.length; ++i) {
            HASH_CHARS_MAP.put(Character.valueOf(HASH_CHARS_ARRAY[i]), i);
        }
    }

    private static class BitStore
    extends BitSet {
        private static final long serialVersionUID = 4630759467120792604L;
        private int highestBit = -1;

        private BitStore() {
        }

        private void updateHighestBit(int bitIndex) {
            if (bitIndex > this.highestBit) {
                this.highestBit = bitIndex;
            }
        }

        @Override
        public void set(int bitIndex) {
            super.set(bitIndex);
            this.updateHighestBit(bitIndex);
        }

        @Override
        public void set(int bitIndex, boolean value) {
            super.set(bitIndex, value);
            this.updateHighestBit(bitIndex);
        }

        @Override
        public void set(int fromIndex, int toIndex) {
            super.set(fromIndex, toIndex);
            this.updateHighestBit(toIndex);
        }

        @Override
        public void set(int fromIndex, int toIndex, boolean value) {
            super.set(fromIndex, toIndex, value);
            this.updateHighestBit(toIndex);
        }

        @Override
        public void flip(int bitIndex) {
            super.flip(bitIndex);
            this.updateHighestBit(bitIndex);
        }

        @Override
        public void flip(int fromIndex, int toIndex) {
            super.flip(fromIndex, toIndex);
            this.updateHighestBit(toIndex);
        }

        @Override
        public int size() {
            return this.highestBit + 1;
        }
    }
}

