/*
 * Decompiled with CFR 0.152.
 */
package com.javadocmd.simplelatlng;

import com.javadocmd.simplelatlng.LatLng;
import com.javadocmd.simplelatlng.util.LatLngConfig;
import com.javadocmd.simplelatlng.util.LengthUnit;

public class LatLngTool {
    public static double distance(LatLng point1, LatLng point2, LengthUnit unit) {
        return LatLngTool.distanceInRadians(point1, point2) * LatLngConfig.getEarthRadius(unit);
    }

    public static double distanceInRadians(LatLng point1, LatLng point2) {
        double lat1R = Math.toRadians(point1.getLatitude());
        double lat2R = Math.toRadians(point2.getLatitude());
        double dLatR = Math.abs(lat2R - lat1R);
        double dLngR = Math.abs(Math.toRadians(point2.getLongitude() - point1.getLongitude()));
        double a = Math.sin(dLatR / 2.0) * Math.sin(dLatR / 2.0) + Math.cos(lat1R) * Math.cos(lat2R) * Math.sin(dLngR / 2.0) * Math.sin(dLngR / 2.0);
        return 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
    }

    public static double normalizeLatitude(double latitude) {
        if (Double.isNaN(latitude)) {
            return Double.NaN;
        }
        if (latitude > 0.0) {
            return Math.min(latitude, 90.0);
        }
        return Math.max(latitude, -90.0);
    }

    public static double normalizeLongitude(double longitude) {
        if (Double.isNaN(longitude) || Double.isInfinite(longitude)) {
            return Double.NaN;
        }
        double longitudeResult = longitude % 360.0;
        if (longitudeResult > 180.0) {
            double diff = longitudeResult - 180.0;
            longitudeResult = -180.0 + diff;
        } else if (longitudeResult < -180.0) {
            double diff = longitudeResult + 180.0;
            longitudeResult = 180.0 + diff;
        }
        return longitudeResult;
    }

    private LatLngTool() {
    }
}

