/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.processes.models;

import android.os.Parcel;
import android.os.Parcelable;
import com.jaredrummler.android.processes.models.ControlGroup;
import com.jaredrummler.android.processes.models.ProcFile;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;

public final class Cgroup
extends ProcFile {
    public final ArrayList<ControlGroup> groups;
    public static final Parcelable.Creator<Cgroup> CREATOR = new Parcelable.Creator<Cgroup>(){

        public Cgroup createFromParcel(Parcel source) {
            return new Cgroup(source);
        }

        public Cgroup[] newArray(int size) {
            return new Cgroup[size];
        }
    };

    public static Cgroup get(int pid) throws IOException {
        return new Cgroup(String.format(Locale.ENGLISH, "/proc/%d/cgroup", pid));
    }

    private Cgroup(String path) throws IOException {
        super(path);
        String[] lines = this.content.split("\n");
        this.groups = new ArrayList();
        for (String line : lines) {
            try {
                this.groups.add(new ControlGroup(line));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Cgroup(Parcel in) {
        super(in);
        this.groups = in.createTypedArrayList(ControlGroup.CREATOR);
    }

    public ControlGroup getGroup(String subsystem) {
        for (ControlGroup group : this.groups) {
            String[] systems;
            for (String name : systems = group.subsystems.split(",")) {
                if (!name.equals(subsystem)) continue;
                return group;
            }
        }
        return null;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeTypedList(this.groups);
    }
}

