/*
 * Decompiled with CFR 0.152.
 */
package com.jaredrummler.android.processes.models;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.jaredrummler.android.processes.models.AndroidProcess;
import com.jaredrummler.android.processes.models.Cgroup;
import com.jaredrummler.android.processes.models.ControlGroup;
import com.jaredrummler.android.processes.models.Stat;
import com.jaredrummler.android.processes.models.Status;
import java.io.File;
import java.io.IOException;

public class AndroidAppProcess
extends AndroidProcess {
    private static final boolean SYS_SUPPORTS_SCHEDGROUPS = new File("/dev/cpuctl/tasks").exists();
    public boolean foreground;
    public int uid;
    public static final Parcelable.Creator<AndroidAppProcess> CREATOR = new Parcelable.Creator<AndroidAppProcess>(){

        public AndroidAppProcess createFromParcel(Parcel source) {
            return new AndroidAppProcess(source);
        }

        public AndroidAppProcess[] newArray(int size) {
            return new AndroidAppProcess[size];
        }
    };

    public AndroidAppProcess(int pid) throws IOException, NotAndroidAppProcessException {
        super(pid);
        if (Build.VERSION.SDK_INT >= 21 && SYS_SUPPORTS_SCHEDGROUPS) {
            Cgroup cgroup = super.cgroup();
            ControlGroup cpuacct = cgroup.getGroup("cpuacct");
            ControlGroup cpu = cgroup.getGroup("cpu");
            if (cpu == null || cpuacct == null || !cpuacct.group.contains("pid_")) {
                throw new NotAndroidAppProcessException(pid);
            }
            this.foreground = !cpu.group.contains("bg_non_interactive");
            try {
                this.uid = Integer.parseInt(cpuacct.group.split("/")[1].replace("uid_", ""));
            }
            catch (Exception e) {
                this.uid = this.status().getUid();
            }
        } else {
            if (this.name.startsWith("/") || !new File("/data/data", this.name).exists()) {
                throw new NotAndroidAppProcessException(pid);
            }
            Stat stat = this.stat();
            Status status = this.status();
            this.foreground = stat.policy() == 0;
            this.uid = status.getUid();
        }
    }

    public String getPackageName() {
        return this.name.split(":")[0];
    }

    public PackageInfo getPackageInfo(Context context, int flags) throws PackageManager.NameNotFoundException {
        return context.getPackageManager().getPackageInfo(this.getPackageName(), flags);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeByte((byte)(this.foreground ? 1 : 0));
    }

    protected AndroidAppProcess(Parcel in) {
        super(in);
        this.foreground = in.readByte() != 0;
    }

    public static final class NotAndroidAppProcessException
    extends Exception {
        public NotAndroidAppProcessException(int pid) {
            super(String.format("The process %d does not belong to any application", pid));
        }
    }
}

